/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ClusterLoadParameters;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.PartitionLoadParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.stats.BrokerStats;

public class LoadRunnable
extends OperationRunnable {
    protected final long _start;
    protected final long _end;
    protected final ModelCompletenessRequirements _modelCompletenessRequirements;
    protected final boolean _allowCapacityEstimation;
    protected final boolean _populateDiskInfo;
    protected final boolean _capacityOnly;

    public LoadRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, PartitionLoadParameters parameters) {
        super(kafkaCruiseControl, future);
        this._start = parameters.startMs();
        this._end = parameters.endMs();
        Double minValidPartitionRatio = parameters.minValidPartitionRatio();
        if (minValidPartitionRatio == null) {
            minValidPartitionRatio = kafkaCruiseControl.config().getDouble("min.valid.partition.ratio");
        }
        this._modelCompletenessRequirements = new ModelCompletenessRequirements(1, minValidPartitionRatio, true);
        this._allowCapacityEstimation = parameters.allowCapacityEstimation();
        this._populateDiskInfo = false;
        this._capacityOnly = false;
    }

    public LoadRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, ClusterLoadParameters parameters) {
        super(kafkaCruiseControl, future);
        this._start = parameters.startMs();
        this._end = parameters.endMs();
        this._modelCompletenessRequirements = parameters.requirements();
        this._allowCapacityEstimation = parameters.allowCapacityEstimation();
        this._populateDiskInfo = parameters.populateDiskInfo();
        this._capacityOnly = parameters.capacityOnly();
    }

    @Override
    protected BrokerStats getResult() throws Exception {
        if (!this._populateDiskInfo) {
            BrokerStats cachedBrokerStats = this._kafkaCruiseControl.cachedBrokerLoadStats(this._allowCapacityEstimation);
            if (cachedBrokerStats != null) {
                return cachedBrokerStats;
            }
        } else if (this.isClusterUsingJBOD()) {
            throw new UserRequestException(String.format("Cannot set %s=true for non-JBOD Kafka clusters.", "populate_disk_info"));
        }
        if (this._start != -1L) {
            return this.clusterModel(this._modelCompletenessRequirements.minMonitoredPartitionsPercentage()).brokerStats(this._kafkaCruiseControl.config());
        }
        return this.clusterModelFromEarliest().brokerStats(this._kafkaCruiseControl.config());
    }

    private boolean isClusterUsingJBOD() throws Exception {
        ClusterModel clusterModel = this._kafkaCruiseControl.loadMonitor().clusterCapacity();
        return clusterModel.brokers().stream().allMatch(Broker::isUsingJBOD);
    }

    public ClusterModel clusterModelFromEarliest() throws KafkaCruiseControlException {
        return this.clusterModel(-1L, this._modelCompletenessRequirements);
    }

    public ClusterModel clusterModel(double minValidPartitionRatio) throws KafkaCruiseControlException {
        return this.clusterModel(this._start, new ModelCompletenessRequirements(1, minValidPartitionRatio, false));
    }

    protected ClusterModel clusterModel(long start, ModelCompletenessRequirements requirements) throws KafkaCruiseControlException {
        ClusterModel clusterModel;
        block9: {
            OperationProgress operationProgress = this._future.operationProgress();
            LoadMonitor.AutoCloseableSemaphore ignored = this._kafkaCruiseControl.acquireForModelGeneration(operationProgress);
            try {
                ClusterModel clusterModel2 = clusterModel = this._capacityOnly ? this._kafkaCruiseControl.clusterCapacity() : this._kafkaCruiseControl.clusterModel(start, this._end, requirements, this._populateDiskInfo, this._allowCapacityEstimation, operationProgress);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (KafkaCruiseControlException kcce) {
                    throw kcce;
                }
                catch (Exception e) {
                    throw new KafkaCruiseControlException(e);
                }
            }
            ignored.close();
        }
        return clusterModel;
    }
}

