/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.GoalBasedOptimizationParameters;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public abstract class GoalBasedOperationRunnable
extends OperationRunnable {
    protected final List<String> _goals;
    protected final ModelCompletenessRequirements _modelCompletenessRequirements;
    protected final boolean _dryRun;
    protected final boolean _stopOngoingExecution;
    protected final boolean _skipHardGoalCheck;
    protected final Pattern _excludedTopics;
    protected final boolean _allowCapacityEstimation;
    protected final boolean _excludeRecentlyDemotedBrokers;
    protected final boolean _excludeRecentlyRemovedBrokers;
    protected final String _uuid;
    protected final Supplier<String> _reasonSupplier;
    protected final boolean _isTriggeredByUserRequest;
    protected OperationProgress _operationProgress;
    protected ModelCompletenessRequirements _combinedCompletenessRequirements;
    protected List<Goal> _goalsByPriority;

    public GoalBasedOperationRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, GoalBasedOptimizationParameters parameters, boolean dryRun, boolean stopOngoingExecution, boolean skipHardGoalCheck, String uuid, Supplier<String> reasonSupplier, boolean isTriggeredByUserRequest) {
        this(kafkaCruiseControl, future, dryRun, parameters.goals(), stopOngoingExecution, parameters.modelCompletenessRequirements(), skipHardGoalCheck, parameters.excludedTopics(), parameters.allowCapacityEstimation(), parameters.excludeRecentlyDemotedBrokers(), parameters.excludeRecentlyRemovedBrokers(), uuid, reasonSupplier, isTriggeredByUserRequest);
    }

    public GoalBasedOperationRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, List<String> goals, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, String uuid, Supplier<String> reasonSupplier, boolean isTriggeredByUserRequest) {
        this(kafkaCruiseControl, future, false, goals, false, RunnableUtils.SELF_HEALING_MODEL_COMPLETENESS_REQUIREMENTS, false, RunnableUtils.SELF_HEALING_EXCLUDED_TOPICS, allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, uuid, reasonSupplier, isTriggeredByUserRequest);
    }

    public GoalBasedOperationRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, boolean dryRun, List<String> goals, boolean stopOngoingExecution, ModelCompletenessRequirements modelCompletenessRequirements, boolean skipHardGoalCheck, Pattern excludedTopics, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, String uuid, Supplier<String> reasonSupplier, boolean isTriggeredByUserRequest) {
        super(kafkaCruiseControl, future);
        this._goals = goals;
        this._modelCompletenessRequirements = modelCompletenessRequirements;
        this._dryRun = dryRun;
        this._stopOngoingExecution = stopOngoingExecution;
        this._skipHardGoalCheck = skipHardGoalCheck;
        this._excludedTopics = excludedTopics;
        this._allowCapacityEstimation = allowCapacityEstimation;
        this._excludeRecentlyDemotedBrokers = excludeRecentlyDemotedBrokers;
        this._excludeRecentlyRemovedBrokers = excludeRecentlyRemovedBrokers;
        this._uuid = uuid;
        this._reasonSupplier = reasonSupplier;
        this._isTriggeredByUserRequest = isTriggeredByUserRequest;
        this._operationProgress = null;
        this._combinedCompletenessRequirements = null;
        this._goalsByPriority = null;
    }

    protected void init() {
        this._kafkaCruiseControl.sanityCheckDryRun(this._dryRun, this._stopOngoingExecution);
        KafkaCruiseControlConfig config = this._kafkaCruiseControl.config();
        KafkaCruiseControlUtils.sanityCheckGoals(this._goals, this._skipHardGoalCheck, config);
        this._goalsByPriority = KafkaCruiseControlUtils.goalsByPriority(this._goals, config);
        this._operationProgress = this._future.operationProgress();
        if (this._stopOngoingExecution) {
            RunnableUtils.maybeStopOngoingExecutionToModifyAndWait(this._kafkaCruiseControl, this._operationProgress);
        }
        this._combinedCompletenessRequirements = this._kafkaCruiseControl.modelCompletenessRequirements(this._goalsByPriority).weaker(this._modelCompletenessRequirements);
        KafkaCruiseControlUtils.sanityCheckLoadMonitorReadiness(this._combinedCompletenessRequirements, this._kafkaCruiseControl.getLoadMonitorTaskRunnerState());
    }

    protected void handleFailGeneratingProposalsForExecution() {
        if (!this._dryRun) {
            this._kafkaCruiseControl.failGeneratingProposalsForExecution(this._uuid);
        }
    }

    public OptimizerResult computeResult() throws KafkaCruiseControlException {
        OptimizerResult result;
        block20: {
            this.init();
            if (!this._dryRun) {
                this._kafkaCruiseControl.setGeneratingProposalsForExecution(this._uuid, this._reasonSupplier, this._isTriggeredByUserRequest);
            }
            if (this.shouldWorkWithClusterModel()) {
                try (LoadMonitor.AutoCloseableSemaphore ignored = this._kafkaCruiseControl.acquireForModelGeneration(this._operationProgress);){
                    result = this.workWithClusterModel();
                    break block20;
                }
                catch (KafkaCruiseControlException kcce) {
                    this.handleFailGeneratingProposalsForExecution();
                    throw kcce;
                }
                catch (Exception e) {
                    this.handleFailGeneratingProposalsForExecution();
                    throw new KafkaCruiseControlException(e);
                }
                finally {
                    this.finish();
                }
            }
            try {
                result = this.workWithoutClusterModel();
            }
            catch (KafkaCruiseControlException kcce) {
                this.handleFailGeneratingProposalsForExecution();
                throw kcce;
            }
            catch (Exception e) {
                this.handleFailGeneratingProposalsForExecution();
                throw new KafkaCruiseControlException(e);
            }
            finally {
                this.finish();
            }
        }
        return result;
    }

    protected abstract boolean shouldWorkWithClusterModel();

    protected abstract OptimizerResult workWithoutClusterModel() throws KafkaCruiseControlException;

    protected abstract OptimizerResult workWithClusterModel() throws KafkaCruiseControlException, TimeoutException, NotEnoughValidWindowsException;

    protected void finish() {
        this._operationProgress = null;
        this._combinedCompletenessRequirements = null;
        if (this._goalsByPriority != null) {
            this._goalsByPriority.clear();
        }
    }
}

