/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.CruiseControlStateParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.CruiseControlState;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.Cluster;

public class GetStateRunnable
extends OperationRunnable {
    protected final Set<CruiseControlState.SubState> _substates;

    public GetStateRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, CruiseControlStateParameters parameters) {
        super(kafkaCruiseControl, future);
        this._substates = parameters.substates();
    }

    @Override
    public CruiseControlState getResult() {
        HashSet<CruiseControlState.SubState> substates = !this._substates.isEmpty() ? this._substates : new HashSet<CruiseControlState.SubState>(Arrays.asList(CruiseControlState.SubState.values()));
        Cluster cluster = null;
        if (RunnableUtils.shouldRefreshClusterAndGeneration(substates)) {
            cluster = this._kafkaCruiseControl.refreshClusterAndGeneration().cluster();
        }
        return new CruiseControlState(substates.contains((Object)CruiseControlState.SubState.EXECUTOR) ? this._kafkaCruiseControl.executorState() : null, substates.contains((Object)CruiseControlState.SubState.MONITOR) ? this._kafkaCruiseControl.monitorState(cluster) : null, substates.contains((Object)CruiseControlState.SubState.ANALYZER) ? this._kafkaCruiseControl.analyzerState(cluster) : null, substates.contains((Object)CruiseControlState.SubState.ANOMALY_DETECTOR) ? this._kafkaCruiseControl.anomalyDetectorState() : null, this._kafkaCruiseControl.config());
    }
}

