/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.PreferredLeaderElectionGoal;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.DemoteBrokerParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class DemoteBrokerRunnable
extends GoalBasedOperationRunnable {
    protected final Set<Integer> _brokerIds;
    protected final Integer _concurrentLeaderMovements;
    protected final Long _executionProgressCheckIntervalMs;
    protected final boolean _skipUrpDemotion;
    protected final boolean _excludeFollowerDemotion;
    protected final ReplicaMovementStrategy _replicaMovementStrategy;
    protected final Long _replicationThrottle;
    protected final Map<Integer, Set<String>> _brokerIdAndLogdirs;

    public DemoteBrokerRunnable(KafkaCruiseControl kafkaCruiseControl, Set<Integer> demotedBrokerIds, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, String anomalyId, Supplier<String> reasonSupplier) {
        super(kafkaCruiseControl, new OperationFuture("Slow Broker Self-Healing"), false, null, false, null, true, null, allowCapacityEstimation, excludeRecentlyDemotedBrokers, false, anomalyId, reasonSupplier, false);
        this._brokerIds = demotedBrokerIds;
        this._concurrentLeaderMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._executionProgressCheckIntervalMs = RunnableUtils.SELF_HEALING_EXECUTION_PROGRESS_CHECK_INTERVAL_MS;
        this._skipUrpDemotion = true;
        this._excludeFollowerDemotion = true;
        this._replicaMovementStrategy = RunnableUtils.SELF_HEALING_REPLICA_MOVEMENT_STRATEGY;
        this._replicationThrottle = kafkaCruiseControl.config().getLong("default.replication.throttle");
        this._brokerIdAndLogdirs = Collections.emptyMap();
    }

    public DemoteBrokerRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, String uuid, DemoteBrokerParameters parameters) {
        super(kafkaCruiseControl, future, parameters.dryRun(), null, parameters.stopOngoingExecution(), null, true, null, parameters.allowCapacityEstimation(), parameters.excludeRecentlyDemotedBrokers(), false, uuid, parameters::reason, true);
        this._brokerIds = parameters.brokerIds();
        this._concurrentLeaderMovements = parameters.concurrentLeaderMovements();
        this._executionProgressCheckIntervalMs = parameters.executionProgressCheckIntervalMs();
        this._skipUrpDemotion = parameters.skipUrpDemotion();
        this._excludeFollowerDemotion = parameters.excludeFollowerDemotion();
        this._replicaMovementStrategy = parameters.replicaMovementStrategy();
        this._replicationThrottle = parameters.replicationThrottle();
        this._brokerIdAndLogdirs = parameters.brokerIdAndLogdirs();
    }

    @Override
    protected OptimizationResult getResult() throws Exception {
        return new OptimizationResult(this.computeResult(), this._kafkaCruiseControl.config());
    }

    @Override
    protected void init() {
        this._kafkaCruiseControl.sanityCheckDryRun(this._dryRun, this._stopOngoingExecution);
        this._goalsByPriority = new ArrayList(1);
        this._goalsByPriority.add(new PreferredLeaderElectionGoal(this._skipUrpDemotion, this._excludeFollowerDemotion, this._skipUrpDemotion ? this._kafkaCruiseControl.kafkaCluster() : null));
        this._operationProgress = this._future.operationProgress();
        if (this._stopOngoingExecution) {
            RunnableUtils.maybeStopOngoingExecutionToModifyAndWait(this._kafkaCruiseControl, this._operationProgress);
        }
        this._combinedCompletenessRequirements = ((Goal)this._goalsByPriority.get(0)).clusterModelCompletenessRequirements();
    }

    protected void setDemoteState(ClusterModel clusterModel) {
        if (!clusterModel.isClusterAlive()) {
            throw new IllegalArgumentException("All brokers are dead in the cluster.");
        }
        this._brokerIds.forEach(id -> clusterModel.setBrokerState((int)id, Broker.State.DEMOTED));
        this._brokerIdAndLogdirs.forEach((brokerid, logdirs) -> {
            Broker broker = clusterModel.broker((int)brokerid);
            for (String logdir : logdirs) {
                if (broker.disk(logdir) == null) {
                    throw new IllegalStateException(String.format("Broker %d does not have logdir %s.", brokerid, logdir));
                }
                broker.disk(logdir).setState(Disk.State.DEMOTED);
            }
        });
    }

    @Override
    protected OptimizerResult workWithClusterModel() throws KafkaCruiseControlException, TimeoutException, NotEnoughValidWindowsException {
        KafkaCruiseControlUtils.ensureDisjoint(this._brokerIds, this._brokerIdAndLogdirs.keySet(), "Attempt to demote the broker and its disk in the same request is not allowed.");
        HashSet<Integer> brokersToCheckPresence = new HashSet<Integer>(this._brokerIds);
        brokersToCheckPresence.addAll(this._brokerIdAndLogdirs.keySet());
        this._kafkaCruiseControl.sanityCheckBrokerPresence(brokersToCheckPresence);
        ClusterModel clusterModel = this._brokerIdAndLogdirs.isEmpty() ? this._kafkaCruiseControl.clusterModel(this._combinedCompletenessRequirements, this._allowCapacityEstimation, this._operationProgress) : this._kafkaCruiseControl.clusterModel(-1L, this._kafkaCruiseControl.timeMs(), this._combinedCompletenessRequirements, true, this._allowCapacityEstimation, this._operationProgress);
        this.setDemoteState(clusterModel);
        OptimizationOptions optimizationOptions = RunnableUtils.computeOptimizationOptions(clusterModel, false, this._kafkaCruiseControl, Collections.emptySet(), this._dryRun, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._excludedTopics, Collections.emptySet(), false);
        OptimizerResult result = this._kafkaCruiseControl.optimizations(clusterModel, this._goalsByPriority, this._operationProgress, null, optimizationOptions);
        if (!this._dryRun) {
            this._kafkaCruiseControl.executeDemotion(result.goalProposals(), this._brokerIds, this._concurrentLeaderMovements, clusterModel.brokers().size(), this._executionProgressCheckIntervalMs, this._replicaMovementStrategy, this._replicationThrottle, this._isTriggeredByUserRequest, this._uuid);
        }
        return result;
    }

    @Override
    protected boolean shouldWorkWithClusterModel() {
        return true;
    }

    @Override
    protected OptimizerResult workWithoutClusterModel() {
        return null;
    }
}

