/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.executor.strategy.ReplicaMovementStrategy;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.GoalBasedOperationRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.RunnableUtils;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.AddBrokerParameters;
import com.linkedin.kafka.cruisecontrol.servlet.response.OptimizationResult;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class AddBrokersRunnable
extends GoalBasedOperationRunnable {
    protected final Set<Integer> _brokerIds;
    protected final boolean _throttleAddedBrokers;
    protected final Integer _concurrentInterBrokerPartitionMovements;
    protected final Integer _concurrentLeaderMovements;
    protected final Long _executionProgressCheckIntervalMs;
    protected final ReplicaMovementStrategy _replicaMovementStrategy;
    protected final Long _replicationThrottle;
    protected static final boolean SKIP_AUTO_REFRESHING_CONCURRENCY = false;

    public AddBrokersRunnable(KafkaCruiseControl kafkaCruiseControl, Set<Integer> brokerIds, List<String> selfHealingGoals, boolean allowCapacityEstimation, boolean excludeRecentlyDemotedBrokers, boolean excludeRecentlyRemovedBrokers, String anomalyId, Supplier<String> reasonSupplier) {
        super(kafkaCruiseControl, new OperationFuture("Broker Addition Self-Healing"), selfHealingGoals, allowCapacityEstimation, excludeRecentlyDemotedBrokers, excludeRecentlyRemovedBrokers, anomalyId, reasonSupplier, false);
        this._brokerIds = brokerIds;
        this._throttleAddedBrokers = false;
        this._concurrentInterBrokerPartitionMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._concurrentLeaderMovements = RunnableUtils.SELF_HEALING_CONCURRENT_MOVEMENTS;
        this._executionProgressCheckIntervalMs = RunnableUtils.SELF_HEALING_EXECUTION_PROGRESS_CHECK_INTERVAL_MS;
        this._replicaMovementStrategy = RunnableUtils.SELF_HEALING_REPLICA_MOVEMENT_STRATEGY;
        this._replicationThrottle = kafkaCruiseControl.config().getLong("default.replication.throttle");
    }

    public AddBrokersRunnable(KafkaCruiseControl kafkaCruiseControl, OperationFuture future, AddBrokerParameters parameters, String uuid) {
        super(kafkaCruiseControl, future, parameters, parameters.dryRun(), parameters.stopOngoingExecution(), parameters.skipHardGoalCheck(), uuid, parameters::reason, true);
        this._brokerIds = parameters.brokerIds();
        this._throttleAddedBrokers = parameters.throttleAddedBrokers();
        this._concurrentInterBrokerPartitionMovements = parameters.concurrentInterBrokerPartitionMovements();
        this._concurrentLeaderMovements = parameters.concurrentLeaderMovements();
        this._executionProgressCheckIntervalMs = parameters.executionProgressCheckIntervalMs();
        this._replicaMovementStrategy = parameters.replicaMovementStrategy();
        this._replicationThrottle = parameters.replicationThrottle();
    }

    @Override
    protected OptimizationResult getResult() throws Exception {
        return new OptimizationResult(this.computeResult(), this._kafkaCruiseControl.config());
    }

    @Override
    protected OptimizerResult workWithClusterModel() throws KafkaCruiseControlException, TimeoutException, NotEnoughValidWindowsException {
        this._kafkaCruiseControl.sanityCheckBrokerPresence(this._brokerIds);
        ClusterModel clusterModel = this._kafkaCruiseControl.clusterModel(this._combinedCompletenessRequirements, this._allowCapacityEstimation, this._operationProgress);
        RunnableUtils.sanityCheckBrokersHavingOfflineReplicasOnBadDisks(this._goals, clusterModel);
        this._brokerIds.forEach(id -> clusterModel.setBrokerState((int)id, Broker.State.NEW));
        if (!clusterModel.isClusterAlive()) {
            throw new IllegalArgumentException("All brokers are dead in the cluster.");
        }
        OptimizationOptions optimizationOptions = RunnableUtils.computeOptimizationOptions(clusterModel, false, this._kafkaCruiseControl, this._brokerIds, this._dryRun, this._excludeRecentlyDemotedBrokers, this._excludeRecentlyRemovedBrokers, this._excludedTopics, Collections.emptySet(), false);
        OptimizerResult result = this._kafkaCruiseControl.optimizations(clusterModel, this._goalsByPriority, this._operationProgress, null, optimizationOptions);
        if (!this._dryRun) {
            this._kafkaCruiseControl.executeProposals(result.goalProposals(), this._throttleAddedBrokers ? Collections.emptySet() : this._brokerIds, RunnableUtils.isKafkaAssignerMode(this._goals), this._concurrentInterBrokerPartitionMovements, null, this._concurrentLeaderMovements, this._executionProgressCheckIntervalMs, this._replicaMovementStrategy, this._replicationThrottle, this._isTriggeredByUserRequest, this._uuid, false);
        }
        return result;
    }

    @Override
    protected boolean shouldWorkWithClusterModel() {
        return true;
    }

    @Override
    protected OptimizerResult workWithoutClusterModel() {
        return null;
    }
}

