/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async;

import com.linkedin.kafka.cruisecontrol.servlet.handler.async.AbstractAsyncRequest;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.PartitionLoadRunnable;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.PartitionLoadParameters;
import java.util.Map;

public class PartitionLoadRequest
extends AbstractAsyncRequest {
    protected PartitionLoadParameters _parameters;

    @Override
    protected OperationFuture handle(String uuid) {
        OperationFuture future = new OperationFuture(String.format("Get partition load from %d to %d", this._parameters.startMs(), this._parameters.endMs()));
        this.pending(future.operationProgress());
        this._asyncKafkaCruiseControl.sessionExecutor().submit(new PartitionLoadRunnable(this._asyncKafkaCruiseControl, future, this._parameters));
        return future;
    }

    @Override
    public PartitionLoadParameters parameters() {
        return this._parameters;
    }

    @Override
    public String name() {
        return PartitionLoadRequest.class.getSimpleName();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._parameters = (PartitionLoadParameters)configs.get("partition.load.parameter.object");
        if (this._parameters == null) {
            throw new IllegalArgumentException("Parameter configuration is missing from the request.");
        }
    }
}

