/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler.async;

import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.cruisecontrol.servlet.response.CruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.async.AsyncKafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.async.progress.Pending;
import com.linkedin.kafka.cruisecontrol.servlet.UserTaskManager;
import com.linkedin.kafka.cruisecontrol.servlet.handler.AbstractRequest;
import com.linkedin.kafka.cruisecontrol.servlet.handler.async.runnable.OperationFuture;
import com.linkedin.kafka.cruisecontrol.servlet.response.ProgressResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncRequest
extends AbstractRequest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncRequest.class);
    protected AsyncKafkaCruiseControl _asyncKafkaCruiseControl;
    private ThreadLocal<Integer> _asyncOperationStep;
    private UserTaskManager _userTaskManager;
    private long _maxBlockMs;

    protected abstract OperationFuture handle(String var1);

    @Override
    public CruiseControlResponse getResponse(HttpServletRequest request, HttpServletResponse response) throws ExecutionException, InterruptedException {
        CruiseControlResponse ccResponse;
        LOG.info("Processing async request {}.", (Object)this.name());
        int step = this._asyncOperationStep.get();
        List<OperationFuture> futures = this._userTaskManager.getOrCreateUserTask(request, response, this::handle, step, true, this.parameters());
        this._asyncOperationStep.set(step + 1);
        try {
            ccResponse = (CruiseControlResponse)futures.get(step).get(this._maxBlockMs, TimeUnit.MILLISECONDS);
            LOG.info("Computation is completed for async request: {}.", (Object)request.getPathInfo());
        }
        catch (TimeoutException te) {
            ccResponse = new ProgressResult(futures, this._asyncKafkaCruiseControl.config());
            LOG.info("Computation is in progress for async request: {}.", (Object)request.getPathInfo());
        }
        return ccResponse;
    }

    @Override
    public abstract CruiseControlParameters parameters();

    public abstract String name();

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this._asyncKafkaCruiseControl = this._servlet.asyncKafkaCruiseControl();
        this._asyncOperationStep = this._servlet.asyncOperationStep();
        this._userTaskManager = this._servlet.userTaskManager();
        this._maxBlockMs = this._asyncKafkaCruiseControl.config().getLong("webserver.request.maxBlockTimeMs");
    }

    protected void pending(OperationProgress progress) {
        progress.addStep(new Pending());
    }
}

