/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet.handler;

import com.linkedin.cruisecontrol.servlet.handler.Request;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.cruisecontrol.servlet.response.CruiseControlResponse;
import com.linkedin.kafka.cruisecontrol.servlet.KafkaCruiseControlServlet;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest
implements Request {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRequest.class);
    protected KafkaCruiseControlServlet _servlet;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ExecutionException, InterruptedException {
        if (this.parameters().parseParameters(response)) {
            LOG.warn("Failed to parse parameters: {} for request: {}.", (Object)request.getParameterMap(), (Object)request.getPathInfo());
            return;
        }
        CruiseControlResponse ccResponse = this.getResponse(request, response);
        ccResponse.writeSuccessResponse(this.parameters(), response);
    }

    protected abstract CruiseControlResponse getResponse(HttpServletRequest var1, HttpServletResponse var2) throws ExecutionException, InterruptedException;

    public abstract CruiseControlParameters parameters();

    public void configure(Map<String, ?> configs) {
        this._servlet = (KafkaCruiseControlServlet)((Object)configs.get("kafka.cruise.control.servlet.object"));
        if (this._servlet == null) {
            throw new IllegalArgumentException("Kafka Cruise Control servlet configuration is missing from the request.");
        }
    }
}

