/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet;

import com.linkedin.cruisecontrol.common.config.ConfigException;
import com.linkedin.cruisecontrol.servlet.EndPoint;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.RequestParameterWrapper;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndPoint;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.response.ResponseUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class KafkaCruiseControlServletUtils {
    public static final String REQUEST_URI = "/KAFKACRUISECONTROL/";
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    public static final String KAFKA_CRUISE_CONTROL_SERVLET_OBJECT_CONFIG = "kafka.cruise.control.servlet.object";
    public static final String KAFKA_CRUISE_CONTROL_HTTP_SERVLET_REQUEST_OBJECT_CONFIG = "kafka.cruise.control.http.servlet.request.object";
    public static final String KAFKA_CRUISE_CONTROL_CONFIG_OBJECT_CONFIG = "kafka.cruise.control.config.object";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String ACCESS_CONTROL_MAX_AGE_IN_SEC = "1728000";
    private static final Map<EndPoint, RequestParameterWrapper> REQUEST_PARAMETER_CONFIGS;
    static final String[] HEADERS_TO_TRY;

    private KafkaCruiseControlServletUtils() {
    }

    public static RequestParameterWrapper requestParameterFor(EndPoint endpoint) {
        return REQUEST_PARAMETER_CONFIGS.get(endpoint);
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        for (String header : HEADERS_TO_TRY) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    static String urlEncode(String s) throws UnsupportedEncodingException {
        return s == null ? null : URLEncoder.encode(s, StandardCharsets.UTF_8.name());
    }

    static CruiseControlEndPoint getValidEndpoint(HttpServletRequest request, HttpServletResponse response, KafkaCruiseControlConfig config) throws IOException {
        CruiseControlEndPoint endPoint = ParameterUtils.endPoint(request);
        if (endPoint == null) {
            String method = request.getMethod();
            String errorMessage = String.format("Unrecognized endpoint in request '%s'%nSupported %s endpoints: %s", request.getPathInfo(), method, method.equals(GET_METHOD) ? CruiseControlEndPoint.getEndpoints() : CruiseControlEndPoint.postEndpoints());
            ResponseUtils.writeErrorResponse(response, null, errorMessage, 404, ParameterUtils.wantJSON(request), ParameterUtils.wantResponseSchema(request), config);
            return null;
        }
        return endPoint;
    }

    static String handleUserRequestException(UserRequestException ure, HttpServletRequest request, HttpServletResponse response, KafkaCruiseControlConfig config) throws IOException {
        String errorMessage = String.format("Bad %s request '%s' due to '%s'.", request.getMethod(), request.getPathInfo(), ure.getMessage());
        ResponseUtils.writeErrorResponse(response, ure, errorMessage, 400, ParameterUtils.wantJSON(request), ParameterUtils.wantResponseSchema(request), config);
        return errorMessage;
    }

    static String handleConfigException(ConfigException ce, HttpServletRequest request, HttpServletResponse response, KafkaCruiseControlConfig config) throws IOException {
        String errorMessage = String.format("Cannot process %s request '%s' due to: '%s'.", request.getMethod(), request.getPathInfo(), ce.getMessage());
        ResponseUtils.writeErrorResponse(response, (Exception)((Object)ce), errorMessage, 403, ParameterUtils.wantJSON(request), ParameterUtils.wantResponseSchema(request), config);
        return errorMessage;
    }

    static String handleException(Exception e, HttpServletRequest request, HttpServletResponse response, KafkaCruiseControlConfig config) throws IOException {
        String errorMessage = String.format("Error processing %s request '%s' due to: '%s'.", request.getMethod(), request.getPathInfo(), e.getMessage());
        ResponseUtils.writeErrorResponse(response, e, errorMessage, 500, ParameterUtils.wantJSON(request), ParameterUtils.wantResponseSchema(request), config);
        return errorMessage;
    }

    static void handleOptions(HttpServletResponse response, KafkaCruiseControlConfig config) {
        response.setStatus(200);
        if (config.getBoolean("webserver.http.cors.enabled").booleanValue()) {
            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, config.getString("webserver.http.cors.origin"));
            response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, config.getString("webserver.http.cors.allowmethods"));
            response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, config.getString("webserver.http.cors.exposeheaders"));
            response.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
            response.setHeader(ACCESS_CONTROL_MAX_AGE, ACCESS_CONTROL_MAX_AGE_IN_SEC);
        }
    }

    static void ensureHeaderNotPresent(HttpServletRequest request, String headerName) {
        String value = request.getHeader(headerName);
        if (value != null) {
            throw new IllegalArgumentException(String.format("Unexpected header %s (value: %s) in the request.", value, headerName));
        }
    }

    public static String httpServletRequestToString(HttpServletRequest request) {
        return String.format("%s %s", request.getMethod(), request.getRequestURI());
    }

    static {
        HashMap<CruiseControlEndPoint, RequestParameterWrapper> requestParameterConfigs = new HashMap<CruiseControlEndPoint, RequestParameterWrapper>(CruiseControlEndPoint.cachedValues().size());
        RequestParameterWrapper bootstrap = new RequestParameterWrapper("bootstrap.parameters.class", "bootstrap.parameter.object", "bootstrap.request.class");
        RequestParameterWrapper train = new RequestParameterWrapper("train.parameters.class", "train.parameter.object", "train.request.class");
        RequestParameterWrapper load = new RequestParameterWrapper("load.parameters.class", "load.parameter.object", "load.request.class");
        RequestParameterWrapper partitionLoad = new RequestParameterWrapper("partition.load.parameters.class", "partition.load.parameter.object", "partition.load.request.class");
        RequestParameterWrapper proposals = new RequestParameterWrapper("proposals.parameters.class", "proposals.parameter.object", "proposals.request.class");
        RequestParameterWrapper state = new RequestParameterWrapper("state.parameters.class", "state.parameter.object", "state.request.class");
        RequestParameterWrapper addBroker = new RequestParameterWrapper("add.broker.parameters.class", "add.broker.parameter.object", "add.broker.request.class");
        RequestParameterWrapper removeBroker = new RequestParameterWrapper("remove.broker.parameters.class", "remove.broker.parameter.object", "remove.broker.request.class");
        RequestParameterWrapper fixOfflineReplicas = new RequestParameterWrapper("fix.offline.replicas.parameters.class", "fix.offline.replicas.parameter.object", "fix.offline.replicas.request.class");
        RequestParameterWrapper demoteBroker = new RequestParameterWrapper("demote.broker.parameters.class", "demote.broker.parameter.object", "demote.broker.request.class");
        RequestParameterWrapper rebalance = new RequestParameterWrapper("rebalance.parameters.class", "rebalance.parameter.object", "rebalance.request.class");
        RequestParameterWrapper stopProposalExecution = new RequestParameterWrapper("stop.proposal.parameters.class", "stop.proposal.parameter.object", "stop.proposal.request.class");
        RequestParameterWrapper pauseSampling = new RequestParameterWrapper("pause.sampling.parameters.class", "pause.resume.parameter.object", "pause.sampling.request.class");
        RequestParameterWrapper resumeSampling = new RequestParameterWrapper("resume.sampling.parameters.class", "pause.resume.parameter.object", "resume.sampling.request.class");
        RequestParameterWrapper kafkaClusterState = new RequestParameterWrapper("kafka.cluster.state.parameters.class", "kafka.cluster.state.parameter.object", "kafka.cluster.state.request.class");
        RequestParameterWrapper userTasks = new RequestParameterWrapper("user.tasks.parameters.class", "user.tasks.parameter.object", "user.tasks.request.class");
        RequestParameterWrapper admin = new RequestParameterWrapper("admin.parameters.class", "admin.parameter.object", "admin.request.class");
        RequestParameterWrapper review = new RequestParameterWrapper("review.parameters.class", "review.parameter.object", "review.request.class");
        RequestParameterWrapper reviewBoard = new RequestParameterWrapper("review.board.parameters.class", "review.board.parameter.object", "review.board.request.class");
        RequestParameterWrapper topicConfiguration = new RequestParameterWrapper("topic.configuration.parameters.class", "topic.configuration.parameter.object", "topic.configuration.request.class");
        requestParameterConfigs.put(CruiseControlEndPoint.BOOTSTRAP, bootstrap);
        requestParameterConfigs.put(CruiseControlEndPoint.TRAIN, train);
        requestParameterConfigs.put(CruiseControlEndPoint.LOAD, load);
        requestParameterConfigs.put(CruiseControlEndPoint.PARTITION_LOAD, partitionLoad);
        requestParameterConfigs.put(CruiseControlEndPoint.PROPOSALS, proposals);
        requestParameterConfigs.put(CruiseControlEndPoint.STATE, state);
        requestParameterConfigs.put(CruiseControlEndPoint.ADD_BROKER, addBroker);
        requestParameterConfigs.put(CruiseControlEndPoint.REMOVE_BROKER, removeBroker);
        requestParameterConfigs.put(CruiseControlEndPoint.FIX_OFFLINE_REPLICAS, fixOfflineReplicas);
        requestParameterConfigs.put(CruiseControlEndPoint.DEMOTE_BROKER, demoteBroker);
        requestParameterConfigs.put(CruiseControlEndPoint.REBALANCE, rebalance);
        requestParameterConfigs.put(CruiseControlEndPoint.STOP_PROPOSAL_EXECUTION, stopProposalExecution);
        requestParameterConfigs.put(CruiseControlEndPoint.PAUSE_SAMPLING, pauseSampling);
        requestParameterConfigs.put(CruiseControlEndPoint.RESUME_SAMPLING, resumeSampling);
        requestParameterConfigs.put(CruiseControlEndPoint.KAFKA_CLUSTER_STATE, kafkaClusterState);
        requestParameterConfigs.put(CruiseControlEndPoint.USER_TASKS, userTasks);
        requestParameterConfigs.put(CruiseControlEndPoint.ADMIN, admin);
        requestParameterConfigs.put(CruiseControlEndPoint.REVIEW, review);
        requestParameterConfigs.put(CruiseControlEndPoint.REVIEW_BOARD, reviewBoard);
        requestParameterConfigs.put(CruiseControlEndPoint.TOPIC_CONFIGURATION, topicConfiguration);
        REQUEST_PARAMETER_CONFIGS = Collections.unmodifiableMap(requestParameterConfigs);
        HEADERS_TO_TRY = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
    }
}

