/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.linkedin.cruisecontrol.common.config.ConfigException;
import com.linkedin.cruisecontrol.servlet.EndPoint;
import com.linkedin.cruisecontrol.servlet.handler.Request;
import com.linkedin.cruisecontrol.servlet.parameters.CruiseControlParameters;
import com.linkedin.kafka.cruisecontrol.async.AsyncKafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.config.RequestParameterWrapper;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndPoint;
import com.linkedin.kafka.cruisecontrol.servlet.KafkaCruiseControlServletUtils;
import com.linkedin.kafka.cruisecontrol.servlet.UserRequestException;
import com.linkedin.kafka.cruisecontrol.servlet.UserTaskManager;
import com.linkedin.kafka.cruisecontrol.servlet.parameters.ParameterUtils;
import com.linkedin.kafka.cruisecontrol.servlet.purgatory.Purgatory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCruiseControlServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaCruiseControlServlet.class);
    private final AsyncKafkaCruiseControl _asyncKafkaCruiseControl;
    private final KafkaCruiseControlConfig _config;
    private final UserTaskManager _userTaskManager;
    private final ThreadLocal<Integer> _asyncOperationStep;
    private final Map<EndPoint, Meter> _requestMeter = new HashMap<EndPoint, Meter>();
    private final Map<EndPoint, Timer> _successfulRequestExecutionTimer = new HashMap<EndPoint, Timer>();
    private final boolean _twoStepVerification;
    private final Purgatory _purgatory;

    public KafkaCruiseControlServlet(AsyncKafkaCruiseControl asynckafkaCruiseControl, MetricRegistry dropwizardMetricRegistry) {
        this._config = asynckafkaCruiseControl.config();
        this._asyncKafkaCruiseControl = asynckafkaCruiseControl;
        this._twoStepVerification = this._config.getBoolean("two.step.verification.enabled");
        this._purgatory = this._twoStepVerification ? new Purgatory(this._config) : null;
        this._userTaskManager = new UserTaskManager(this._config, dropwizardMetricRegistry, this._successfulRequestExecutionTimer, this._purgatory);
        this._asyncKafkaCruiseControl.setUserTaskManagerInExecutor(this._userTaskManager);
        this._asyncOperationStep = new ThreadLocal();
        this._asyncOperationStep.set(0);
        for (CruiseControlEndPoint endpoint : CruiseControlEndPoint.cachedValues()) {
            this._requestMeter.put(endpoint, dropwizardMetricRegistry.meter(MetricRegistry.name((String)"KafkaCruiseControlServlet", (String[])new String[]{endpoint.name() + "-request-rate"})));
            this._successfulRequestExecutionTimer.put(endpoint, dropwizardMetricRegistry.timer(MetricRegistry.name((String)"KafkaCruiseControlServlet", (String[])new String[]{endpoint.name() + "-successful-request-execution-timer"})));
        }
    }

    public void destroy() {
        super.destroy();
        this._userTaskManager.close();
        if (this._purgatory != null) {
            this._purgatory.close();
        }
    }

    public AsyncKafkaCruiseControl asyncKafkaCruiseControl() {
        return this._asyncKafkaCruiseControl;
    }

    public Map<EndPoint, Timer> successfulRequestExecutionTimer() {
        return this._successfulRequestExecutionTimer;
    }

    public ThreadLocal<Integer> asyncOperationStep() {
        return this._asyncOperationStep;
    }

    public UserTaskManager userTaskManager() {
        return this._userTaskManager;
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        KafkaCruiseControlServletUtils.handleOptions(response, this._config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetOrPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGetOrPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doGetOrPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this._asyncOperationStep.set(0);
            CruiseControlEndPoint endPoint = KafkaCruiseControlServletUtils.getValidEndpoint(request, response, this._config);
            if (endPoint == null) return;
            this._requestMeter.get((Object)endPoint).mark();
            HashMap<String, Object> requestConfigOverrides = new HashMap<String, Object>();
            requestConfigOverrides.put("kafka.cruise.control.servlet.object", (Object)this);
            HashMap<String, Object> parameterConfigOverrides = new HashMap<String, Object>();
            parameterConfigOverrides.put("kafka.cruise.control.http.servlet.request.object", request);
            parameterConfigOverrides.put("kafka.cruise.control.config.object", (Object)this._config);
            switch (request.getMethod()) {
                case "GET": {
                    this.handleGet(request, response, endPoint, requestConfigOverrides, parameterConfigOverrides);
                    return;
                }
                case "POST": {
                    this.handlePost(request, response, endPoint, requestConfigOverrides, parameterConfigOverrides);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported request method: " + request.getMethod() + ".");
                }
            }
        }
        catch (UserRequestException ure) {
            String errorMessage = KafkaCruiseControlServletUtils.handleUserRequestException(ure, request, response, this._config);
            LOG.error(errorMessage, (Throwable)ure);
            return;
        }
        catch (ConfigException ce) {
            String errorMessage = KafkaCruiseControlServletUtils.handleConfigException(ce, request, response, this._config);
            LOG.error(errorMessage, (Throwable)ce);
            return;
        }
        catch (Exception e) {
            String errorMessage = KafkaCruiseControlServletUtils.handleException(e, request, response, this._config);
            LOG.error(errorMessage, (Throwable)e);
            return;
        }
        finally {
            try {
                response.getOutputStream().close();
            }
            catch (IOException e) {
                LOG.warn("Error closing output stream: ", (Throwable)e);
            }
        }
    }

    private void handleGet(HttpServletRequest request, HttpServletResponse response, CruiseControlEndPoint endPoint, Map<String, Object> requestConfigOverrides, Map<String, Object> parameterConfigOverrides) throws InterruptedException, ExecutionException, IOException {
        if (endPoint == CruiseControlEndPoint.REVIEW_BOARD && !this._twoStepVerification) {
            throw new ConfigException(String.format("Attempt to access %s endpoint without enabling '%s' config.", new Object[]{endPoint, "two.step.verification.enabled"}));
        }
        RequestParameterWrapper requestParameter = KafkaCruiseControlServletUtils.requestParameterFor(endPoint);
        CruiseControlParameters parameters = this._config.getConfiguredInstance(requestParameter.parametersClass(), CruiseControlParameters.class, parameterConfigOverrides);
        if (ParameterUtils.hasValidParameterNames(request, response, this._config, parameters)) {
            requestConfigOverrides.put(requestParameter.parameterObject(), parameters);
            Request ccRequest = this._config.getConfiguredInstance(requestParameter.requestClass(), Request.class, requestConfigOverrides);
            ccRequest.handle(request, response);
        }
    }

    private void handlePost(HttpServletRequest request, HttpServletResponse response, CruiseControlEndPoint endPoint, Map<String, Object> requestConfigOverrides, Map<String, Object> parameterConfigOverrides) throws InterruptedException, ExecutionException, IOException {
        CruiseControlParameters parameters;
        RequestParameterWrapper requestParameter = KafkaCruiseControlServletUtils.requestParameterFor(endPoint);
        if (endPoint == CruiseControlEndPoint.REVIEW) {
            if (!this._twoStepVerification) {
                throw new ConfigException(String.format("Attempt to access %s endpoint without enabling '%s' config.", new Object[]{endPoint, "two.step.verification.enabled"}));
            }
            parameters = this._config.getConfiguredInstance(requestParameter.parametersClass(), CruiseControlParameters.class, parameterConfigOverrides);
            if (!ParameterUtils.hasValidParameterNames(request, response, this._config, parameters)) {
                return;
            }
        } else if (!this._twoStepVerification) {
            parameters = this._config.getConfiguredInstance(requestParameter.parametersClass(), CruiseControlParameters.class, parameterConfigOverrides);
            if (!ParameterUtils.hasValidParameterNames(request, response, this._config, parameters)) {
                return;
            }
        } else {
            parameters = this._purgatory.maybeAddToPurgatory(request, response, requestParameter.parametersClass(), parameterConfigOverrides, this._userTaskManager);
        }
        Request ccRequest = null;
        if (parameters != null) {
            requestConfigOverrides.put(requestParameter.parameterObject(), parameters);
            ccRequest = this._config.getConfiguredInstance(requestParameter.requestClass(), Request.class, requestConfigOverrides);
        }
        if (ccRequest != null) {
            ccRequest.handle(request, response);
        }
    }

    public List<UserTaskManager.UserTaskInfo> getAllUserTasks() {
        return this._userTaskManager.getAllUserTasks();
    }

    public Purgatory purgatory() {
        return this._purgatory;
    }
}

