/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.servlet;

import com.linkedin.cruisecontrol.servlet.EndPoint;
import com.linkedin.cruisecontrol.servlet.EndpointType;
import com.linkedin.kafka.cruisecontrol.servlet.CruiseControlEndpointType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum CruiseControlEndPoint implements EndPoint
{
    BOOTSTRAP(CruiseControlEndpointType.CRUISE_CONTROL_ADMIN),
    TRAIN(CruiseControlEndpointType.CRUISE_CONTROL_ADMIN),
    LOAD(CruiseControlEndpointType.KAFKA_MONITOR),
    PARTITION_LOAD(CruiseControlEndpointType.KAFKA_MONITOR),
    PROPOSALS(CruiseControlEndpointType.KAFKA_MONITOR),
    STATE(CruiseControlEndpointType.CRUISE_CONTROL_MONITOR),
    ADD_BROKER(CruiseControlEndpointType.KAFKA_ADMIN),
    REMOVE_BROKER(CruiseControlEndpointType.KAFKA_ADMIN),
    FIX_OFFLINE_REPLICAS(CruiseControlEndpointType.KAFKA_ADMIN),
    REBALANCE(CruiseControlEndpointType.KAFKA_ADMIN),
    STOP_PROPOSAL_EXECUTION(CruiseControlEndpointType.KAFKA_ADMIN),
    PAUSE_SAMPLING(CruiseControlEndpointType.CRUISE_CONTROL_ADMIN),
    RESUME_SAMPLING(CruiseControlEndpointType.CRUISE_CONTROL_ADMIN),
    KAFKA_CLUSTER_STATE(CruiseControlEndpointType.KAFKA_MONITOR),
    DEMOTE_BROKER(CruiseControlEndpointType.KAFKA_ADMIN),
    USER_TASKS(CruiseControlEndpointType.CRUISE_CONTROL_MONITOR),
    REVIEW_BOARD(CruiseControlEndpointType.CRUISE_CONTROL_MONITOR),
    ADMIN(CruiseControlEndpointType.CRUISE_CONTROL_ADMIN),
    REVIEW(CruiseControlEndpointType.CRUISE_CONTROL_ADMIN),
    TOPIC_CONFIGURATION(CruiseControlEndpointType.KAFKA_ADMIN);

    private final EndpointType _endpointType;
    private static final List<CruiseControlEndPoint> GET_ENDPOINTS;
    private static final List<CruiseControlEndPoint> POST_ENDPOINTS;
    private static final List<CruiseControlEndPoint> CACHED_VALUES;

    private CruiseControlEndPoint(EndpointType endpointType) {
        this._endpointType = endpointType;
    }

    public EndpointType endpointType() {
        return this._endpointType;
    }

    public static List<CruiseControlEndPoint> getEndpoints() {
        return GET_ENDPOINTS;
    }

    public static List<CruiseControlEndPoint> postEndpoints() {
        return POST_ENDPOINTS;
    }

    public static List<CruiseControlEndPoint> cachedValues() {
        return CACHED_VALUES;
    }

    static {
        GET_ENDPOINTS = Arrays.asList(BOOTSTRAP, TRAIN, LOAD, PARTITION_LOAD, PROPOSALS, STATE, KAFKA_CLUSTER_STATE, USER_TASKS, REVIEW_BOARD);
        POST_ENDPOINTS = Arrays.asList(ADD_BROKER, REMOVE_BROKER, FIX_OFFLINE_REPLICAS, REBALANCE, STOP_PROPOSAL_EXECUTION, PAUSE_SAMPLING, RESUME_SAMPLING, DEMOTE_BROKER, ADMIN, REVIEW, TOPIC_CONFIGURATION);
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(CruiseControlEndPoint.values()));
    }
}

