/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.kafka.cruisecontrol.model.LinearRegressionModelParameters;
import com.linkedin.kafka.cruisecontrol.model.ModelParameters;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleStore;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrainingTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TrainingTask.class);
    private final Time _time;
    private final LoadMonitorTaskRunner _loadMonitorTaskRunner;
    private final MetricFetcherManager _metricFetcherManager;
    private final SampleStore _sampleStore;
    private final long _samplingIntervalMs;
    private final long _configuredSnapshotWindowMs;
    private final long _trainingStartMs;
    private final long _trainingEndMs;
    private long _nextSamplingStartingMs;
    private long _nextSamplingEndMs;

    TrainingTask(Time time, LoadMonitorTaskRunner loadMonitorTaskRunner, MetricFetcherManager metricFetcherManager, SampleStore sampleStore, long configuredSnapshotWindowMs, long samplingIntervalMs, long trainingStartMs, long trainingEndMs) {
        this._time = time;
        this._loadMonitorTaskRunner = loadMonitorTaskRunner;
        this._metricFetcherManager = metricFetcherManager;
        this._sampleStore = sampleStore;
        this._configuredSnapshotWindowMs = configuredSnapshotWindowMs;
        this._samplingIntervalMs = samplingIntervalMs;
        this._trainingStartMs = trainingStartMs;
        this._trainingEndMs = trainingEndMs;
        this._nextSamplingStartingMs = trainingStartMs;
        this._nextSamplingEndMs = trainingStartMs + this._samplingIntervalMs;
    }

    private boolean isDone() {
        return ModelParameters.updateModelCoefficient() || this._nextSamplingEndMs >= this._trainingEndMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.info("Starting load model training task for time range [{}, {}]", (Object)this._trainingStartMs, (Object)this._trainingEndMs);
        long trainingTaskStartingMs = this._time.milliseconds();
        try {
            do {
                this._metricFetcherManager.fetchBrokerMetricSamples(this._nextSamplingStartingMs, this._nextSamplingEndMs, this._samplingIntervalMs, this._sampleStore);
                this._nextSamplingStartingMs += this._configuredSnapshotWindowMs;
                this._nextSamplingEndMs = Math.min(this._trainingEndMs, this._nextSamplingStartingMs + this._configuredSnapshotWindowMs);
            } while (!this.isDone());
            this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.TRAINING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
        }
        catch (Throwable t) {
            try {
                LOG.error("load model training task got exception.", t);
                this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.TRAINING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
            }
            catch (Throwable throwable) {
                this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.TRAINING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
                LOG.info("Load monitor finished training with time range [{}, {}] in {} seconds. Coefficients: {}, {}, {}", new Object[]{this._trainingStartMs, this._trainingEndMs, (this._time.milliseconds() - trainingTaskStartingMs) / 1000L, ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_IN), ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_OUT), ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.FOLLOWER_BYTES_IN)});
                throw throwable;
            }
            LOG.info("Load monitor finished training with time range [{}, {}] in {} seconds. Coefficients: {}, {}, {}", new Object[]{this._trainingStartMs, this._trainingEndMs, (this._time.milliseconds() - trainingTaskStartingMs) / 1000L, ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_IN), ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_OUT), ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.FOLLOWER_BYTES_IN)});
        }
        LOG.info("Load monitor finished training with time range [{}, {}] in {} seconds. Coefficients: {}, {}, {}", new Object[]{this._trainingStartMs, this._trainingEndMs, (this._time.milliseconds() - trainingTaskStartingMs) / 1000L, ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_IN), ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_OUT), ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.FOLLOWER_BYTES_IN)});
    }
}

