/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleStore;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamplingTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SamplingTask.class);
    private final long _samplingIntervalMs;
    private final Time _time;
    private final MetadataClient _metadataClient;
    private final LoadMonitorTaskRunner _loadMonitorTaskRunner;
    private final MetricFetcherManager _metricFetcherManager;
    private final SampleStore _sampleStore;
    private long _lastSamplingPeriodEndTimeMs;

    SamplingTask(long samplingIntervalMs, MetadataClient metadataClient, LoadMonitorTaskRunner loadMonitorTaskRunner, MetricFetcherManager metricFetcherManager, SampleStore sampleStore, Time time) {
        this._samplingIntervalMs = samplingIntervalMs;
        this._time = time;
        this._metadataClient = metadataClient;
        this._loadMonitorTaskRunner = loadMonitorTaskRunner;
        this._metricFetcherManager = metricFetcherManager;
        this._sampleStore = sampleStore;
        this._lastSamplingPeriodEndTimeMs = this._time.milliseconds() - this._samplingIntervalMs;
    }

    @Override
    public void run() {
        long now = this._time.milliseconds();
        if (!this._loadMonitorTaskRunner.awaitingPauseSampling() && this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.SAMPLING)) {
            long samplingPeriodEndMs = now;
            try {
                boolean hasSamplingError;
                long deadline = this._time.milliseconds() + this._samplingIntervalMs;
                do {
                    this._metadataClient.refreshMetadata();
                    samplingPeriodEndMs = this._time.milliseconds();
                    hasSamplingError = this._metricFetcherManager.fetchMetricSamples(this._lastSamplingPeriodEndTimeMs, samplingPeriodEndMs, deadline - now, this._sampleStore, this._loadMonitorTaskRunner.samplingMode());
                    if (!hasSamplingError) {
                        this._lastSamplingPeriodEndTimeMs = samplingPeriodEndMs;
                    }
                    if ((now = this._time.milliseconds()) <= deadline) continue;
                    throw new TimeoutException();
                } while (hasSamplingError);
            }
            catch (TimeoutException e) {
                LOG.warn("Sampling did not finish in {} ms, skipping this sampling interval.", (Object)this._samplingIntervalMs);
                this._lastSamplingPeriodEndTimeMs = samplingPeriodEndMs;
            }
            catch (Throwable t) {
                LOG.error("Uncaught exception in sampling", t);
                throw t;
            }
            finally {
                this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.SAMPLING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
            }
        } else {
            String reason = this._loadMonitorTaskRunner.reasonOfLatestPauseOrResume();
            LOG.info("Skip sampling because the load monitor is in {} state{}.", (Object)this._loadMonitorTaskRunner.state(), (Object)String.format(reason == null ? "" : " due to %s.", reason));
            this._lastSamplingPeriodEndTimeMs = now - this._samplingIntervalMs;
        }
    }
}

