/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.kafka.cruisecontrol.model.ModelParameters;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleStore;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaBrokerMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;

public class SampleLoadingTask
implements Runnable {
    private final SampleStore _sampleStore;
    private final KafkaPartitionMetricSampleAggregator _partitionMetricSampleAggregator;
    private final KafkaBrokerMetricSampleAggregator _brokerMetricSampleAggregator;
    private final LoadMonitorTaskRunner _loadMonitorTaskRunner;

    SampleLoadingTask(SampleStore sampleStore, KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator, KafkaBrokerMetricSampleAggregator brokerMetricSampleAggregator, LoadMonitorTaskRunner loadMonitorTaskRunner) {
        this._sampleStore = sampleStore;
        this._partitionMetricSampleAggregator = partitionMetricSampleAggregator;
        this._brokerMetricSampleAggregator = brokerMetricSampleAggregator;
        this._loadMonitorTaskRunner = loadMonitorTaskRunner;
    }

    @Override
    public void run() {
        try {
            this._sampleStore.loadSamples(new SampleStore.SampleLoader(this._partitionMetricSampleAggregator, this._brokerMetricSampleAggregator));
            ModelParameters.updateModelCoefficient();
        }
        finally {
            this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.LOADING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
        }
    }
}

