/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleStore;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import java.util.List;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootstrapTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapTask.class);
    public static final MetricSampler.SamplingMode DEFAULT_SAMPLING_MODE = MetricSampler.SamplingMode.ALL;
    private final Time _time;
    private final long _startMs;
    private final long _endMs;
    private final boolean _clearMetrics;
    private final BootstrapMode _mode;
    private final long _samplingIntervalMs;
    private final int _configuredNumSnapshots;
    private final long _configuredSnapshotWindowMs;
    private final MetadataClient _metadataClient;
    private final KafkaPartitionMetricSampleAggregator _metricSampleAggregator;
    private final LoadMonitorTaskRunner _loadMonitorTaskRunner;
    private final MetricFetcherManager _metricFetcherManager;
    private final SampleStore _sampleStore;
    private long _bootstrappedRangeStartMs;
    private long _bootstrappedRangeEndMs;

    BootstrapTask(boolean clearMetrics, MetadataClient metadataClient, KafkaPartitionMetricSampleAggregator metricSampleAggregator, LoadMonitorTaskRunner loadMonitorTaskRunner, MetricFetcherManager metricFetcherManager, SampleStore sampleStore, int configuredNumSnapshots, long configuredSnapshotWindowMs, long samplingIntervalMs, Time time) {
        long now;
        this._mode = BootstrapMode.RECENT;
        this._startMs = -1L;
        this._endMs = -1L;
        this._clearMetrics = clearMetrics;
        this._metadataClient = metadataClient;
        this._metricSampleAggregator = metricSampleAggregator;
        this._loadMonitorTaskRunner = loadMonitorTaskRunner;
        this._metricFetcherManager = metricFetcherManager;
        this._sampleStore = sampleStore;
        this._configuredNumSnapshots = configuredNumSnapshots;
        this._configuredSnapshotWindowMs = configuredSnapshotWindowMs;
        this._samplingIntervalMs = samplingIntervalMs;
        this._time = time;
        this._bootstrappedRangeStartMs = now = this._time.milliseconds();
        this._bootstrappedRangeEndMs = now;
    }

    BootstrapTask(long startMs, boolean clearMetrics, MetadataClient metadataClient, KafkaPartitionMetricSampleAggregator metricSampleAggregator, LoadMonitorTaskRunner loadMonitorTaskRunner, MetricFetcherManager metricFetcherManager, SampleStore sampleStore, int configuredNumSnapshots, long configuredSnapshotWindowMs, long samplingIntervalMs, Time time) {
        if (startMs < 0L) {
            throw new IllegalArgumentException(String.format("Invalid bootstrap start time %d. The bootstrap since time cannot be negative.", startMs));
        }
        this._mode = BootstrapMode.SINCE;
        this._startMs = startMs;
        this._clearMetrics = clearMetrics;
        this._endMs = -1L;
        this._metadataClient = metadataClient;
        this._metricSampleAggregator = metricSampleAggregator;
        this._loadMonitorTaskRunner = loadMonitorTaskRunner;
        this._metricFetcherManager = metricFetcherManager;
        this._sampleStore = sampleStore;
        this._configuredNumSnapshots = configuredNumSnapshots;
        this._configuredSnapshotWindowMs = configuredSnapshotWindowMs;
        this._samplingIntervalMs = samplingIntervalMs;
        this._time = time;
        this._bootstrappedRangeStartMs = startMs;
        this._bootstrappedRangeEndMs = startMs;
    }

    BootstrapTask(long startMs, long endMs, boolean clearMetrics, MetadataClient metadataClient, KafkaPartitionMetricSampleAggregator metricSampleAggregator, LoadMonitorTaskRunner loadMonitorTaskRunner, MetricFetcherManager metricFetcherManager, SampleStore sampleStore, int configuredNumSnapshots, long configuredSnapshotWindowMs, long samplingIntervalMs, Time time) {
        if (startMs < 0L || endMs < 0L || endMs <= startMs) {
            throw new IllegalArgumentException(String.format("Invalid bootstrap time range [%d, %d]. The bootstrap end time must be non negative and the end time must be greater than start time.", startMs, endMs));
        }
        this._mode = BootstrapMode.RANGE;
        this._startMs = startMs;
        this._endMs = endMs;
        this._clearMetrics = clearMetrics;
        this._metadataClient = metadataClient;
        this._metricSampleAggregator = metricSampleAggregator;
        this._loadMonitorTaskRunner = loadMonitorTaskRunner;
        this._metricFetcherManager = metricFetcherManager;
        this._sampleStore = sampleStore;
        this._configuredNumSnapshots = configuredNumSnapshots;
        this._configuredSnapshotWindowMs = configuredSnapshotWindowMs;
        this._samplingIntervalMs = samplingIntervalMs;
        this._time = time;
        this._bootstrappedRangeStartMs = startMs;
        this._bootstrappedRangeEndMs = startMs;
    }

    private long nextSamplingPeriodStartMs(long now) {
        switch (this._mode) {
            case RANGE: 
            case SINCE: {
                return this._bootstrappedRangeEndMs;
            }
            case RECENT: {
                if (this._bootstrappedRangeEndMs < now - this._samplingIntervalMs) {
                    return this._bootstrappedRangeEndMs;
                }
                return this._bootstrappedRangeStartMs - this._samplingIntervalMs;
            }
        }
        throw new IllegalStateException("Should never be here");
    }

    private long nextSamplingPeriodEndMs(long now) {
        switch (this._mode) {
            case RANGE: {
                return Math.min(this._endMs, this._bootstrappedRangeEndMs + this._samplingIntervalMs);
            }
            case SINCE: {
                return Math.min(now, this._bootstrappedRangeEndMs + this._samplingIntervalMs);
            }
            case RECENT: {
                if (this._bootstrappedRangeEndMs < now - this._samplingIntervalMs) {
                    return this._bootstrappedRangeEndMs + this._samplingIntervalMs;
                }
                return this._bootstrappedRangeStartMs;
            }
        }
        throw new IllegalStateException("Should never be here");
    }

    private boolean isDone(long now) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Mode: {}, Sampled range [{}, {}], now = {}, MetricSamplerAggregator snapshot windows: {}, sampling interval: {}", new Object[]{this._mode, this._bootstrappedRangeStartMs, this._bootstrappedRangeEndMs, now, this._metricSampleAggregator.allWindows(), this._samplingIntervalMs});
        }
        switch (this._mode) {
            case RANGE: {
                return this._bootstrappedRangeStartMs == this._startMs && this._bootstrappedRangeEndMs == this._endMs;
            }
            case SINCE: {
                return this._bootstrappedRangeStartMs == this._startMs && this._bootstrappedRangeEndMs > now - this._samplingIntervalMs;
            }
            case RECENT: {
                List snapshotWindows = this._metricSampleAggregator.allWindows();
                return snapshotWindows.size() >= this._configuredNumSnapshots + 1 && (Long)snapshotWindows.get(0) - this._configuredSnapshotWindowMs >= this._bootstrappedRangeStartMs && this._bootstrappedRangeEndMs > now - this._samplingIntervalMs;
            }
        }
        throw new IllegalStateException("Should never be here");
    }

    private double progress() {
        long sampledRange = this._bootstrappedRangeEndMs - this._bootstrappedRangeStartMs;
        double progress = this._mode == BootstrapMode.RANGE ? (double)sampledRange / (double)(this._endMs - this._startMs) : (this._mode == BootstrapMode.SINCE ? (double)sampledRange / (double)(this._time.milliseconds() - this._startMs) : (double)sampledRange / (double)((long)(this._configuredNumSnapshots + 1) * this._configuredSnapshotWindowMs));
        return progress;
    }

    @Override
    public void run() {
        long bootstrapStartingMs = this._time.milliseconds();
        if (this._clearMetrics) {
            this._metricSampleAggregator.clear();
        }
        if (this._mode == BootstrapMode.RANGE) {
            LOG.info("Load monitor is bootstrapping for time range [{}, {}]", (Object)this._startMs, (Object)this._endMs);
        } else if (this._mode == BootstrapMode.SINCE) {
            LOG.info("Load monitor is bootstrapping since {}", (Object)this._startMs);
        } else {
            LOG.info("Load monitor is bootstrapping for most recent metric samples.");
        }
        try {
            this._loadMonitorTaskRunner.setBootstrapProgress(0.0);
            this._metadataClient.refreshMetadata();
            long now = this._time.milliseconds();
            do {
                long samplingPeriodEndMs;
                long samplingPeriodStartMs;
                boolean hasSamplingError;
                if (hasSamplingError = this._metricFetcherManager.fetchMetricSamples(samplingPeriodStartMs = this.nextSamplingPeriodStartMs(now), samplingPeriodEndMs = this.nextSamplingPeriodEndMs(now), this._samplingIntervalMs, this._sampleStore, DEFAULT_SAMPLING_MODE)) {
                    LOG.warn("Bootstrap encountered error when sampling from {} to {}, skipping...", (Object)samplingPeriodStartMs, (Object)samplingPeriodEndMs);
                }
                this._loadMonitorTaskRunner.setBootstrapProgress(this.progress());
                this._bootstrappedRangeStartMs = Math.min(this._bootstrappedRangeStartMs, samplingPeriodStartMs);
                this._bootstrappedRangeEndMs = Math.max(this._bootstrappedRangeEndMs, samplingPeriodEndMs);
            } while (!this.isDone(now = this._time.milliseconds()));
        }
        catch (Throwable t) {
            try {
                LOG.error("Received uncaught exception in bootstrap", t);
                throw t;
            }
            catch (Throwable throwable) {
                LOG.info("Load monitor finished bootstrapping {} metric samples in {} snapshot windows for time range [{}, {}] in {} seconds.", new Object[]{this._metricSampleAggregator.numSamples(), this._metricSampleAggregator.allWindows().size(), this._bootstrappedRangeStartMs, this._bootstrappedRangeEndMs, (this._time.milliseconds() - bootstrapStartingMs) / 1000L});
                this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.BOOTSTRAPPING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
                this._loadMonitorTaskRunner.setBootstrapProgress(-1.0);
                throw throwable;
            }
        }
        LOG.info("Load monitor finished bootstrapping {} metric samples in {} snapshot windows for time range [{}, {}] in {} seconds.", new Object[]{this._metricSampleAggregator.numSamples(), this._metricSampleAggregator.allWindows().size(), this._bootstrappedRangeStartMs, this._bootstrappedRangeEndMs, (this._time.milliseconds() - bootstrapStartingMs) / 1000L});
        this._loadMonitorTaskRunner.compareAndSetState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.BOOTSTRAPPING, LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING);
        this._loadMonitorTaskRunner.setBootstrapProgress(-1.0);
    }

    private static enum BootstrapMode {
        RANGE,
        SINCE,
        RECENT;

    }
}

