/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.prometheus.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.prometheus.model.PrometheusValue;
import java.lang.reflect.Type;

class PrometheusValueDeserializer
implements JsonDeserializer<PrometheusValue> {
    PrometheusValueDeserializer() {
    }

    public PrometheusValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray valueArray = json.getAsJsonArray();
        if (valueArray.size() != 2) {
            throw new JsonParseException("Every value array should have exactly two elements");
        }
        long timestamp = valueArray.get(0).getAsLong();
        String valueString = valueArray.get(1).getAsString();
        double numericValue = Double.parseDouble(valueString);
        return new PrometheusValue(timestamp, numericValue);
    }
}

