/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.prometheus;

import com.google.gson.Gson;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.prometheus.model.PrometheusQueryResult;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.prometheus.model.PrometheusResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

class PrometheusAdapter {
    private static final Gson GSON = new Gson();
    static final String QUERY_RANGE_API_PATH = "/api/v1/query_range";
    static final String SUCCESS = "success";
    private static final String QUERY = "query";
    private static final String START = "start";
    private static final String END = "end";
    private static final String STEP = "step";
    private final CloseableHttpClient _httpClient;
    final HttpHost _prometheusEndpoint;
    final int _samplingIntervalMs;

    PrometheusAdapter(CloseableHttpClient httpClient, HttpHost prometheusEndpoint, int samplingIntervalMs) {
        if (httpClient == null || prometheusEndpoint == null) {
            throw new IllegalArgumentException("httpClient or prometheusEndpoint cannot be null.");
        }
        this._httpClient = httpClient;
        this._prometheusEndpoint = prometheusEndpoint;
        this._samplingIntervalMs = samplingIntervalMs;
    }

    public List<PrometheusQueryResult> queryMetric(String queryString, long startTimeMs, long endTimeMs) throws IOException {
        URI queryUri = URI.create(this._prometheusEndpoint.toURI() + QUERY_RANGE_API_PATH);
        HttpPost httpPost = new HttpPost(queryUri);
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair(QUERY, queryString));
        data.add(new BasicNameValuePair(START, String.valueOf((double)startTimeMs / 1000.0)));
        data.add(new BasicNameValuePair(END, String.valueOf((double)endTimeMs / 1000.0)));
        data.add(new BasicNameValuePair(STEP, String.valueOf((double)this._samplingIntervalMs / 1000.0)));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(data));
        try (CloseableHttpResponse response = this._httpClient.execute((HttpUriRequest)httpPost);){
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            InputStream content = entity.getContent();
            String responseString = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            if (responseCode != 200) {
                throw new IOException(String.format("Received non-success response code on Prometheus API HTTP call, response code = %s, response body = %s", responseCode, responseString));
            }
            PrometheusResponse prometheusResponse = (PrometheusResponse)GSON.fromJson(responseString, PrometheusResponse.class);
            if (prometheusResponse == null) {
                throw new IOException(String.format("No response received from Prometheus API query, response body = %s", responseString));
            }
            if (!SUCCESS.equals(prometheusResponse.status())) {
                throw new IOException(String.format("Prometheus API query was not successful, response body = %s", responseString));
            }
            if (prometheusResponse.data() == null || prometheusResponse.data().result() == null) {
                throw new IOException(String.format("Response from Prometheus HTTP API is malformed, response body = %s", responseString));
            }
            EntityUtils.consume((HttpEntity)entity);
            List<PrometheusQueryResult> list = prometheusResponse.data().result();
            return list;
        }
    }
}

