/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;

class ValueAndCount
implements ValueHolder {
    static double NO_RECORD_EXISTS = -1.0;
    private double _value = 0.0;
    private int _count = 0;

    ValueAndCount() {
    }

    @Override
    public void recordValue(double value, long time) {
        this._value += value;
        ++this._count;
    }

    @Override
    public void reset() {
        this._value = 0.0;
        this._count = 0;
    }

    @Override
    public double value() {
        return this._count == 0 ? 0.0 : this._value / (double)this._count;
    }

    @Override
    public double value(boolean assertNonZeroCount) {
        return this._count == 0 ? (assertNonZeroCount ? NO_RECORD_EXISTS : 0.0) : this._value / (double)this._count;
    }
}

