/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueAndCount;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueAndTime;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueMax;
import java.util.HashMap;
import java.util.Map;

class RawMetricsHolder {
    private final Map<RawMetricType, ValueHolder> _rawMetricsByType = new HashMap<RawMetricType, ValueHolder>();

    RawMetricsHolder() {
    }

    void recordCruiseControlMetric(CruiseControlMetric ccm) {
        RawMetricType rawMetricType = ccm.rawMetricType();
        ValueHolder valueHolder = this._rawMetricsByType.computeIfAbsent(rawMetricType, mt -> RawMetricsHolder.getValueHolderFor(rawMetricType));
        valueHolder.recordValue(ccm.value(), ccm.time());
    }

    void setRawMetricValue(RawMetricType rawMetricType, double value, long time) {
        this._rawMetricsByType.compute(rawMetricType, (type, vh) -> {
            ValueHolder valueHolder = vh == null ? RawMetricsHolder.getValueHolderFor(rawMetricType) : vh;
            valueHolder.reset();
            valueHolder.recordValue(value, time);
            return valueHolder;
        });
    }

    ValueHolder metricValue(RawMetricType rawMetricType) {
        return this._rawMetricsByType.get(rawMetricType);
    }

    private static ValueHolder getValueHolderFor(RawMetricType rawMetricType) {
        KafkaMetricDef kafkaMetricDef = KafkaMetricDef.forRawMetricType(rawMetricType);
        switch (kafkaMetricDef.valueComputingStrategy()) {
            case AVG: {
                return new ValueAndCount();
            }
            case MAX: {
                return new ValueMax();
            }
            case LATEST: {
                return new ValueAndTime();
            }
        }
        throw new IllegalStateException("Should never be here");
    }
}

