/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;

public class PartitionMetricSample
extends MetricSample<String, PartitionEntity> {
    static final byte MIN_SUPPORTED_VERSION = 0;
    static final byte LATEST_SUPPORTED_VERSION = 1;
    private final int _brokerId;

    public PartitionMetricSample(int brokerId, TopicPartition tp) {
        super((Entity)new PartitionEntity(tp));
        this._brokerId = brokerId;
    }

    public int brokerId() {
        return this._brokerId;
    }

    public byte[] toBytes() {
        MetricDef metricDef = KafkaMetricDef.commonMetricDef();
        byte[] topicStringBytes = ((PartitionEntity)this.entity()).group().getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(89 + topicStringBytes.length);
        buffer.put((byte)1);
        buffer.putInt(this._brokerId);
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.CPU_USAGE.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.DISK_USAGE.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_IN.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_OUT.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.PRODUCE_RATE.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.FETCH_RATE.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.MESSAGE_IN_RATE.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_IN_RATE.name()).id()));
        buffer.putDouble((Double)this._valuesByMetricId.get(metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE.name()).id()));
        buffer.putLong(this._sampleTime);
        buffer.putInt(((PartitionEntity)this.entity()).tp().partition());
        buffer.put(topicStringBytes);
        return buffer.array();
    }

    public static PartitionMetricSample fromBytes(byte[] bytes) throws UnknownVersionException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte version = buffer.get();
        switch (version) {
            case 0: {
                return PartitionMetricSample.readV0(buffer);
            }
            case 1: {
                return PartitionMetricSample.readV1(buffer);
            }
        }
        throw new UnknownVersionException("Unsupported deserialization version: " + version + " (Latest: 1, Minimum: 0)");
    }

    public String toString() {
        MetricDef metricDef = KafkaMetricDef.commonMetricDef();
        StringBuilder builder = new StringBuilder().append("{");
        for (Map.Entry entry : this._valuesByMetricId.entrySet()) {
            builder.append(metricDef.metricInfo(((Short)entry.getKey()).shortValue()).name()).append("=").append(((Double)entry.getValue()).toString()).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length()).append("}");
        return String.format("[brokerId: %d, Partition: %s, time: %s, metrics: %s]", this._brokerId, ((PartitionEntity)this.entity()).tp(), new Date(this._sampleTime), builder.toString());
    }

    private static PartitionMetricSample readV0(ByteBuffer buffer) {
        MetricDef metricDef = KafkaMetricDef.commonMetricDef();
        int brokerId = buffer.getInt();
        int partition = buffer.getInt(45);
        String topic = new String(buffer.array(), 49, buffer.array().length - 49, StandardCharsets.UTF_8);
        PartitionMetricSample sample = new PartitionMetricSample(brokerId, new TopicPartition(topic, partition));
        sample.record(metricDef.metricInfo(KafkaMetricDef.CPU_USAGE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.DISK_USAGE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_IN.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_OUT.name()), buffer.getDouble());
        sample.close(buffer.getLong());
        return sample;
    }

    private static PartitionMetricSample readV1(ByteBuffer buffer) {
        MetricDef metricDef = KafkaMetricDef.commonMetricDef();
        int brokerId = buffer.getInt();
        int partition = buffer.getInt(85);
        String topic = new String(buffer.array(), 89, buffer.array().length - 89, StandardCharsets.UTF_8);
        PartitionMetricSample sample = new PartitionMetricSample(brokerId, new TopicPartition(topic, partition));
        sample.record(metricDef.metricInfo(KafkaMetricDef.CPU_USAGE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.DISK_USAGE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_IN.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_OUT.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.PRODUCE_RATE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.FETCH_RATE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.MESSAGE_IN_RATE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_IN_RATE.name()), buffer.getDouble());
        sample.record(metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE.name()), buffer.getDouble());
        sample.close(buffer.getLong());
        return sample;
    }
}

