/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerEntity;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class BrokerMetricSample
extends MetricSample<String, BrokerEntity> {
    public static final byte MIN_SUPPORTED_VERSION = 4;
    public static final byte LATEST_SUPPORTED_VERSION = 5;
    private final byte _deserializationVersion;

    public BrokerMetricSample(String host, Integer brokerId, byte deserializationVersion) throws UnknownVersionException {
        super((Entity)new BrokerEntity(host, brokerId));
        if (host != null && host.length() >= Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The length of host name %s is %d, which is longer than the max allowed length of %d", host, host.length(), (short)Short.MAX_VALUE));
        }
        if (deserializationVersion < 4 || deserializationVersion > 5) {
            throw new UnknownVersionException("Unsupported serialization version: " + deserializationVersion + " (Latest: 5, Minimum: 4)");
        }
        this._deserializationVersion = deserializationVersion;
    }

    public byte deserializationVersion() {
        return this._deserializationVersion;
    }

    public int brokerId() {
        return ((BrokerEntity)this.entity()).brokerId();
    }

    public byte[] toBytes() {
        byte[] hostBytes = (((BrokerEntity)this.entity()).group() != null ? ((BrokerEntity)this.entity()).group() : "UNKNOWN").getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(457 + hostBytes.length);
        buffer.put(this._deserializationVersion);
        buffer.putInt(((BrokerEntity)this.entity()).brokerId());
        buffer.putShort((short)hostBytes.length);
        buffer.put(hostBytes);
        buffer.putDouble(this.metricValue(KafkaMetricDef.CPU_USAGE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.LEADER_BYTES_IN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.LEADER_BYTES_OUT));
        buffer.putDouble(this.metricValue(KafkaMetricDef.REPLICATION_BYTES_IN_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.MESSAGE_IN_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_REQUEST_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_REQUEST_HANDLER_POOL_IDLE_PERCENT));
        buffer.putDouble(this.metricValue(KafkaMetricDef.DISK_USAGE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.PRODUCE_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.FETCH_RATE));
        buffer.putLong(this._sampleTime);
        buffer.putInt(this.metricValue(KafkaMetricDef.BROKER_REQUEST_QUEUE_SIZE).intValue());
        buffer.putInt(this.metricValue(KafkaMetricDef.BROKER_RESPONSE_QUEUE_SIZE).intValue());
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_LOG_FLUSH_RATE));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_MAX));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_MEAN));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_50TH));
        buffer.putDouble(this.metricValue(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_999TH));
        return buffer.array();
    }

    public static BrokerMetricSample fromBytes(byte[] bytes) throws UnknownVersionException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte version = buffer.get();
        switch (version) {
            case 4: {
                return BrokerMetricSample.readV4(buffer);
            }
            case 5: {
                return BrokerMetricSample.readV5(buffer);
            }
        }
        throw new UnknownVersionException("Unsupported deserialization version: " + version + " (Latest: 5, Minimum: 4)");
    }

    protected MetricDef metricDefForToString() {
        return KafkaMetricDef.brokerMetricDef();
    }

    public Double metricFor(Resource resource) {
        switch (resource) {
            case CPU: {
                return this.metricValue(KafkaMetricDef.CPU_USAGE);
            }
            case DISK: {
                return this.metricValue(KafkaMetricDef.DISK_USAGE);
            }
            case NW_IN: {
                return this.metricValue(KafkaMetricDef.LEADER_BYTES_IN) + this.metricValue(KafkaMetricDef.REPLICATION_BYTES_IN_RATE);
            }
            case NW_OUT: {
                return this.metricValue(KafkaMetricDef.LEADER_BYTES_OUT) + this.metricValue(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE);
            }
        }
        throw new IllegalStateException("Should never happen");
    }

    public Double metricValue(KafkaMetricDef kafkaMetricDef) {
        return (Double)this._valuesByMetricId.get(KafkaMetricDef.brokerMetricDef().metricInfo(kafkaMetricDef.name()).id());
    }

    private static long populateV4BrokerMetricSample(ByteBuffer buffer, BrokerMetricSample brokerMetricSample) {
        MetricDef metricDef = KafkaMetricDef.brokerMetricDef();
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.CPU_USAGE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_IN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.LEADER_BYTES_OUT.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_IN_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.MESSAGE_IN_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_REQUEST_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_REQUEST_HANDLER_POOL_IDLE_PERCENT.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.DISK_USAGE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.PRODUCE_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.FETCH_RATE.name()), buffer.getDouble());
        long sampleTime = buffer.getLong();
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_REQUEST_QUEUE_SIZE.name()), buffer.getInt());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_RESPONSE_QUEUE_SIZE.name()), buffer.getInt());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MEAN.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_LOG_FLUSH_RATE.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_MAX.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_MEAN.name()), buffer.getDouble());
        return sampleTime;
    }

    private static BrokerMetricSample readV4(ByteBuffer buffer) throws UnknownVersionException {
        int brokerId = buffer.getInt();
        short hostLength = buffer.getShort();
        byte[] hostBytes = new byte[hostLength];
        buffer.get(hostBytes);
        String host = new String(hostBytes, StandardCharsets.UTF_8);
        BrokerMetricSample brokerMetricSample = new BrokerMetricSample(host, brokerId, 4);
        long sampleTime = BrokerMetricSample.populateV4BrokerMetricSample(buffer, brokerMetricSample);
        if (sampleTime >= 0L) {
            brokerMetricSample.close(sampleTime);
        }
        return brokerMetricSample;
    }

    private static long populateV5BrokerMetricSample(ByteBuffer buffer, BrokerMetricSample brokerMetricSample) {
        MetricDef metricDef = KafkaMetricDef.brokerMetricDef();
        long sampleTime = BrokerMetricSample.populateV4BrokerMetricSample(buffer, brokerMetricSample);
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_TOTAL_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_PRODUCE_LOCAL_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_50TH.name()), buffer.getDouble());
        brokerMetricSample.record(metricDef.metricInfo(KafkaMetricDef.BROKER_LOG_FLUSH_TIME_MS_999TH.name()), buffer.getDouble());
        return sampleTime;
    }

    private static BrokerMetricSample readV5(ByteBuffer buffer) throws UnknownVersionException {
        int brokerId = buffer.getInt();
        short hostLength = buffer.getShort();
        byte[] hostBytes = new byte[hostLength];
        buffer.get(hostBytes);
        String host = new String(hostBytes, StandardCharsets.UTF_8);
        BrokerMetricSample brokerMetricSample = new BrokerMetricSample(host, brokerId, 5);
        long sampleTime = BrokerMetricSample.populateV5BrokerMetricSample(buffer, brokerMetricSample);
        if (sampleTime >= 0L) {
            brokerMetricSample.close(sampleTime);
        }
        return brokerMetricSample;
    }
}

