/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.PartitionMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.TopicMetric;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.HolderUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.RawMetricsHolder;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerLoad {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerLoad.class);
    private static final double MAX_ALLOWED_MISSING_PARTITION_METRIC_PERCENT = 0.01;
    private static final double MAX_ALLOWED_MISSING_TOPIC_METRIC_PERCENT = 0.01;
    private final RawMetricsHolder _brokerMetrics;
    private final Map<String, RawMetricsHolder> _dotHandledTopicMetrics;
    private final Map<TopicPartition, RawMetricsHolder> _dotHandledPartitionMetrics;
    private final Set<String> _dotHandledTopicsWithPartitionSizeReported = new HashSet<String>();
    private final Set<RawMetricType> _missingBrokerMetricsInMinSupportedVersion = new HashSet<RawMetricType>();
    private boolean _minRequiredBrokerMetricsAvailable = false;
    private byte _brokerSampleDeserializationVersion = (byte)-1;

    public BrokerLoad() {
        this._brokerMetrics = new RawMetricsHolder();
        this._dotHandledTopicMetrics = new HashMap<String, RawMetricsHolder>();
        this._dotHandledPartitionMetrics = new HashMap<TopicPartition, RawMetricsHolder>();
    }

    public void recordMetric(CruiseControlMetric ccm) {
        RawMetricType rawMetricType = ccm.rawMetricType();
        switch (rawMetricType.metricScope()) {
            case BROKER: {
                this._brokerMetrics.recordCruiseControlMetric(ccm);
                break;
            }
            case TOPIC: {
                TopicMetric tm = (TopicMetric)ccm;
                this._dotHandledTopicMetrics.computeIfAbsent(tm.topic(), t -> new RawMetricsHolder()).recordCruiseControlMetric(ccm);
                break;
            }
            case PARTITION: {
                PartitionMetric pm = (PartitionMetric)ccm;
                this._dotHandledPartitionMetrics.computeIfAbsent(new TopicPartition(pm.topic(), pm.partition()), tp -> new RawMetricsHolder()).recordCruiseControlMetric(ccm);
                this._dotHandledTopicsWithPartitionSizeReported.add(pm.topic());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Should never be here. Unrecognized metric scope %s", rawMetricType.metricScope()));
            }
        }
    }

    public boolean allDotHandledTopicMetricsAvailable(String dotHandledTopic) {
        return this._dotHandledTopicsWithPartitionSizeReported.contains(dotHandledTopic);
    }

    public boolean minRequiredBrokerMetricsAvailable() {
        return this._minRequiredBrokerMetricsAvailable;
    }

    public boolean brokerMetricAvailable(RawMetricType rawMetricType) {
        return this._brokerMetrics.metricValue(rawMetricType) != null;
    }

    public boolean partitionMetricAvailable(TopicPartition tpWithDotHandled, RawMetricType rawMetricType) {
        RawMetricsHolder rawMetricsHolder = this._dotHandledPartitionMetrics.get(tpWithDotHandled);
        return rawMetricsHolder != null && rawMetricsHolder.metricValue(rawMetricType) != null;
    }

    public Set<RawMetricType> missingBrokerMetricsInMinSupportedVersion() {
        return this._missingBrokerMetricsInMinSupportedVersion;
    }

    public double brokerMetric(RawMetricType rawMetricType) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.BROKER);
        ValueHolder valueHolder = this._brokerMetrics.metricValue(rawMetricType);
        if (valueHolder == null) {
            throw new IllegalArgumentException(String.format("Broker metric %s does not exist.", rawMetricType));
        }
        return HolderUtils.convertUnit(valueHolder.value(), rawMetricType);
    }

    public double topicMetrics(String dotHandledTopic, RawMetricType rawMetricType) {
        return this.topicMetrics(dotHandledTopic, rawMetricType, true);
    }

    private double topicMetrics(String dotHandledTopic, RawMetricType rawMetricType, boolean convertUnit) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.TOPIC);
        if (!this.allDotHandledTopicMetricsAvailable(dotHandledTopic)) {
            throw new IllegalArgumentException(String.format("Topic metric %s does not exist for dot handled topic name %s.", rawMetricType, dotHandledTopic));
        }
        RawMetricsHolder rawMetricsHolder = this._dotHandledTopicMetrics.get(dotHandledTopic);
        if (rawMetricsHolder == null || rawMetricsHolder.metricValue(rawMetricType) == null) {
            return 0.0;
        }
        double rawMetricValue = rawMetricsHolder.metricValue(rawMetricType).value();
        return convertUnit ? HolderUtils.convertUnit(rawMetricValue, rawMetricType) : rawMetricValue;
    }

    public Double partitionMetric(String dotHandledTopic, int partition, RawMetricType rawMetricType) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.PARTITION);
        RawMetricsHolder metricsHolder = this._dotHandledPartitionMetrics.get(new TopicPartition(dotHandledTopic, partition));
        if (metricsHolder == null || metricsHolder.metricValue(rawMetricType) == null) {
            LOG.error("Partition metric {} does not exist for dot handled topic {} and partition {}.", new Object[]{rawMetricType, dotHandledTopic, partition});
            return null;
        }
        return HolderUtils.convertUnit(metricsHolder.metricValue(rawMetricType).value(), rawMetricType);
    }

    public void prepareBrokerMetrics(Cluster cluster, int brokerId, long time) {
        boolean enoughTopicPartitionMetrics = this.enoughTopicPartitionMetrics(cluster, brokerId);
        if (enoughTopicPartitionMetrics) {
            HashMap sumOfTopicMetrics = new HashMap();
            for (String string : this._dotHandledTopicsWithPartitionSizeReported) {
                HolderUtils.METRIC_TYPES_TO_SUM.keySet().forEach(type -> {
                    double value = this.topicMetrics(dotHandledTopic, (RawMetricType)type, false);
                    sumOfTopicMetrics.compute(type, (t, v) -> (v == null ? 0.0 : v) + value);
                });
            }
            for (Map.Entry entry : sumOfTopicMetrics.entrySet()) {
                RawMetricType rawTopicMetricType = (RawMetricType)entry.getKey();
                double value = (Double)entry.getValue();
                this._brokerMetrics.setRawMetricValue(HolderUtils.METRIC_TYPES_TO_SUM.get(rawTopicMetricType), value, time);
            }
        }
        this.maybeSetBrokerRawMetrics(cluster, brokerId, time);
        this._minRequiredBrokerMetricsAvailable = enoughTopicPartitionMetrics && this._missingBrokerMetricsInMinSupportedVersion.isEmpty();
    }

    private void maybeSetBrokerRawMetrics(Cluster cluster, int brokerId, long time) {
        for (byte v = 4; v <= 5; v = (byte)(v + 1)) {
            HashSet<RawMetricType> missingBrokerMetrics = new HashSet<RawMetricType>();
            for (RawMetricType rawBrokerMetricType : RawMetricType.brokerMetricTypesDiffForVersion((byte)v)) {
                if (this._brokerMetrics.metricValue(rawBrokerMetricType) != null) continue;
                if (HolderUtils.allowMissingBrokerMetric(cluster, brokerId, rawBrokerMetricType)) {
                    this._brokerMetrics.setRawMetricValue(rawBrokerMetricType, 0.0, time);
                    continue;
                }
                missingBrokerMetrics.add(rawBrokerMetricType);
            }
            if (!missingBrokerMetrics.isEmpty()) {
                if (this._brokerSampleDeserializationVersion != -1) break;
                this._missingBrokerMetricsInMinSupportedVersion.addAll(missingBrokerMetrics);
                break;
            }
            this._brokerSampleDeserializationVersion = v;
        }
        this.setNullableBrokerMetrics();
    }

    public byte brokerSampleDeserializationVersion() {
        return this._brokerSampleDeserializationVersion;
    }

    private void setNullableBrokerMetrics() {
        if (this._brokerSampleDeserializationVersion != -1) {
            HashSet nullableBrokerMetrics = new HashSet();
            for (byte v = (byte)(this._brokerSampleDeserializationVersion + 1); v <= 5; v = (byte)(v + 1)) {
                HashSet nullableMetrics = new HashSet(RawMetricType.brokerMetricTypesDiffForVersion((byte)v));
                nullableBrokerMetrics.addAll(nullableMetrics);
            }
            nullableBrokerMetrics.forEach(nullableMetric -> this._brokerMetrics.setRawMetricValue((RawMetricType)nullableMetric, 0.0, 0L));
        }
    }

    private boolean enoughTopicPartitionMetrics(Cluster cluster, int brokerId) {
        boolean result;
        HashSet missingTopics = new HashSet();
        HashSet topicsInBroker = new HashSet();
        AtomicInteger missingPartitions = new AtomicInteger(0);
        List leaderPartitionsInNode = cluster.partitionsForNode(brokerId);
        if (leaderPartitionsInNode.isEmpty()) {
            return true;
        }
        leaderPartitionsInNode.forEach(info -> {
            String topicWithDotHandled = SamplingUtils.replaceDotsWithUnderscores(info.topic());
            topicsInBroker.add(topicWithDotHandled);
            if (!this._dotHandledTopicsWithPartitionSizeReported.contains(topicWithDotHandled)) {
                missingPartitions.incrementAndGet();
                missingTopics.add(topicWithDotHandled);
            }
        });
        boolean bl = result = (double)missingTopics.size() / (double)topicsInBroker.size() <= 0.01 && (double)missingPartitions.get() / (double)cluster.partitionsForNode(brokerId).size() <= 0.01;
        if (!result) {
            LOG.warn("Broker {} is missing {}/{} topics metrics and {}/{} leader partition metrics. Missing leader topics: {}.", new Object[]{brokerId, missingTopics.size(), topicsInBroker.size(), missingPartitions.get(), cluster.partitionsForNode(brokerId).size(), missingTopics});
        }
        return result;
    }

    public double diskUsage() {
        double result = 0.0;
        for (RawMetricsHolder rawMetricsHolder : this._dotHandledPartitionMetrics.values()) {
            result += rawMetricsHolder.metricValue(RawMetricType.PARTITION_SIZE).value();
        }
        return HolderUtils.convertUnit(result, RawMetricType.PARTITION_SIZE);
    }
}

