/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregator;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.async.progress.RetrievingMetrics;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionMetricSampleAggregator
extends MetricSampleAggregator<String, PartitionEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPartitionMetricSampleAggregator.class);
    private final int _maxAllowedExtrapolationsPerPartition;
    private final Metadata _metadata;

    public KafkaPartitionMetricSampleAggregator(KafkaCruiseControlConfig config, Metadata metadata) {
        super(config.getInt("num.partition.metrics.windows").intValue(), config.getLong("partition.metrics.window.ms").longValue(), config.getInt("min.samples.per.partition.metrics.window").byteValue(), config.getInt("partition.metric.sample.aggregator.completeness.cache.size").intValue(), KafkaMetricDef.commonMetricDef());
        this._metadata = metadata;
        this._maxAllowedExtrapolationsPerPartition = config.getInt("max.allowed.extrapolations.per.partition");
        this._sampleType = MetricSampleAggregator.SampleType.PARTITION;
    }

    public boolean addSample(PartitionMetricSample sample) {
        return this.addSample(sample, true);
    }

    public boolean addSample(PartitionMetricSample sample, boolean leaderValidation) {
        return this.isValidSample(sample, leaderValidation) && super.addSample((MetricSample)sample);
    }

    public MetricSampleAggregationResult<String, PartitionEntity> aggregate(Cluster cluster, long now, OperationProgress operationProgress) throws NotEnoughValidWindowsException {
        ModelCompletenessRequirements requirements = new ModelCompletenessRequirements(1, 0.0, false);
        return this.aggregate(cluster, -1L, now, requirements, operationProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSampleAggregationResult<String, PartitionEntity> aggregate(Cluster cluster, long from, long to, ModelCompletenessRequirements requirements, OperationProgress operationProgress) throws NotEnoughValidWindowsException {
        RetrievingMetrics step = new RetrievingMetrics();
        try {
            operationProgress.addStep(step);
            MetricSampleAggregationResult metricSampleAggregationResult = this.aggregate(from, to, this.toAggregationOptions(cluster, requirements));
            return metricSampleAggregationResult;
        }
        finally {
            step.done();
        }
    }

    public MetricSampleCompleteness<String, PartitionEntity> completeness(Cluster cluster, long from, long to, ModelCompletenessRequirements requirements) {
        return this.completeness(from, to, this.toAggregationOptions(cluster, requirements));
    }

    public SortedSet<Long> validWindows(Cluster cluster, double minMonitoredPartitionsPercentage) {
        AggregationOptions options = new AggregationOptions(minMonitoredPartitionsPercentage, 0.0, 1, this._maxAllowedExtrapolationsPerPartition, this.allPartitions(cluster), AggregationOptions.Granularity.ENTITY, true);
        MetricSampleCompleteness completeness = this.completeness(-1L, Long.MAX_VALUE, options);
        return KafkaPartitionMetricSampleAggregator.windowIndicesToWindows(completeness.validWindowIndices(), this._windowMs);
    }

    public double monitoredPercentage(Cluster cluster) {
        AggregationOptions options = new AggregationOptions(0.0, 0.0, 1, this._maxAllowedExtrapolationsPerPartition, this.allPartitions(cluster), AggregationOptions.Granularity.ENTITY, true);
        MetricSampleCompleteness completeness = this.completeness(-1L, Long.MAX_VALUE, options);
        return completeness.validEntityRatio();
    }

    public SortedMap<Long, Float> validPartitionRatioByWindows(Cluster cluster) {
        AggregationOptions options = new AggregationOptions(0.0, 0.0, 1, this._maxAllowedExtrapolationsPerPartition, this.allPartitions(cluster), AggregationOptions.Granularity.ENTITY, true);
        MetricSampleCompleteness completeness = this.completeness(-1L, Long.MAX_VALUE, options);
        return KafkaPartitionMetricSampleAggregator.windowIndicesToWindows(completeness.validEntityRatioWithGroupGranularityByWindowIndex(), this._windowMs);
    }

    private Set<PartitionEntity> allPartitions(Cluster cluster) {
        HashSet<PartitionEntity> allPartitions = new HashSet<PartitionEntity>();
        for (String topic : cluster.topics()) {
            for (PartitionInfo partitionInfo : cluster.partitionsForTopic(topic)) {
                TopicPartition tp = new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
                PartitionEntity partitionEntity = new PartitionEntity(tp);
                allPartitions.add((PartitionEntity)this.identity(partitionEntity));
            }
        }
        return allPartitions;
    }

    private static SortedSet<Long> windowIndicesToWindows(SortedSet<Long> original, long windowMs) {
        TreeSet<Long> result = new TreeSet<Long>(Collections.reverseOrder());
        original.forEach(idx -> result.add(idx * windowMs));
        return result;
    }

    private static <T> SortedMap<Long, T> windowIndicesToWindows(SortedMap<Long, T> original, long windowMs) {
        TreeMap result = new TreeMap(Collections.reverseOrder());
        original.forEach((key, value) -> result.put(key * windowMs, value));
        return result;
    }

    private boolean isValidSample(PartitionMetricSample sample, boolean leaderValidation) {
        boolean completeMetrics;
        boolean validLeader = true;
        if (leaderValidation) {
            Node leader = this._metadata.fetch().leaderFor(((PartitionEntity)sample.entity()).tp());
            boolean bl = validLeader = leader != null && sample.brokerId() == leader.id();
            if (!validLeader) {
                LOG.warn("The metric sample is discarded due to invalid leader. Current leader {}, Sample: {}", (Object)leader, (Object)sample);
            }
        }
        boolean bl = completeMetrics = sample.isValid(this._metricDef) || sample.allMetricValues().size() == this._metricDef.size() - 2 && sample.allMetricValues().containsKey(this._metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_IN_RATE.name()).id()) && sample.allMetricValues().containsKey(this._metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE.name()).id());
        if (!completeMetrics) {
            LOG.warn("The metric sample is discarded due to missing metrics. Sample: {}", (Object)sample);
        }
        return validLeader && completeMetrics;
    }

    private AggregationOptions<String, PartitionEntity> toAggregationOptions(Cluster cluster, ModelCompletenessRequirements requirements) {
        Set<PartitionEntity> allPartitions = this.allPartitions(cluster);
        return new AggregationOptions(requirements.minMonitoredPartitionsPercentage(), 0.0, requirements.minRequiredNumWindows(), this._maxAllowedExtrapolationsPerPartition, allPartitions, AggregationOptions.Granularity.ENTITY, requirements.includeAllTopics());
    }
}

