/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurable;
import com.linkedin.kafka.cruisecontrol.model.ModelParameters;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaBrokerMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerMetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;

public interface SampleStore
extends CruiseControlConfigurable {
    public void storeSamples(MetricSampler.Samples var1);

    public void loadSamples(SampleLoader var1);

    public double sampleLoadingProgress();

    public void evictSamplesBefore(long var1);

    public void close();

    public static class SampleLoader {
        private final KafkaPartitionMetricSampleAggregator _partitionMetricSampleAggregator;
        private final KafkaBrokerMetricSampleAggregator _brokerMetricSampleAggregator;

        public SampleLoader(KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator, KafkaBrokerMetricSampleAggregator brokerMetricSampleAggregator) {
            this._partitionMetricSampleAggregator = partitionMetricSampleAggregator;
            this._brokerMetricSampleAggregator = brokerMetricSampleAggregator;
        }

        public void loadSamples(MetricSampler.Samples samples) {
            for (PartitionMetricSample partitionMetricSample : samples.partitionMetricSamples()) {
                this._partitionMetricSampleAggregator.addSample(partitionMetricSample, false);
            }
            for (BrokerMetricSample brokerMetricSample : samples.brokerMetricSamples()) {
                this._brokerMetricSampleAggregator.addSample(brokerMetricSample);
            }
            ModelParameters.addMetricObservation(samples.brokerMetricSamples());
        }

        public long partitionSampleCount() {
            return this._partitionMetricSampleAggregator.numSamples();
        }

        public long brokerSampleCount() {
            return this._brokerMetricSampleAggregator.numSamples();
        }

        public long partitionMonitoringPeriodMs() {
            return this._partitionMetricSampleAggregator.monitoringPeriodMs();
        }

        public long brokerMonitoringPeriodMs() {
            return this._brokerMetricSampleAggregator.monitoringPeriodMs();
        }
    }
}

