/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.KafkaSampleStore;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;

public class ReadOnlyKafkaSampleStore
extends KafkaSampleStore {
    @Override
    public void configure(Map<String, ?> config) {
        this._partitionMetricSampleStoreTopic = KafkaCruiseControlUtils.getRequiredConfig(config, "partition.metric.sample.store.topic");
        this._brokerMetricSampleStoreTopic = KafkaCruiseControlUtils.getRequiredConfig(config, "broker.metric.sample.store.topic");
        String sampleStoreTopicReplicationFactorString = (String)config.get("sample.store.topic.replication.factor");
        this._sampleStoreTopicReplicationFactor = sampleStoreTopicReplicationFactorString == null || sampleStoreTopicReplicationFactorString.isEmpty() ? null : Short.valueOf(Short.parseShort(sampleStoreTopicReplicationFactorString));
        String numProcessingThreadsString = (String)config.get("num.sample.loading.threads");
        int numProcessingThreads = numProcessingThreadsString == null || numProcessingThreadsString.isEmpty() ? 8 : Integer.parseInt(numProcessingThreadsString);
        this._metricProcessorExecutor = Executors.newFixedThreadPool(numProcessingThreads);
        this._consumers = new ArrayList(numProcessingThreads);
        for (int i = 0; i < numProcessingThreads; ++i) {
            this._consumers.add(SamplingUtils.createSampleStoreConsumer(config, "KafkaCruiseControlSampleStore"));
        }
        this._loadingProgress = -1.0;
    }

    @Override
    public void close() {
    }

    @Override
    public void storeSamples(MetricSampler.Samples samples) {
    }

    @Override
    public void evictSamplesBefore(long timestamp) {
    }
}

