/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.kafka.cruisecontrol.exception.SamplingException;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSamplerOptions;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SampleStore;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerMetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MetricFetcher
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(MetricFetcher.class);
    protected final MetricSampler _metricSampler;
    protected final Cluster _cluster;
    protected final SampleStore _sampleStore;
    protected final Set<TopicPartition> _assignedPartitions;
    protected final long _startTimeMs;
    protected final long _endTimeMs;
    protected final MetricDef _metricDef;
    protected final Timer _fetchTimer;
    protected final Meter _fetchFailureRate;
    protected final long _timeout;
    protected final MetricSampler.SamplingMode _samplingMode;

    MetricFetcher(MetricSampler metricSampler, Cluster cluster, SampleStore sampleStore, Set<TopicPartition> assignedPartitions, long startTimeMs, long endTimeMs, MetricDef metricDef, Timer fetchTimer, Meter fetchFailureRate, MetricSampler.SamplingMode samplingMode) {
        this._metricSampler = metricSampler;
        this._cluster = cluster;
        this._sampleStore = sampleStore;
        this._assignedPartitions = assignedPartitions;
        this._startTimeMs = startTimeMs;
        this._endTimeMs = endTimeMs;
        this._metricDef = metricDef;
        this._fetchTimer = fetchTimer;
        this._fetchFailureRate = fetchFailureRate;
        this._samplingMode = samplingMode;
        this._timeout = System.currentTimeMillis() + (endTimeMs - startTimeMs) / 2L;
    }

    @Override
    public Boolean call() {
        boolean hasSamplingError = false;
        try {
            this.fetchMetricsForAssignedPartitions();
        }
        catch (SamplingException mse) {
            LOG.warn("Received sampling error.", (Throwable)mse);
            hasSamplingError = true;
        }
        catch (Throwable t) {
            LOG.error("Received exception.", t);
            hasSamplingError = true;
        }
        return hasSamplingError;
    }

    protected void fetchMetricsForAssignedPartitions() throws SamplingException {
        Timer.Context ctx = this._fetchTimer.time();
        try {
            MetricSampler.Samples samples = this.fetchSamples();
            if (this._sampleStore != null) {
                this._sampleStore.storeSamples(samples);
            }
        }
        catch (Exception e) {
            this._fetchFailureRate.mark();
            throw e;
        }
        finally {
            ctx.stop();
        }
    }

    protected MetricSampler.Samples fetchSamples() throws SamplingException {
        MetricSamplerOptions metricSamplerOptions = new MetricSamplerOptions(this._cluster, this._assignedPartitions, this._startTimeMs, this._endTimeMs, this._samplingMode, this._metricDef, this._timeout);
        MetricSampler.Samples samples = this._metricSampler.getSamples(metricSamplerOptions);
        if (samples == null) {
            samples = MetricSampler.EMPTY_SAMPLES;
        }
        if (this._samplingMode == MetricSampler.SamplingMode.ALL || this._samplingMode == MetricSampler.SamplingMode.PARTITION_METRICS_ONLY) {
            this.usePartitionMetricSamples(samples.partitionMetricSamples());
        }
        if (this._samplingMode == MetricSampler.SamplingMode.ALL || this._samplingMode == MetricSampler.SamplingMode.BROKER_METRICS_ONLY) {
            this.useBrokerMetricSamples(samples.brokerMetricSamples());
        }
        return samples;
    }

    protected abstract void usePartitionMetricSamples(Set<PartitionMetricSample> var1);

    protected abstract void useBrokerMetricSamples(Set<BrokerMetricSample> var1);
}

