/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSamplerPartitionAssignor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricSamplerPartitionAssignor
implements MetricSamplerPartitionAssignor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetricSamplerPartitionAssignor.class);

    public void configure(Map<String, ?> configs) {
    }

    @Override
    public List<Set<TopicPartition>> assignPartitions(Cluster cluster, int numMetricFetchers) {
        if (numMetricFetchers != 1) {
            throw new IllegalArgumentException("DefaultMetricSamplerPartitionAssignor supports only a single metric fetcher.");
        }
        ArrayList<Set<TopicPartition>> assignments = new ArrayList<Set<TopicPartition>>();
        assignments.add(this.assignPartitions(cluster));
        return assignments;
    }

    @Override
    public Set<TopicPartition> assignPartitions(Cluster cluster) {
        HashSet<TopicPartition> assignment = new HashSet<TopicPartition>();
        for (String topic : cluster.topics()) {
            List partitionsForTopic = cluster.partitionsForTopic(topic);
            for (PartitionInfo partitionInfo : partitionsForTopic) {
                assignment.add(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()));
            }
        }
        LOG.trace("Partition assignment for metric fetcher: {}", assignment);
        return assignment;
    }
}

