/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.exception.SamplingException;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.CruiseControlMetricsProcessor;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSampler;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricSamplerOptions;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;

public abstract class AbstractMetricSampler
implements MetricSampler {
    private CruiseControlMetricsProcessor _metricsProcessor;

    public void configure(Map<String, ?> configs) {
        BrokerCapacityConfigResolver capacityResolver = (BrokerCapacityConfigResolver)configs.get("broker.capacity.config.resolver.object");
        if (capacityResolver == null) {
            throw new IllegalArgumentException("Metrics reporter sampler configuration is missing broker capacity config resolver object.");
        }
        boolean allowCpuCapacityEstimation = (Boolean)configs.get("sampling.allow.cpu.capacity.estimation");
        this._metricsProcessor = new CruiseControlMetricsProcessor(capacityResolver, allowCpuCapacityEstimation);
    }

    @Override
    public MetricSampler.Samples getSamples(Cluster cluster, Set<TopicPartition> assignedPartitions, long startTimeMs, long endTimeMs, MetricSampler.SamplingMode mode, MetricDef metricDef, long timeoutMs) throws SamplingException {
        MetricSamplerOptions metricSamplerOptions = new MetricSamplerOptions(cluster, assignedPartitions, startTimeMs, endTimeMs, mode, metricDef, timeoutMs);
        return this.getSamples(metricSamplerOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricSampler.Samples getSamples(MetricSamplerOptions metricSamplerOptions) throws SamplingException {
        int totalMetricsAdded = this.retrieveMetricsForProcessing(metricSamplerOptions);
        try {
            if (totalMetricsAdded > 0) {
                MetricSampler.Samples samples = this._metricsProcessor.process(metricSamplerOptions.cluster(), metricSamplerOptions.assignedPartitions(), metricSamplerOptions.mode());
                return samples;
            }
            MetricSampler.Samples samples = MetricSampler.EMPTY_SAMPLES;
            return samples;
        }
        finally {
            this._metricsProcessor.clear();
        }
    }

    protected abstract int retrieveMetricsForProcessing(MetricSamplerOptions var1) throws SamplingException;

    protected void addMetricForProcessing(CruiseControlMetric metric) {
        this._metricsProcessor.addMetric(metric);
    }
}

