/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.metricdefinition;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.metricdef.ValueComputingStrategy;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum KafkaMetricDef {
    CPU_USAGE(ValueComputingStrategy.AVG, DefScope.COMMON, Resource.CPU, true),
    DISK_USAGE(ValueComputingStrategy.LATEST, DefScope.COMMON, Resource.DISK, false),
    LEADER_BYTES_IN(ValueComputingStrategy.AVG, DefScope.COMMON, Resource.NW_IN, false),
    LEADER_BYTES_OUT(ValueComputingStrategy.AVG, DefScope.COMMON, Resource.NW_OUT, false),
    PRODUCE_RATE(ValueComputingStrategy.AVG, DefScope.COMMON, null, false),
    FETCH_RATE(ValueComputingStrategy.AVG, DefScope.COMMON, null, false),
    MESSAGE_IN_RATE(ValueComputingStrategy.AVG, DefScope.COMMON, null, false),
    REPLICATION_BYTES_IN_RATE(ValueComputingStrategy.AVG, DefScope.COMMON, Resource.NW_IN, false),
    REPLICATION_BYTES_OUT_RATE(ValueComputingStrategy.AVG, DefScope.COMMON, Resource.NW_OUT, false),
    BROKER_PRODUCE_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_REQUEST_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_REQUEST_HANDLER_POOL_IDLE_PERCENT(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_REQUEST_QUEUE_SIZE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_RESPONSE_QUEUE_SIZE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_TOTAL_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_TOTAL_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_LOCAL_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_LOCAL_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_LOG_FLUSH_RATE(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_LOG_FLUSH_TIME_MS_MAX(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_LOG_FLUSH_TIME_MS_MEAN(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_TOTAL_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_TOTAL_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_LOCAL_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_PRODUCE_LOCAL_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_LOG_FLUSH_TIME_MS_50TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false),
    BROKER_LOG_FLUSH_TIME_MS_999TH(ValueComputingStrategy.AVG, DefScope.BROKER_ONLY, null, false);

    private final ValueComputingStrategy _valueComputingStrategy;
    private final String _group;
    private final DefScope _defScope;
    private final boolean _toPredict;
    private static final Map<RawMetricType, KafkaMetricDef> TYPE_TO_DEF;
    private static final List<KafkaMetricDef> CACHED_VALUES;
    private static final List<KafkaMetricDef> CACHED_COMMON_DEF_VALUES;
    private static final List<KafkaMetricDef> CACHED_BROKER_DEF_VALUES;
    private static final MetricDef COMMON_METRIC_DEF;
    private static final MetricDef BROKER_METRIC_DEF;

    private KafkaMetricDef(ValueComputingStrategy strategy, DefScope defScope, Resource group, boolean toPredict) {
        this._valueComputingStrategy = strategy;
        this._defScope = defScope;
        this._group = group == null ? "" : group.name();
        this._toPredict = toPredict;
    }

    public ValueComputingStrategy valueComputingStrategy() {
        return this._valueComputingStrategy;
    }

    public DefScope defScope() {
        return this._defScope;
    }

    public String group() {
        return this._group;
    }

    public static List<KafkaMetricDef> cachedCommonDefValues() {
        return CACHED_COMMON_DEF_VALUES;
    }

    public static List<KafkaMetricDef> cachedBrokerDefValues() {
        return CACHED_BROKER_DEF_VALUES;
    }

    public static KafkaMetricDef forRawMetricType(RawMetricType type) {
        return TYPE_TO_DEF.get(type);
    }

    public static short commonMetricDefId(KafkaMetricDef def) {
        return COMMON_METRIC_DEF.metricInfo(def.name()).id();
    }

    public static MetricInfo commonMetricDefInfo(KafkaMetricDef def) {
        return BROKER_METRIC_DEF.metricInfo(def.name());
    }

    public static MetricDef commonMetricDef() {
        return COMMON_METRIC_DEF;
    }

    public static MetricDef brokerMetricDef() {
        return BROKER_METRIC_DEF;
    }

    public static List<MetricInfo> resourceToMetricInfo(Resource resource) {
        return KafkaMetricDef.commonMetricDef().metricInfoForGroup(resource.name());
    }

    public static List<Short> resourceToMetricIds(Resource resource) {
        ArrayList<Short> metricIds = new ArrayList<Short>();
        KafkaMetricDef.resourceToMetricInfo(resource).forEach(info -> metricIds.add(info.id()));
        return metricIds;
    }

    private static List<KafkaMetricDef> buildCachedCommonDefValues() {
        ArrayList<KafkaMetricDef> commonDefs = new ArrayList<KafkaMetricDef>();
        for (KafkaMetricDef def : KafkaMetricDef.values()) {
            if (def._defScope != DefScope.COMMON) continue;
            commonDefs.add(def);
        }
        return Collections.unmodifiableList(commonDefs);
    }

    private static MetricDef buildCommonMetricDef() {
        MetricDef metricDef = new MetricDef();
        for (KafkaMetricDef def : CACHED_COMMON_DEF_VALUES) {
            metricDef.define(def.name(), def.group(), def.valueComputingStrategy().name(), def._toPredict);
        }
        return metricDef;
    }

    private static MetricDef buildBrokerMetricDef() {
        MetricDef metricDef = new MetricDef();
        for (KafkaMetricDef def : CACHED_BROKER_DEF_VALUES) {
            metricDef.define(def.name(), def.group(), def.valueComputingStrategy().name(), def._toPredict);
        }
        return metricDef;
    }

    static {
        TYPE_TO_DEF = new HashMap<RawMetricType, KafkaMetricDef>();
        CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(KafkaMetricDef.values()));
        CACHED_COMMON_DEF_VALUES = KafkaMetricDef.buildCachedCommonDefValues();
        CACHED_BROKER_DEF_VALUES = CACHED_VALUES;
        COMMON_METRIC_DEF = KafkaMetricDef.buildCommonMetricDef();
        BROKER_METRIC_DEF = KafkaMetricDef.buildBrokerMetricDef();
        TYPE_TO_DEF.put(RawMetricType.TOPIC_BYTES_IN, LEADER_BYTES_IN);
        TYPE_TO_DEF.put(RawMetricType.TOPIC_BYTES_OUT, LEADER_BYTES_OUT);
        TYPE_TO_DEF.put(RawMetricType.TOPIC_REPLICATION_BYTES_IN, REPLICATION_BYTES_IN_RATE);
        TYPE_TO_DEF.put(RawMetricType.TOPIC_REPLICATION_BYTES_OUT, REPLICATION_BYTES_OUT_RATE);
        TYPE_TO_DEF.put(RawMetricType.TOPIC_PRODUCE_REQUEST_RATE, PRODUCE_RATE);
        TYPE_TO_DEF.put(RawMetricType.TOPIC_FETCH_REQUEST_RATE, FETCH_RATE);
        TYPE_TO_DEF.put(RawMetricType.TOPIC_MESSAGES_IN_PER_SEC, MESSAGE_IN_RATE);
        TYPE_TO_DEF.put(RawMetricType.PARTITION_SIZE, DISK_USAGE);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_BYTES_IN, LEADER_BYTES_IN);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_BYTES_OUT, LEADER_BYTES_OUT);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN, REPLICATION_BYTES_IN_RATE);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT, REPLICATION_BYTES_OUT_RATE);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE, PRODUCE_RATE);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE, FETCH_RATE);
        TYPE_TO_DEF.put(RawMetricType.ALL_TOPIC_MESSAGES_IN_PER_SEC, MESSAGE_IN_RATE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CPU_UTIL, CPU_USAGE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_REQUEST_RATE, BROKER_PRODUCE_REQUEST_RATE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_RATE, BROKER_CONSUMER_FETCH_REQUEST_RATE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_RATE, BROKER_FOLLOWER_FETCH_REQUEST_RATE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_REQUEST_HANDLER_AVG_IDLE_PERCENT, BROKER_REQUEST_HANDLER_POOL_IDLE_PERCENT);
        TYPE_TO_DEF.put(RawMetricType.BROKER_REQUEST_QUEUE_SIZE, BROKER_REQUEST_QUEUE_SIZE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_RESPONSE_QUEUE_SIZE, BROKER_RESPONSE_QUEUE_SIZE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MAX, BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MEAN, BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MAX, BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN, BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MAX, BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN, BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_TOTAL_TIME_MS_MAX, BROKER_PRODUCE_TOTAL_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_TOTAL_TIME_MS_MEAN, BROKER_PRODUCE_TOTAL_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MAX, BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MEAN, BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MAX, BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MEAN, BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_LOCAL_TIME_MS_MAX, BROKER_PRODUCE_LOCAL_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_LOCAL_TIME_MS_MEAN, BROKER_PRODUCE_LOCAL_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MAX, BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MEAN, BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MAX, BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MEAN, BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_LOG_FLUSH_RATE, BROKER_LOG_FLUSH_RATE);
        TYPE_TO_DEF.put(RawMetricType.BROKER_LOG_FLUSH_TIME_MS_MAX, BROKER_LOG_FLUSH_TIME_MS_MAX);
        TYPE_TO_DEF.put(RawMetricType.BROKER_LOG_FLUSH_TIME_MS_MEAN, BROKER_LOG_FLUSH_TIME_MS_MEAN);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_50TH, BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_999TH, BROKER_PRODUCE_REQUEST_QUEUE_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_50TH, BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_999TH, BROKER_CONSUMER_FETCH_REQUEST_QUEUE_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_50TH, BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_999TH, BROKER_FOLLOWER_FETCH_REQUEST_QUEUE_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_TOTAL_TIME_MS_50TH, BROKER_PRODUCE_TOTAL_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_TOTAL_TIME_MS_999TH, BROKER_PRODUCE_TOTAL_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_50TH, BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_999TH, BROKER_CONSUMER_FETCH_TOTAL_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_50TH, BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_999TH, BROKER_FOLLOWER_FETCH_TOTAL_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_LOCAL_TIME_MS_50TH, BROKER_PRODUCE_LOCAL_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_PRODUCE_LOCAL_TIME_MS_999TH, BROKER_PRODUCE_LOCAL_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH, BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH, BROKER_CONSUMER_FETCH_LOCAL_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH, BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH, BROKER_FOLLOWER_FETCH_LOCAL_TIME_MS_999TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_LOG_FLUSH_TIME_MS_50TH, BROKER_LOG_FLUSH_TIME_MS_50TH);
        TYPE_TO_DEF.put(RawMetricType.BROKER_LOG_FLUSH_TIME_MS_999TH, BROKER_LOG_FLUSH_TIME_MS_999TH);
    }

    public static enum DefScope {
        BROKER_ONLY,
        COMMON;

    }
}

