/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import java.io.Serializable;

public class ModelGeneration
implements Serializable {
    private static final long serialVersionUID = 1494955635123L;
    public static final int CLUSTER_GENERATION_ACCEPTABLE_STALENESS_LAG = 1;
    public static final int LOAD_GENERATION_ACCEPTABLE_STALENESS_LAG = 4;
    private final int _clusterGeneration;
    private final long _loadGeneration;
    private int _hash = 0;

    public ModelGeneration(int clusterGeneration, long loadGeneration) {
        this._clusterGeneration = clusterGeneration;
        this._loadGeneration = loadGeneration;
    }

    public int clusterGeneration() {
        return this._clusterGeneration;
    }

    public long loadGeneration() {
        return this._loadGeneration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelGeneration)) {
            return false;
        }
        ModelGeneration other = (ModelGeneration)o;
        return this._clusterGeneration == other.clusterGeneration() && this._loadGeneration == other.loadGeneration();
    }

    public boolean isStale(ModelGeneration latestModelGeneration) {
        return latestModelGeneration.clusterGeneration() - this._clusterGeneration > 1 || latestModelGeneration.loadGeneration() - this._loadGeneration > 4L;
    }

    public int hashCode() {
        if (this._hash != 0) {
            return this._hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this._clusterGeneration;
        this._hash = result = 31 * result + (int)this._loadGeneration;
        return result;
    }

    public String toString() {
        return String.format("[ClusterGeneration=%d,LoadGeneration=%d]", this._clusterGeneration, this._loadGeneration);
    }
}

