/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class ModelCompletenessRequirements {
    @JsonResponseField
    private static final String REQUIRED_NUM_SNAPSHOTS = "requiredNumSnapshots";
    @JsonResponseField
    private static final String MIN_MONITORED_PARTITION_PERCENTAGE = "minMonitoredPartitionsPercentage";
    @JsonResponseField
    private static final String INCLUDE_ALL_TOPICS = "includeAllTopics";
    private final int _minRequiredNumWindows;
    private final double _minMonitoredPartitionsPercentage;
    private final boolean _includeAllTopics;

    public ModelCompletenessRequirements(int minNumValidWindows, double minValidPartitionsRatio, boolean includeAllTopics) {
        if (minNumValidWindows <= 0) {
            throw new IllegalArgumentException("Invalid minNumValidWindows " + minNumValidWindows + ". The minNumValidWindows must be positive.");
        }
        if (minValidPartitionsRatio < 0.0 || minValidPartitionsRatio > 1.0) {
            throw new IllegalArgumentException("Invalid minValidPartitionsRatio " + minValidPartitionsRatio + ". The value must be between 0 and 1, both inclusive.");
        }
        this._minRequiredNumWindows = minNumValidWindows;
        this._includeAllTopics = includeAllTopics;
        this._minMonitoredPartitionsPercentage = minValidPartitionsRatio;
    }

    public int minRequiredNumWindows() {
        return this._minRequiredNumWindows;
    }

    public double minMonitoredPartitionsPercentage() {
        return this._minMonitoredPartitionsPercentage;
    }

    public boolean includeAllTopics() {
        return this._includeAllTopics;
    }

    public ModelCompletenessRequirements stronger(ModelCompletenessRequirements other) {
        if (other == null) {
            return this;
        }
        return new ModelCompletenessRequirements(Math.max(this._minRequiredNumWindows, other.minRequiredNumWindows()), Math.max(this._minMonitoredPartitionsPercentage, other.minMonitoredPartitionsPercentage()), this._includeAllTopics || other.includeAllTopics());
    }

    public ModelCompletenessRequirements weaker(ModelCompletenessRequirements other) {
        if (other == null) {
            return this;
        }
        return new ModelCompletenessRequirements(Math.min(this._minRequiredNumWindows, other.minRequiredNumWindows()), Math.min(this._minMonitoredPartitionsPercentage, other.minMonitoredPartitionsPercentage()), this._includeAllTopics && other.includeAllTopics());
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> requirements = new HashMap<String, Object>();
        requirements.put(REQUIRED_NUM_SNAPSHOTS, this._minRequiredNumWindows);
        requirements.put(MIN_MONITORED_PARTITION_PERCENTAGE, this._minMonitoredPartitionsPercentage);
        requirements.put(INCLUDE_ALL_TOPICS, this._includeAllTopics);
        return requirements;
    }

    public String toString() {
        return String.format("(requiredNumWindows=%d, minMonitoredPartitionPercentage=%.3f, includedAllTopics=%s)", this._minRequiredNumWindows, this._minMonitoredPartitionsPercentage, this._includeAllTopics);
    }
}

