/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.kafka.cruisecontrol.model.LinearRegressionModelParameters;
import com.linkedin.kafka.cruisecontrol.model.ModelParameters;
import com.linkedin.kafka.cruisecontrol.monitor.task.LoadMonitorTaskRunner;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;

@JsonResponseClass
public class LoadMonitorState {
    @JsonResponseField
    private static final String STATE = "state";
    @JsonResponseField(required=false)
    private static final String REASON_OF_LATEST_PAUSE_OR_RESUME = "reasonOfLatestPauseOrResume";
    @JsonResponseField
    private static final String TRAINED = "trained";
    @JsonResponseField
    private static final String TRAINING_PCT = "trainingPct";
    @JsonResponseField
    private static final String NUM_MONITORED_WINDOWS = "numMonitoredWindows";
    @JsonResponseField(required=false)
    private static final String MONITORED_WINDOWS = "monitoredWindows";
    @JsonResponseField
    private static final String NUM_VALID_PARTITIONS = "numValidPartitions";
    @JsonResponseField
    private static final String NUM_TOTAL_PARTITIONS = "numTotalPartitions";
    @JsonResponseField
    private static final String MONITORING_COVERAGE_PCT = "monitoringCoveragePct";
    @JsonResponseField
    private static final String NUM_FLAWED_PARTITIONS = "numFlawedPartitions";
    @JsonResponseField(required=false)
    private static final String BOOTSTRAP_PROGRESS_PCT = "bootstrapProgressPct";
    @JsonResponseField(required=false)
    private static final String LOADING_PROGRESS_PCT = "loadingProgressPct";
    @JsonResponseField(required=false)
    private static final String ERROR = "error";
    private static final double UNDEFINED_PROGRESS = -1.0;
    private final LoadMonitorTaskRunner.LoadMonitorTaskRunnerState _loadMonitorTaskRunnerState;
    private final int _numValidWindows;
    private final SortedMap<Long, Float> _monitoredWindows;
    private final double _validPartitionsRatio;
    private final int _numFlawedPartitions;
    private final int _totalNumPartitions;
    private final double _bootstrapProgress;
    private final double _loadingProgress;
    private final String _reasonOfLatestPauseOrResume;

    private LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState state, int numValidWindows, SortedMap<Long, Float> monitoredWindows, double validPartitionsRatio, int totalNumPartitions, int numFlawedPartitions, double bootstrapProgress, double loadingProgress, String reasonOfLatestPauseOrResume) {
        this._loadMonitorTaskRunnerState = state;
        this._numValidWindows = numValidWindows;
        this._monitoredWindows = monitoredWindows;
        this._validPartitionsRatio = validPartitionsRatio;
        this._numFlawedPartitions = numFlawedPartitions;
        this._totalNumPartitions = totalNumPartitions;
        this._bootstrapProgress = bootstrapProgress;
        this._loadingProgress = loadingProgress;
        this._reasonOfLatestPauseOrResume = reasonOfLatestPauseOrResume;
    }

    private LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState state, int numValidWindows, SortedMap<Long, Float> monitoredWindows, double validPartitionsRatio, int totalNumPartitions, int numFlawedPartitions, double bootstrapProgress, double loadingProgress) {
        this(state, numValidWindows, monitoredWindows, validPartitionsRatio, totalNumPartitions, numFlawedPartitions, bootstrapProgress, loadingProgress, null);
    }

    public static LoadMonitorState notStarted() {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.NOT_STARTED, 0, null, 0.0, -1, -1, -1.0, -1.0);
    }

    public static LoadMonitorState running(int numValidWindows, SortedMap<Long, Float> partitionCoverageByWindows, double validPartitionsRatio, int totalNumPartitions, int numPartitionsWithExtrapolations, String reasonOfLatestPauseOrResume) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.RUNNING, numValidWindows, partitionCoverageByWindows, validPartitionsRatio, totalNumPartitions, numPartitionsWithExtrapolations, -1.0, -1.0, reasonOfLatestPauseOrResume);
    }

    public static LoadMonitorState paused(int numValidWindows, SortedMap<Long, Float> monitoredSnapshotWindows, double validPartitionsRatio, int totalNumPartitions, int numPartitionsWithExtrapolations, String reasonOfLatestPauseOrResume) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.PAUSED, numValidWindows, monitoredSnapshotWindows, validPartitionsRatio, totalNumPartitions, numPartitionsWithExtrapolations, -1.0, -1.0, reasonOfLatestPauseOrResume);
    }

    public static LoadMonitorState sampling(int numValidWindows, SortedMap<Long, Float> monitoredSnapshotWindows, double validPartitionsRatio, int totalNumPartitions, int numPartitionsWithExtrapolations) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.SAMPLING, numValidWindows, monitoredSnapshotWindows, validPartitionsRatio, totalNumPartitions, numPartitionsWithExtrapolations, -1.0, -1.0);
    }

    public static LoadMonitorState bootstrapping(int numValidWindows, SortedMap<Long, Float> monitoredSnapshotWindows, double validPartitionsRatio, int totalNumPartitions, double bootstrapProgress, int numPartitionsWithExtrapolations) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.BOOTSTRAPPING, numValidWindows, monitoredSnapshotWindows, validPartitionsRatio, totalNumPartitions, numPartitionsWithExtrapolations, bootstrapProgress, -1.0);
    }

    public static LoadMonitorState training(int numValidWindows, SortedMap<Long, Float> monitoredSnapshotWindows, double validPartitionsRatio, int totalNumPartitions, int numPartitionsWithExtrapolations) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.TRAINING, numValidWindows, monitoredSnapshotWindows, validPartitionsRatio, totalNumPartitions, numPartitionsWithExtrapolations, -1.0, -1.0);
    }

    public static LoadMonitorState loading(int numValidWindows, SortedMap<Long, Float> monitoredSnapshotWindows, double validPartitionsRatio, int totalNumPartitions, double loadingProgress) {
        return new LoadMonitorState(LoadMonitorTaskRunner.LoadMonitorTaskRunnerState.LOADING, numValidWindows, monitoredSnapshotWindows, validPartitionsRatio, totalNumPartitions, -1, -1.0, loadingProgress);
    }

    private void setCommonJsonGenericAttributeCollection(boolean verbose, Map<String, Object> loadMonitorState) {
        loadMonitorState.put(STATE, (Object)this._loadMonitorTaskRunnerState);
        loadMonitorState.put(TRAINED, ModelParameters.trainingCompleted());
        loadMonitorState.put(TRAINING_PCT, ModelParameters.trainingCompleted() ? 100.0 : ModelParameters.modelCoefficientTrainingCompleteness() * 100.0);
        loadMonitorState.put(NUM_MONITORED_WINDOWS, this._monitoredWindows.size());
        if (verbose) {
            loadMonitorState.put(MONITORED_WINDOWS, this._monitoredWindows);
        }
        loadMonitorState.put(NUM_VALID_PARTITIONS, (int)(this._validPartitionsRatio * (double)this._totalNumPartitions));
        loadMonitorState.put(NUM_TOTAL_PARTITIONS, this._totalNumPartitions);
        loadMonitorState.put(MONITORING_COVERAGE_PCT, LoadMonitorState.nanToZero(this.validPartitionsRatio() * 100.0));
        loadMonitorState.put(NUM_FLAWED_PARTITIONS, this._numFlawedPartitions);
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> loadMonitorState = new HashMap<String, Object>();
        switch (this._loadMonitorTaskRunnerState) {
            case RUNNING: 
            case SAMPLING: 
            case PAUSED: 
            case BOOTSTRAPPING: 
            case TRAINING: 
            case LOADING: {
                this.setCommonJsonGenericAttributeCollection(verbose, loadMonitorState);
                break;
            }
        }
        switch (this._loadMonitorTaskRunnerState) {
            case RUNNING: 
            case PAUSED: {
                loadMonitorState.put(REASON_OF_LATEST_PAUSE_OR_RESUME, this._reasonOfLatestPauseOrResume == null ? "N/A" : this._reasonOfLatestPauseOrResume);
                break;
            }
            case SAMPLING: 
            case TRAINING: {
                break;
            }
            case BOOTSTRAPPING: {
                loadMonitorState.put(BOOTSTRAP_PROGRESS_PCT, LoadMonitorState.nanToZero(this._bootstrapProgress * 100.0));
                break;
            }
            case LOADING: {
                loadMonitorState.put(LOADING_PROGRESS_PCT, LoadMonitorState.nanToZero(this._loadingProgress * 100.0));
                break;
            }
            default: {
                loadMonitorState.put(STATE, (Object)this._loadMonitorTaskRunnerState);
                loadMonitorState.put(ERROR, "ILLEGAL_STATE_EXCEPTION");
            }
        }
        return loadMonitorState;
    }

    public static double nanToZero(double v) {
        return Double.isNaN(v) ? 0.0 : v;
    }

    public String toString() {
        String trained = ModelParameters.trainingCompleted() ? "(TRAINED)" : String.format("(%.3f%% trained)", ModelParameters.modelCoefficientTrainingCompleteness() * 100.0);
        float validWindowPercent = (float)this._numValidWindows / (float)this._monitoredWindows.size();
        switch (this._loadMonitorTaskRunnerState) {
            case NOT_STARTED: {
                return String.format("{state: %s}", new Object[]{this._loadMonitorTaskRunnerState});
            }
            case RUNNING: 
            case PAUSED: {
                return String.format("{state: %s%s, NumValidWindows: (%d/%d) (%.3f%%), NumValidPartitions: %d/%d (%.3f%%), flawedPartitions: %d%s}", new Object[]{this._loadMonitorTaskRunnerState, trained, this._numValidWindows, this._monitoredWindows.size(), Float.valueOf(validWindowPercent * 100.0f), this.numValidPartitions(), this._totalNumPartitions, this._validPartitionsRatio * 100.0, this._numFlawedPartitions, this._reasonOfLatestPauseOrResume == null ? "" : String.format(", reasonOfPauseOrResume: %s", this._reasonOfLatestPauseOrResume)});
            }
            case SAMPLING: {
                return String.format("{state: %s%s, NumValidWindows: (%d/%d) (%.3f%%), NumValidPartitions: %d/%d (%.3f%%), flawedPartitions: %d}", new Object[]{this._loadMonitorTaskRunnerState, trained, this._numValidWindows, this._monitoredWindows.size(), Float.valueOf(validWindowPercent * 100.0f), this.numValidPartitions(), this._totalNumPartitions, this._validPartitionsRatio * 100.0, this._numFlawedPartitions});
            }
            case BOOTSTRAPPING: {
                return String.format("{state: %s%s, BootstrapProgress: %.3f%%, NumValidWindows: (%d/%d) (%.3f%%), NumValidPartitions: %d/%d (%.3f%%), flawedPartitions: %d}", new Object[]{this._loadMonitorTaskRunnerState, trained, this._bootstrapProgress * 100.0, this._numValidWindows, this._monitoredWindows.size(), Float.valueOf(validWindowPercent * 100.0f), this.numValidPartitions(), this._totalNumPartitions, this._validPartitionsRatio * 100.0, this._numFlawedPartitions});
            }
            case TRAINING: {
                return String.format("{state: %s%s, NumValidWindows: (%d/%d) (%.3f%%) , NumValidPartitions: %d/%d (%.3f%%), FlawedPartitions: %d}", new Object[]{this._loadMonitorTaskRunnerState, trained, this._monitoredWindows.size(), this._numValidWindows, Float.valueOf(validWindowPercent * 100.0f), this.numValidPartitions(), this._totalNumPartitions, this._validPartitionsRatio * 100.0, this._numFlawedPartitions});
            }
            case LOADING: {
                return String.format("{state: %s%s, LoadingProgress: %.3f%%, NumValidWindows: (%d/%d): (%.3f%%), NumValidPartitions: %d/%d (%.3f%%), FlawedPartitions: %d}", new Object[]{this._loadMonitorTaskRunnerState, trained, this._loadingProgress * 100.0, this._numValidWindows, this._monitoredWindows.size(), Float.valueOf(validWindowPercent * 100.0f), this.numValidPartitions(), this._totalNumPartitions, this._validPartitionsRatio * 100.0, this._numFlawedPartitions});
            }
        }
        throw new IllegalStateException("Should never be here");
    }

    public LoadMonitorTaskRunner.LoadMonitorTaskRunnerState state() {
        return this._loadMonitorTaskRunnerState;
    }

    public int numValidWindows() {
        return this._numValidWindows;
    }

    public SortedMap<Long, Float> monitoredWindows() {
        return this._monitoredWindows;
    }

    public int numValidPartitions() {
        return (int)(this._validPartitionsRatio * (double)this._totalNumPartitions);
    }

    public double validPartitionsRatio() {
        return this._validPartitionsRatio;
    }

    public double bootstrapProgress() {
        return this._bootstrapProgress;
    }

    @Nonnull
    public LinearRegressionModelParameters.LinearRegressionModelState detailTrainingProgress() {
        return ModelParameters.linearRegressionModelState();
    }
}

