/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class SortedReplicasHelper {
    private Set<Function<Replica, Boolean>> _selectionFuncs = new LinkedHashSet<Function<Replica, Boolean>>();
    private Set<Function<Replica, Integer>> _priorityFuncs = new LinkedHashSet<Function<Replica, Integer>>();
    private Function<Replica, Double> _scoreFunc;

    public SortedReplicasHelper maybeAddSelectionFunc(Function<Replica, Boolean> selectionFunc, boolean addConditionSatisfied) {
        if (addConditionSatisfied) {
            this._selectionFuncs.add(selectionFunc);
        }
        return this;
    }

    public SortedReplicasHelper addSelectionFunc(Function<Replica, Boolean> selectionFunc) {
        return this.maybeAddSelectionFunc(selectionFunc, true);
    }

    public SortedReplicasHelper maybeAddPriorityFunc(Function<Replica, Integer> priorityFunc, boolean addConditionSatisfied) {
        if (addConditionSatisfied) {
            this._priorityFuncs.add(priorityFunc);
        }
        return this;
    }

    public SortedReplicasHelper addPriorityFunc(Function<Replica, Integer> priorityFunc) {
        return this.maybeAddPriorityFunc(priorityFunc, true);
    }

    public SortedReplicasHelper setScoreFunc(Function<Replica, Double> scoreFunc) {
        this._scoreFunc = scoreFunc;
        return this;
    }

    public void trackSortedReplicasFor(String sortName, Disk disk) {
        disk.trackSortedReplicas(sortName, new HashSet<Function<Replica, Boolean>>(this._selectionFuncs), new ArrayList<Function<Replica, Integer>>(this._priorityFuncs), this._scoreFunc);
    }

    public void trackSortedReplicasFor(String sortName, Broker broker) {
        broker.trackSortedReplicas(sortName, new HashSet<Function<Replica, Boolean>>(this._selectionFuncs), new ArrayList<Function<Replica, Integer>>(this._priorityFuncs), this._scoreFunc);
    }

    public void trackSortedReplicasFor(String sortName, ClusterModel clusterModel) {
        clusterModel.trackSortedReplicas(sortName, new HashSet<Function<Replica, Boolean>>(this._selectionFuncs), new ArrayList<Function<Replica, Integer>>(this._priorityFuncs), this._scoreFunc);
    }
}

