/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

public class SortedReplicas {
    private final Broker _broker;
    private final Disk _disk;
    private final SortedSet<Replica> _sortedReplicas;
    private final Set<Function<Replica, Boolean>> _selectionFuncs;
    private final List<Function<Replica, Integer>> _priorityFuncs;
    private final Function<Replica, Double> _scoreFunc;
    private final Comparator<Replica> _replicaComparator;
    private boolean _initialized;

    SortedReplicas(Broker broker, Set<Function<Replica, Boolean>> selectionFuncs, List<Function<Replica, Integer>> priorityFuncs, Function<Replica, Double> scoreFunction) {
        this(broker, null, selectionFuncs, priorityFuncs, scoreFunction, true);
    }

    SortedReplicas(Broker broker, Disk disk, Set<Function<Replica, Boolean>> selectionFuncs, List<Function<Replica, Integer>> priorityFuncs, Function<Replica, Double> scoreFunc, boolean initialize) {
        this._broker = broker;
        this._disk = disk;
        this._selectionFuncs = selectionFuncs;
        this._scoreFunc = scoreFunc;
        this._priorityFuncs = priorityFuncs;
        this._replicaComparator = (r1, r2) -> {
            int result = this.comparePriority((Replica)r1, (Replica)r2);
            if (result != 0) {
                return result;
            }
            if (this._scoreFunc != null && (result = Double.compare(this._scoreFunc.apply((Replica)r1), this._scoreFunc.apply((Replica)r2))) != 0) {
                return result;
            }
            return r1.compareTo((Replica)r2);
        };
        this._sortedReplicas = new TreeSet<Replica>(this._replicaComparator);
        this._initialized = !initialize;
    }

    public SortedSet<Replica> sortedReplicas(boolean clone) {
        this.ensureInitialize();
        if (clone) {
            TreeSet<Replica> result = new TreeSet<Replica>(this._replicaComparator);
            result.addAll(this._sortedReplicas);
            return result;
        }
        return Collections.unmodifiableSortedSet(this._sortedReplicas);
    }

    public Set<Function<Replica, Boolean>> selectionFunctions() {
        return this._selectionFuncs;
    }

    public List<Function<Replica, Integer>> priorityFunctions() {
        return this._priorityFuncs;
    }

    public Function<Replica, Double> scoreFunction() {
        return this._scoreFunc;
    }

    public void add(Replica replica) {
        if (this._initialized && (this._selectionFuncs == null || this._selectionFuncs.stream().allMatch(func -> (Boolean)func.apply(replica)))) {
            this._sortedReplicas.add(replica);
        }
    }

    void remove(Replica replica) {
        if (this._initialized) {
            this._sortedReplicas.remove(replica);
        }
    }

    int numReplicas() {
        return this._sortedReplicas.size();
    }

    private void ensureInitialize() {
        if (!this._initialized) {
            this._initialized = true;
            if (this._disk != null) {
                this._disk.replicas().forEach(this::add);
            } else {
                this._broker.replicas().forEach(this::add);
            }
        }
    }

    private int comparePriority(Replica replica1, Replica replica2) {
        if (this._priorityFuncs != null) {
            for (Function<Replica, Integer> priorityFunction : this._priorityFuncs) {
                int p2;
                int p1 = priorityFunction.apply(replica1);
                int result = Integer.compare(p1, p2 = priorityFunction.apply(replica2).intValue());
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }
}

