/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.util.Set;
import java.util.function.Function;

public class ReplicaSortFunctionFactory {
    private static final Function<Replica, Integer> PRIORITIZE_IMMIGRANTS = r -> r.originalBroker() != r.broker() ? 0 : 1;
    private static final Function<Replica, Integer> PRIORITIZE_OFFLINE_REPLICAS = r -> r.isCurrentOffline() ? 0 : 1;
    private static final Function<Replica, Integer> PRIORITIZE_DISK_IMMIGRANTS = r -> r.originalDisk() != r.disk() ? 0 : 1;
    private static final Function<Replica, Boolean> SELECT_LEADERS = Replica::isLeader;
    private static final Function<Replica, Boolean> SELECT_FOLLOWERS = r -> !r.isLeader();
    private static final Function<Replica, Boolean> SELECT_ONLINE_REPLICAS = r -> !r.isCurrentOffline();
    private static final Function<Replica, Boolean> SELECT_OFFLINE_REPLICAS = Replica::isCurrentOffline;
    private static final Function<Replica, Boolean> SELECT_IMMIGRANTS = r -> r.originalBroker() != r.broker();
    private static final Function<Replica, Boolean> SELECT_IMMIGRANT_OR_OFFLINE_REPLICAS = r -> r.originalBroker() != r.broker() || r.isCurrentOffline();

    private ReplicaSortFunctionFactory() {
    }

    public static Function<Replica, Double> sortByMetricGroupValue(String metricGroup) {
        return r -> {
            MetricValues metricValues = r.load().loadByWindows().valuesForGroup(metricGroup, KafkaMetricDef.commonMetricDef(), true);
            return metricValues.avg();
        };
    }

    public static Function<Replica, Double> reverseSortByMetricGroupValue(String metricGroup) {
        return r -> {
            MetricValues metricValues = r.load().loadByWindows().valuesForGroup(metricGroup, KafkaMetricDef.commonMetricDef(), true);
            return -((double)metricValues.avg());
        };
    }

    public static Function<Replica, Integer> prioritizeImmigrants() {
        return PRIORITIZE_IMMIGRANTS;
    }

    public static Function<Replica, Integer> prioritizeOfflineReplicas() {
        return PRIORITIZE_OFFLINE_REPLICAS;
    }

    public static Function<Replica, Integer> prioritizeDiskImmigrants() {
        return PRIORITIZE_DISK_IMMIGRANTS;
    }

    public static Function<Replica, Boolean> selectImmigrants() {
        return SELECT_IMMIGRANTS;
    }

    public static Function<Replica, Boolean> selectImmigrantOrOfflineReplicas() {
        return SELECT_IMMIGRANT_OR_OFFLINE_REPLICAS;
    }

    public static Function<Replica, Boolean> selectLeaders() {
        return SELECT_LEADERS;
    }

    public static Function<Replica, Boolean> selectFollowers() {
        return SELECT_FOLLOWERS;
    }

    public static Function<Replica, Boolean> selectOfflineReplicas() {
        return SELECT_OFFLINE_REPLICAS;
    }

    public static Function<Replica, Boolean> selectOnlineReplicas() {
        return SELECT_ONLINE_REPLICAS;
    }

    public static Function<Replica, Boolean> selectReplicasBasedOnExcludedTopics(Set<String> excludedTopics) {
        return r -> r.isOriginalOffline() || !excludedTopics.contains(r.topicPartition().topic());
    }

    public static Function<Replica, Boolean> selectReplicasAboveLimit(Resource resource, double limit) {
        return r -> r.load().expectedUtilizationFor(resource) > limit;
    }

    public static Function<Replica, Boolean> selectReplicasBelowLimit(Resource resource, double limit) {
        return r -> r.load().expectedUtilizationFor(resource) < limit;
    }
}

