/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.ModelUtils;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public class Replica
implements Serializable,
Comparable<Replica> {
    public static final Replica MIN_REPLICA = new Replica(null, null, false);
    public static final Replica MAX_REPLICA = new Replica(null, null, false);
    private final TopicPartition _tp;
    private final Load _load;
    private final Broker _originalBroker;
    private boolean _isOriginalOffline;
    private Broker _broker;
    private boolean _isLeader;
    private final Disk _originalDisk;
    private Disk _disk;

    Replica(TopicPartition tp, Broker broker, boolean isLeader) {
        this(tp, broker, isLeader, false, null);
    }

    Replica(TopicPartition tp, Broker broker, boolean isLeader, boolean isOriginalOffline, Disk disk) {
        this._tp = tp;
        this._load = new Load();
        this._originalBroker = broker;
        this._broker = broker;
        this._isLeader = isLeader;
        this._isOriginalOffline = isOriginalOffline;
        this._originalDisk = disk;
        this._disk = disk;
    }

    public boolean isOriginalOffline() {
        return this._isOriginalOffline || !this._originalBroker.isAlive();
    }

    public boolean isCurrentOffline() {
        return this.isOriginalOffline() && this._broker.id() == this._originalBroker.id() || !this._broker.isAlive();
    }

    void markOriginalOffline() {
        if (this._broker.id() != this._originalBroker.id()) {
            throw new IllegalStateException("Cannot mark an immigrant replica as offline.");
        }
        this._isOriginalOffline = true;
        this._originalBroker.currentOfflineReplicas().add(this);
    }

    public TopicPartition topicPartition() {
        return this._tp;
    }

    public Load load() {
        return this._load;
    }

    public Broker originalBroker() {
        return this._originalBroker;
    }

    public Broker broker() {
        return this._broker;
    }

    public boolean isLeader() {
        return this._isLeader;
    }

    public boolean isImmigrant() {
        return this._originalBroker != this._broker;
    }

    void setBroker(Broker broker) {
        this._broker = broker;
    }

    void setDisk(Disk disk) {
        this._disk = disk;
    }

    public Disk originalDisk() {
        return this._originalDisk;
    }

    public Disk disk() {
        return this._disk;
    }

    void setLeadership(boolean leader) {
        this._isLeader = leader;
    }

    void setMetricValues(AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        this._load.initializeMetricValues(aggregatedMetricValues, windows);
    }

    void clearLoad() {
        this._load.clearLoad();
    }

    AggregatedMetricValues makeFollower() {
        AggregatedMetricValues leaderLoadDelta = this.leaderLoadDelta(true);
        this.setLeadership(false);
        return leaderLoadDelta;
    }

    private AggregatedMetricValues leaderLoadDelta(boolean updateLoad) {
        if (!this._isLeader) {
            throw new IllegalArgumentException("This method can only be invoked on a leader replica.");
        }
        short cpuMetricId = KafkaMetricDef.resourceToMetricIds(Resource.CPU).get(0);
        AggregatedMetricValues leadershipNwOutLoad = this._load.loadFor(Resource.NW_OUT, true);
        AggregatedMetricValues leadershipLoadDelta = new AggregatedMetricValues();
        MetricValues cpuLoadChange = this.computeCpuLoadAsFollower(leadershipNwOutLoad, updateLoad);
        leadershipLoadDelta.add(cpuMetricId, cpuLoadChange);
        leadershipLoadDelta.add(leadershipNwOutLoad);
        if (updateLoad) {
            this._load.clearLoadFor(Resource.NW_OUT);
        }
        return leadershipLoadDelta;
    }

    public Load getFollowerLoadFromLeader() {
        Load load = new Load();
        load.initializeMetricValues(this._load.loadByWindows(), this._load.windows());
        load.subtractLoad(this.leaderLoadDelta(false));
        return load;
    }

    private MetricValues computeCpuLoadAsFollower(AggregatedMetricValues leadershipNwOutLoad, boolean updateLoad) {
        short cpuMetricId = KafkaMetricDef.resourceToMetricIds(Resource.CPU).get(0);
        MetricValues cpuLoad = this._load.loadFor(Resource.CPU, true).valuesFor(cpuMetricId);
        AggregatedMetricValues leadershipNwInLoad = this._load.loadFor(Resource.NW_IN, true);
        MetricValues cpuLoadChange = new MetricValues(this._load.numWindows());
        MetricValues totalNetworkOutLoad = leadershipNwOutLoad.valuesForGroup(Resource.NW_OUT.name(), KafkaMetricDef.commonMetricDef(), false);
        MetricValues totalNetworkInLoad = leadershipNwInLoad.valuesForGroup(Resource.NW_IN.name(), KafkaMetricDef.commonMetricDef(), false);
        for (int i = 0; i < cpuLoad.length(); ++i) {
            double newCpuLoad = ModelUtils.getFollowerCpuUtilFromLeaderLoad(totalNetworkInLoad.get(i), totalNetworkOutLoad.get(i), cpuLoad.get(i));
            cpuLoadChange.set(i, cpuLoad.get(i) - newCpuLoad);
            if (!updateLoad) continue;
            cpuLoad.set(i, newCpuLoad);
        }
        return cpuLoadChange;
    }

    void makeLeader(AggregatedMetricValues leadershipLoadDelta) {
        this.setLeadership(true);
        this._load.addLoad(leadershipLoadDelta);
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> replicaMap = new HashMap<String, Object>();
        replicaMap.put("isLeader", this._isLeader);
        replicaMap.put("brokerid", this._broker.id());
        replicaMap.put("topic", this._tp.topic());
        replicaMap.put("partition", this._tp.partition());
        replicaMap.put("load", this._load.getJsonStructure());
        return replicaMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(String.format("<Replica isLeader=\"%s\" id=\"%d\">%n%s", this.isLeader(), this._broker.id(), this._tp).getBytes(StandardCharsets.UTF_8));
        this._load.writeTo(out);
        out.write("</Replica>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return String.format("Replica[isLeader=%s,rack=%s,broker=%d,TopicPartition=%s,origBroker=%d,isOriginalOffline=%s,isCurrentOffline=%s]", this._isLeader, this._broker.rack().id(), this._broker.id(), this._tp, this._originalBroker == null ? -1 : this._originalBroker.id(), this.isOriginalOffline(), this.isCurrentOffline());
    }

    @Override
    public int compareTo(Replica o) {
        boolean isR1Offline = this.isCurrentOffline();
        boolean isR2Offline = o.isCurrentOffline();
        if (isR1Offline && !isR2Offline) {
            return -1;
        }
        if (!isR1Offline && isR2Offline) {
            return 1;
        }
        if (this._tp.partition() > o.topicPartition().partition()) {
            return 1;
        }
        if (this._tp.partition() < o.topicPartition().partition()) {
            return -1;
        }
        if (this._originalBroker.id() > o.originalBroker().id()) {
            return 1;
        }
        if (this._originalBroker.id() < o.originalBroker().id()) {
            return -1;
        }
        return this._tp.topic().compareTo(o.topicPartition().topic());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replica replica = (Replica)o;
        return Objects.equals(this._tp, replica._tp) && this._originalBroker.id() == replica.originalBroker().id();
    }

    public int hashCode() {
        return Objects.hash(this._tp, this._originalBroker.id());
    }
}

