/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Host;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class Rack
implements Serializable {
    private static final long serialVersionUID = 6866290448556002509L;
    private final String _id;
    private final Map<String, Host> _hosts;
    private final Map<Integer, Broker> _brokers;
    private Load _load;
    private final double[] _rackCapacity;

    Rack(String id) {
        this._id = id;
        this._hosts = new HashMap<String, Host>();
        this._brokers = new HashMap<Integer, Broker>();
        this._load = new Load();
        this._rackCapacity = new double[Resource.cachedValues().size()];
    }

    public Load load() {
        return this._load;
    }

    public String id() {
        return this._id;
    }

    public Collection<Broker> brokers() {
        return this._brokers.values();
    }

    public Collection<Host> hosts() {
        return this._hosts.values();
    }

    public Broker broker(int brokerId) {
        return this._brokers.get(brokerId);
    }

    public List<Replica> replicas() {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Host host : this._hosts.values()) {
            replicas.addAll(host.replicas());
        }
        return replicas;
    }

    public int numTopicReplicas(String topic) {
        int numTopicReplicas = 0;
        for (Host host : this._hosts.values()) {
            numTopicReplicas += host.numTopicReplicas(topic);
        }
        return numTopicReplicas;
    }

    public Set<String> topics() {
        HashSet<String> topics = new HashSet<String>();
        for (Broker broker : this._brokers.values()) {
            topics.addAll(broker.topics());
        }
        return topics;
    }

    public double capacityFor(Resource resource) {
        return this._rackCapacity[resource.id()];
    }

    public boolean isRackAlive() {
        for (Host host : this._hosts.values()) {
            if (!host.isAlive()) continue;
            return true;
        }
        return false;
    }

    Replica removeReplica(int brokerId, TopicPartition tp) {
        Broker broker = this._brokers.get(brokerId);
        if (broker != null) {
            Replica removedReplica = broker.host().removeReplica(brokerId, tp);
            this._load.subtractLoad(removedReplica.load());
            return removedReplica;
        }
        return null;
    }

    void addReplica(Replica replica) {
        replica.broker().host().addReplica(replica);
        this._load.addLoad(replica.load());
    }

    AggregatedMetricValues makeFollower(int brokerId, TopicPartition tp) {
        Host host = this._brokers.get(brokerId).host();
        AggregatedMetricValues leadershipLoadDelta = host.makeFollower(brokerId, tp);
        this._load.subtractLoad(leadershipLoadDelta);
        return leadershipLoadDelta;
    }

    void makeLeader(int brokerId, TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Host host = this._brokers.get(brokerId).host();
        host.makeLeader(brokerId, tp, leadershipLoadDelta);
        this._load.addLoad(leadershipLoadDelta);
    }

    void clearLoad() {
        this._hosts.values().forEach(Host::clearLoad);
        this._load.clearLoad();
    }

    void setReplicaLoad(int brokerId, TopicPartition tp, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        Host host = this._brokers.get(brokerId).host();
        host.setReplicaLoad(brokerId, tp, aggregatedMetricValues, windows);
        this._load.addMetricValues(aggregatedMetricValues, windows);
    }

    Broker createBroker(int brokerId, String hostName, BrokerCapacityInfo brokerCapacityInfo, boolean populateReplicaPlacementInfo) {
        Host host = this._hosts.computeIfAbsent(hostName, name -> new Host((String)name, this));
        Broker broker = host.createBroker(brokerId, brokerCapacityInfo, populateReplicaPlacementInfo);
        this._brokers.put(brokerId, broker);
        for (Map.Entry<Resource, Double> entry : brokerCapacityInfo.capacity().entrySet()) {
            Resource resource = entry.getKey();
            int n = resource.id();
            this._rackCapacity[n] = this._rackCapacity[n] + (resource == Resource.CPU ? entry.getValue() * (double)brokerCapacityInfo.numCpuCores() : entry.getValue());
        }
        return broker;
    }

    void setBrokerState(int brokerId, Broker.State newState) {
        Broker broker = this.broker(brokerId);
        broker.host().setBrokerState(brokerId, newState);
        for (Resource r : Resource.cachedValues()) {
            double capacity = 0.0;
            for (Host h : this._hosts.values()) {
                if (!h.isAlive()) continue;
                capacity += h.capacityFor(r);
            }
            this._rackCapacity[r.id()] = capacity;
        }
    }

    void markDiskDead(int brokerId, String logdir) {
        Broker broker = this.broker(brokerId);
        double capacityLost = broker.host().markDiskDead(brokerId, logdir);
        int n = Resource.DISK.id();
        this._rackCapacity[n] = this._rackCapacity[n] - capacityLost;
    }

    public Map<String, Object> getJsonStructure() {
        ArrayList<Map<String, Object>> hostList = new ArrayList<Map<String, Object>>();
        for (Host host : this._hosts.values()) {
            hostList.add(host.getJsonStructure());
        }
        HashMap<String, Object> rackMap = new HashMap<String, Object>();
        rackMap.put("rackid", this._id);
        rackMap.put("hosts", hostList);
        return rackMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        String rack = String.format("<Rack id=\"%s\">%n", this._id);
        out.write(rack.getBytes(StandardCharsets.UTF_8));
        for (Host host : this._hosts.values()) {
            host.writeTo(out);
        }
        out.write("</Rack>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return "Rack{_id=\"" + this._id + "\", _hosts=" + this._hosts.size() + ", _brokers=" + this._brokers.size() + ", _load=" + this._load + "}";
    }
}

