/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Rack;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class Partition
implements Serializable {
    private final TopicPartition _tp;
    private final List<Replica> _replicas;
    private Replica _leader;
    private final Set<Broker> _ineligibleBrokers;

    Partition(TopicPartition tp) {
        this._tp = tp;
        this._replicas = new ArrayList<Replica>();
        this._leader = null;
        this._ineligibleBrokers = new HashSet<Broker>();
    }

    public TopicPartition topicPartition() {
        return this._tp;
    }

    void addFollower(Replica follower, int index) {
        if (follower.isLeader()) {
            throw new IllegalArgumentException("Inconsistent leadership information. Trying to add follower replica " + follower + " while it is a leader.");
        }
        if (!follower.topicPartition().equals((Object)this._tp)) {
            throw new IllegalArgumentException("Inconsistent topic partition. Trying to add follower replica " + follower + " to partition " + this._tp + ".");
        }
        this._replicas.add(index, follower);
    }

    void deleteReplica(int brokerId) {
        this._replicas.removeIf(r -> r.broker().id() == brokerId);
    }

    public List<Replica> replicas() {
        return Collections.unmodifiableList(this._replicas);
    }

    public List<Replica> followers() {
        ArrayList<Replica> followers = new ArrayList<Replica>();
        this._replicas.forEach(r -> {
            if (!r.isLeader()) {
                followers.add((Replica)r);
            }
        });
        return followers;
    }

    public List<Replica> onlineFollowers() {
        ArrayList<Replica> onlineFollowers = new ArrayList<Replica>();
        for (Replica follower : this.followers()) {
            if (follower.isCurrentOffline()) continue;
            onlineFollowers.add(follower);
        }
        return onlineFollowers;
    }

    public Replica leader() {
        return this._leader;
    }

    Replica replica(long brokerId) {
        for (Replica replica : this._replicas) {
            if ((long)replica.broker().id() != brokerId) continue;
            return replica;
        }
        throw new IllegalArgumentException("Requested replica " + brokerId + " is not a replica of partition " + this._tp);
    }

    public List<Broker> followerBrokers() {
        ArrayList<Broker> followerBrokers = new ArrayList<Broker>();
        this._replicas.forEach(r -> {
            if (!r.isLeader()) {
                followerBrokers.add(r.broker());
            }
        });
        return followerBrokers;
    }

    public List<Broker> onlineFollowerBrokers() {
        ArrayList<Broker> onlineFollowerBrokers = new ArrayList<Broker>();
        this._replicas.forEach(r -> {
            if (!r.isLeader() && !r.isCurrentOffline()) {
                onlineFollowerBrokers.add(r.broker());
            }
        });
        return onlineFollowerBrokers;
    }

    public void swapFollowerPositions(int index1, int index2) {
        Replica follower1 = this._replicas.get(index1);
        Replica follower2 = this._replicas.get(index2);
        if (follower1.isLeader() || follower2.isLeader()) {
            throw new IllegalArgumentException(String.format("%s is not a follower.", follower1.isLeader() ? follower1 : follower2));
        }
        this._replicas.set(index2, follower1);
        this._replicas.set(index1, follower2);
    }

    public void swapReplicaPositions(int index1, int index2) {
        Replica replica1 = this._replicas.get(index1);
        Replica replica2 = this._replicas.get(index2);
        this._replicas.set(index2, replica1);
        this._replicas.set(index1, replica2);
    }

    public void moveReplicaToEnd(Replica replica) {
        if (!this._replicas.remove(replica)) {
            throw new IllegalStateException(String.format("Did not find replica %s for partition %s.", replica, this._tp));
        }
        this._replicas.add(replica);
    }

    public Set<Broker> partitionBrokers() {
        HashSet<Broker> partitionBrokers = new HashSet<Broker>(this._replicas.size());
        this._replicas.forEach(r -> partitionBrokers.add(r.broker()));
        return partitionBrokers;
    }

    public Set<Rack> partitionRacks() {
        HashSet<Rack> partitionRacks = new HashSet<Rack>(this._replicas.size());
        this._replicas.forEach(r -> partitionRacks.add(r.broker().rack()));
        return partitionRacks;
    }

    void addLeader(Replica leader, int index) {
        if (this._leader != null) {
            throw new IllegalArgumentException(String.format("Partition %s already has a leader replica %s. Cannot add a new leader replica %s", this._tp, this._leader, leader));
        }
        if (!leader.isLeader()) {
            throw new IllegalArgumentException("Inconsistent leadership information. Trying to set " + leader.broker() + " as the leader for partition " + this._tp + " while the replica is not marked as a leader.");
        }
        this._leader = leader;
        this._replicas.add(index, leader);
    }

    void relocateLeadership(Replica prospectiveLeader) {
        int leaderPos = this._replicas.indexOf(prospectiveLeader);
        this.swapReplicaPositions(0, leaderPos);
        this._leader = prospectiveLeader;
    }

    public void clear() {
        this._replicas.clear();
        this._leader = null;
    }

    public String toString() {
        StringBuilder partition = new StringBuilder().append(String.format("<Partition>%n<Leader>%s</Leader>%n", this._leader));
        for (Replica replica : this._replicas) {
            if (replica.isLeader()) continue;
            partition.append(String.format("<Follower>%s</Follower>%n", replica));
        }
        return partition.append("</Partition>%n").toString();
    }

    public void addIneligibleBroker(Broker ineligibleBroker) {
        this._ineligibleBrokers.add(ineligibleBroker);
    }

    public boolean canAssignReplicaToBroker(Broker candidateBroker) {
        return !this._ineligibleBrokers.contains(candidateBroker);
    }
}

