/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.LinearRegressionModelParameters;
import com.linkedin.kafka.cruisecontrol.model.ModelParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ModelUtils.class);
    public static final String BROKER_ID = "brokerid";
    public static final String BROKER_STATE = "brokerstate";
    public static final String REPLICAS = "replicas";
    public static final String IS_LEADER = "isLeader";
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String LOAD = "load";
    public static final String METRIC_VALUES = "MetricValues";
    public static final String NAME = "name";
    public static final String BROKERS = "brokers";
    public static final String RACK_ID = "rackid";
    public static final String HOSTS = "hosts";
    private static final double ALLOWED_METRIC_ERROR_FACTOR = 1.05;
    private static final int UNSTABLE_METRIC_THROUGHPUT_THRESHOLD = 10;
    private static boolean _useLinearRegressionModel = false;

    private ModelUtils() {
    }

    public static void init(KafkaCruiseControlConfig config) {
        _useLinearRegressionModel = config.getBoolean("use.linear.regression.model");
    }

    public static double getFollowerCpuUtilFromLeaderLoad(double leaderBytesInRate, double leaderBytesOutRate, double leaderCpuUtil) {
        if (_useLinearRegressionModel) {
            double followerBytesInCoefficient = ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.FOLLOWER_BYTES_IN);
            return followerBytesInCoefficient * leaderBytesInRate;
        }
        if (leaderBytesInRate == 0.0 && leaderBytesOutRate == 0.0) {
            return 0.0;
        }
        return leaderCpuUtil * (ModelParameters.CPU_WEIGHT_OF_FOLLOWER_BYTES_IN_RATE * leaderBytesInRate) / (ModelParameters.CPU_WEIGHT_OF_LEADER_BYTES_IN_RATE * leaderBytesInRate + ModelParameters.CPU_WEIGHT_OF_LEADER_BYTES_OUT_RATE * leaderBytesOutRate);
    }

    public static Double estimateLeaderCpuUtilPerCore(double brokerCpuUtil, double brokerLeaderBytesInRate, double brokerLeaderBytesOutRate, double brokerFollowerBytesInRate, double partitionBytesInRate, double partitionBytesOutRate) {
        if (_useLinearRegressionModel) {
            return ModelUtils.estimateLeaderCpuUtilUsingLinearRegressionModel(partitionBytesInRate, partitionBytesOutRate);
        }
        if (brokerLeaderBytesInRate == 0.0 || brokerLeaderBytesOutRate == 0.0) {
            return 0.0;
        }
        if (brokerLeaderBytesInRate * 1.05 < partitionBytesInRate && brokerLeaderBytesInRate > 10.0) {
            LOG.error("Partition bytes in rate {} is greater than broker bytes in rate {}.", (Object)partitionBytesInRate, (Object)brokerLeaderBytesInRate);
            return null;
        }
        if (brokerLeaderBytesOutRate * 1.05 < partitionBytesOutRate && brokerLeaderBytesOutRate > 10.0) {
            LOG.error("Partition bytes out rate {} is greater than broker bytes out rate {}.", (Object)partitionBytesOutRate, (Object)brokerLeaderBytesOutRate);
            return null;
        }
        double brokerLeaderBytesInContribution = ModelParameters.CPU_WEIGHT_OF_LEADER_BYTES_IN_RATE * brokerLeaderBytesInRate;
        double brokerLeaderBytesOutContribution = ModelParameters.CPU_WEIGHT_OF_LEADER_BYTES_OUT_RATE * brokerLeaderBytesOutRate;
        double brokerFollowerBytesInContribution = ModelParameters.CPU_WEIGHT_OF_FOLLOWER_BYTES_IN_RATE * brokerFollowerBytesInRate;
        double totalContribution = brokerLeaderBytesInContribution + brokerLeaderBytesOutContribution + brokerFollowerBytesInContribution;
        double leaderReplicaContribution = brokerLeaderBytesInContribution * Math.min(1.0, partitionBytesInRate / brokerLeaderBytesInRate) + brokerLeaderBytesOutContribution * Math.min(1.0, partitionBytesOutRate / brokerLeaderBytesOutRate);
        return leaderReplicaContribution / totalContribution * brokerCpuUtil;
    }

    public static double estimateLeaderCpuUtilUsingLinearRegressionModel(double leaderBytesInRate, double leaderBytesOutRate) {
        double leaderBytesInCoefficient = ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_IN);
        double leaderBytesOutCoefficient = ModelParameters.getCoefficient(LinearRegressionModelParameters.ModelCoefficient.LEADER_BYTES_OUT);
        return leaderBytesInCoefficient * leaderBytesInRate + leaderBytesOutCoefficient * leaderBytesOutRate;
    }
}

