/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.LinearRegressionModelParameters;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerMetricSample;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.kafka.common.record.CompressionType;

public class ModelParameters {
    private static final LinearRegressionModelParameters LINEAR_REGRESSION_PARAMETERS = new LinearRegressionModelParameters();
    static double CPU_WEIGHT_OF_LEADER_BYTES_IN_RATE = 0.7;
    static double CPU_WEIGHT_OF_LEADER_BYTES_OUT_RATE = 0.15;
    static double CPU_WEIGHT_OF_FOLLOWER_BYTES_IN_RATE = 0.15;

    private ModelParameters() {
    }

    public static void init(KafkaCruiseControlConfig config) {
        CPU_WEIGHT_OF_LEADER_BYTES_IN_RATE = config.getDouble("leader.network.inbound.weight.for.cpu.util");
        CPU_WEIGHT_OF_LEADER_BYTES_OUT_RATE = config.getDouble("leader.network.outbound.weight.for.cpu.util");
        CPU_WEIGHT_OF_FOLLOWER_BYTES_IN_RATE = config.getDouble("follower.network.inbound.weight.for.cpu.util");
        LinearRegressionModelParameters.init(config);
    }

    public static Double getCoefficient(LinearRegressionModelParameters.ModelCoefficient name) {
        return LINEAR_REGRESSION_PARAMETERS.getCoefficient(name);
    }

    public static boolean trainingCompleted() {
        return LINEAR_REGRESSION_PARAMETERS.trainingCompleted();
    }

    public static double modelCoefficientTrainingCompleteness() {
        return LINEAR_REGRESSION_PARAMETERS.modelCoefficientTrainingCompleteness();
    }

    public static boolean updateModelCoefficient() {
        return LINEAR_REGRESSION_PARAMETERS.updateModelCoefficient();
    }

    public static void addMetricObservation(Collection<BrokerMetricSample> trainingData) {
        LINEAR_REGRESSION_PARAMETERS.addMetricObservation(trainingData);
    }

    @Nonnull
    public static LinearRegressionModelParameters.LinearRegressionModelState linearRegressionModelState() {
        return LINEAR_REGRESSION_PARAMETERS.modelState();
    }

    private static ConfigSetting forSetting(CompressionType type, boolean sslEnabled) {
        switch (type) {
            case NONE: {
                return sslEnabled ? ConfigSetting.SSL_NONE : ConfigSetting.PLAINTEXT_NONE;
            }
            case GZIP: {
                return sslEnabled ? ConfigSetting.SSL_GZIP : ConfigSetting.PLAINTEXT_GZIP;
            }
            case SNAPPY: {
                return sslEnabled ? ConfigSetting.SSL_SNAPPY : ConfigSetting.PLAINTEXT_SNAPPY;
            }
            case LZ4: {
                return sslEnabled ? ConfigSetting.SSL_LZ4 : ConfigSetting.PLAINTEXT_LZ4;
            }
        }
        throw new IllegalStateException("Should not be here.");
    }

    public static enum ConfigSetting {
        CURRENT_CLUSTER,
        PLAINTEXT_NONE,
        PLAINTEXT_GZIP,
        PLAINTEXT_SNAPPY,
        PLAINTEXT_LZ4,
        SSL_NONE,
        SSL_GZIP,
        SSL_SNAPPY,
        SSL_LZ4;

    }
}

