/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Load
implements Serializable {
    private List<Long> _windows = null;
    private final AggregatedMetricValues _metricValues = new AggregatedMetricValues();

    public AggregatedMetricValues loadByWindows() {
        return this._metricValues;
    }

    public int numWindows() {
        return this._metricValues.length();
    }

    public List<Long> windows() {
        return this._windows;
    }

    public double expectedUtilizationFor(Resource resource, boolean wantMaxLoad, boolean wantAvgLoad) {
        if (wantMaxLoad && wantAvgLoad) {
            throw new IllegalArgumentException("Attempt to request expected utilization with both max and avg load.");
        }
        if (this._metricValues.isEmpty()) {
            return 0.0;
        }
        double result = 0.0;
        for (MetricInfo info : KafkaMetricDef.resourceToMetricInfo(resource)) {
            MetricValues valuesForId = this._metricValues.valuesFor(info.id());
            result += wantMaxLoad ? (double)valuesForId.max() : (double)(resource == Resource.DISK && !wantAvgLoad ? valuesForId.latest() : valuesForId.avg());
        }
        return Math.max(result, 0.0);
    }

    public double expectedUtilizationFor(Resource resource) {
        return Load.expectedUtilizationFor(resource, this._metricValues, false);
    }

    public double expectedUtilizationFor(KafkaMetricDef metric, boolean wantMaxLoad, boolean wantAvgLoad) {
        MetricInfo info;
        if (wantMaxLoad && wantAvgLoad) {
            throw new IllegalArgumentException("Attempt to request expected utilization with both max and avg load.");
        }
        switch (metric.defScope()) {
            case COMMON: {
                info = KafkaMetricDef.commonMetricDef().metricInfo(metric.name());
                break;
            }
            case BROKER_ONLY: {
                info = KafkaMetricDef.brokerMetricDef().metricInfo(metric.name());
                break;
            }
            default: {
                throw new IllegalArgumentException("Metric scope " + metric.defScope() + " for metric " + metric.name() + " is invalid.");
            }
        }
        if (this._metricValues.isEmpty()) {
            return 0.0;
        }
        MetricValues valuesForId = this._metricValues.valuesFor(info.id());
        if (wantMaxLoad) {
            return Math.max((double)valuesForId.max(), 0.0);
        }
        if (wantAvgLoad) {
            return Math.max((double)valuesForId.avg(), 0.0);
        }
        switch (metric.valueComputingStrategy()) {
            case MAX: {
                return Math.max((double)valuesForId.max(), 0.0);
            }
            case AVG: {
                return Math.max((double)valuesForId.avg(), 0.0);
            }
            case LATEST: {
                return Math.max((double)valuesForId.latest(), 0.0);
            }
        }
        throw new IllegalArgumentException("Metric value computing strategy " + metric.valueComputingStrategy() + " for metric " + metric.name() + " is invalid.");
    }

    boolean isEmpty() {
        return this._metricValues.isEmpty();
    }

    void setLoad(AggregatedMetricValues loadToSet) {
        if (loadToSet.length() != this._metricValues.length()) {
            throw new IllegalArgumentException("Load to set and load for the resources must have exactly " + this._metricValues.length() + " entries.");
        }
        loadToSet.metricIds().forEach(id -> {
            MetricValues valuesToSet = loadToSet.valuesFor(id.shortValue());
            MetricValues values = this._metricValues.valuesFor(id.shortValue());
            for (int i = 0; i < values.length(); ++i) {
                values.set(i, (double)((float)valuesToSet.get(i)));
            }
        });
    }

    void setLoad(short metricId, MetricValues loadToSet) {
        if (loadToSet.length() != this._metricValues.length()) {
            throw new IllegalArgumentException("Load to set and load for the resources must have exactly " + this._metricValues.length() + " entries.");
        }
        MetricValues values = this._metricValues.valuesFor(metricId);
        for (int i = 0; i < loadToSet.length(); ++i) {
            values.set(i, (double)((float)loadToSet.get(i)));
        }
    }

    void clearLoadFor(Resource resource) {
        KafkaMetricDef.resourceToMetricIds(resource).forEach(id -> this._metricValues.valuesFor(id.shortValue()).clear());
    }

    void initializeMetricValues(AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        if (!this._metricValues.isEmpty()) {
            throw new IllegalStateException("Metric values already exists, cannot set it again.");
        }
        this._windows = windows;
        this._metricValues.add(aggregatedMetricValues);
    }

    void addMetricValues(AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        if (this._windows == null) {
            this._windows = windows;
        }
        this._metricValues.add(aggregatedMetricValues);
    }

    void addLoad(Load loadToAdd) {
        this._metricValues.add(loadToAdd.loadByWindows());
    }

    void subtractLoad(Load loadToSubtract) {
        this._metricValues.subtract(loadToSubtract.loadByWindows());
    }

    void addLoad(AggregatedMetricValues loadToAdd) {
        if (!this._metricValues.isEmpty()) {
            this._metricValues.add(loadToAdd);
        }
    }

    void subtractLoad(AggregatedMetricValues loadToSubtract) {
        if (!this._metricValues.isEmpty()) {
            this._metricValues.subtract(loadToSubtract);
        }
    }

    void clearLoad() {
        this._metricValues.clear();
    }

    AggregatedMetricValues loadFor(Resource resource, boolean shareValueArray) {
        return this._metricValues.valuesFor(KafkaMetricDef.resourceToMetricIds(resource), shareValueArray);
    }

    public Map<String, Object> getJsonStructure() {
        MetricDef metricDef = KafkaMetricDef.commonMetricDef();
        HashMap<String, Object> loadMap = new HashMap<String, Object>();
        ArrayList metricValueList = new ArrayList();
        for (MetricInfo metricInfo : metricDef.all()) {
            MetricValues metricValues = this._metricValues.valuesFor(metricInfo.id());
            if (metricValues == null) continue;
            HashMap<Long, Double> metricValuesMap = new HashMap<Long, Double>();
            for (int i = 0; i < this._windows.size(); ++i) {
                metricValuesMap.put(this._windows.get(i), metricValues.get(i));
            }
            metricValueList.add(metricValuesMap);
        }
        loadMap.put("MetricValues", metricValueList);
        return loadMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write("<Load>".getBytes(StandardCharsets.UTF_8));
        this._metricValues.writeTo(out);
        out.write("</Load>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return String.format("Load[metricValues=%s]", this._metricValues);
    }

    public static double expectedUtilizationFor(Resource resource, AggregatedMetricValues aggregatedMetricValues, boolean ignoreMissingMetric) {
        if (aggregatedMetricValues.isEmpty()) {
            return 0.0;
        }
        double result = 0.0;
        for (MetricInfo info : KafkaMetricDef.resourceToMetricInfo(resource)) {
            MetricValues valuesForId = aggregatedMetricValues.valuesFor(info.id());
            if (!ignoreMissingMetric && valuesForId == null) {
                throw new IllegalArgumentException(String.format("The aggregated metric values does not contain metric %s for resource %s.", info, resource.name()));
            }
            if (valuesForId == null) continue;
            result += resource == Resource.DISK ? (double)valuesForId.latest() : (double)valuesForId.avg();
        }
        return Math.max(result, 0.0);
    }
}

