/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Rack;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class Host
implements Serializable {
    private static final double DEAD_HOST_CAPACITY = -1.0;
    private final Map<Integer, Broker> _brokers;
    private final Set<Replica> _replicas;
    private final Rack _rack;
    private final String _name;
    private final Load _load;
    private final double[] _hostCapacity;
    private int _aliveBrokers;

    Host(String name, Rack rack) {
        this._name = name;
        this._brokers = new HashMap<Integer, Broker>();
        this._replicas = new HashSet<Replica>();
        this._rack = rack;
        this._load = new Load();
        this._hostCapacity = new double[Resource.cachedValues().size()];
        this._aliveBrokers = 0;
    }

    public Rack rack() {
        return this._rack;
    }

    public Broker broker(int brokerId) {
        return this._brokers.get(brokerId);
    }

    public Collection<Broker> brokers() {
        return this._brokers.values();
    }

    public Set<Replica> replicas() {
        return this._replicas;
    }

    public int numTopicReplicas(String topic) {
        int numTopicReplicas = 0;
        for (Broker broker : this._brokers.values()) {
            numTopicReplicas += broker.numReplicasOfTopicInBroker(topic);
        }
        return numTopicReplicas;
    }

    public Set<String> topics() {
        HashSet<String> topics = new HashSet<String>();
        this._brokers.values().forEach(broker -> topics.addAll(broker.topics()));
        return topics;
    }

    public double capacityFor(Resource resource) {
        return this._aliveBrokers > 0 ? this._hostCapacity[resource.id()] : -1.0;
    }

    public boolean isAlive() {
        for (Broker broker : this._brokers.values()) {
            if (!broker.isAlive()) continue;
            return true;
        }
        return false;
    }

    public Load load() {
        return this._load;
    }

    double markDiskDead(int brokerId, String logdir) {
        Broker broker = this.broker(brokerId);
        double capacityLost = broker.markDiskDead(logdir);
        int n = Resource.DISK.id();
        this._hostCapacity[n] = this._hostCapacity[n] - capacityLost;
        return capacityLost;
    }

    public String name() {
        return this._name;
    }

    Broker createBroker(Integer brokerId, BrokerCapacityInfo brokerCapacityInfo, boolean populateReplicaPlacementInfo) {
        Broker broker = new Broker(this, brokerId, brokerCapacityInfo, populateReplicaPlacementInfo);
        this._brokers.put(brokerId, broker);
        ++this._aliveBrokers;
        for (Map.Entry<Resource, Double> entry : brokerCapacityInfo.capacity().entrySet()) {
            Resource resource = entry.getKey();
            int n = resource.id();
            this._hostCapacity[n] = this._hostCapacity[n] + (resource == Resource.CPU ? entry.getValue() * (double)brokerCapacityInfo.numCpuCores() : entry.getValue());
        }
        return broker;
    }

    void setBrokerState(int brokerId, Broker.State newState) {
        Broker broker = this.broker(brokerId);
        if (broker.isAlive() && newState == Broker.State.DEAD) {
            for (Resource r : Resource.cachedValues()) {
                int n = r.id();
                this._hostCapacity[n] = this._hostCapacity[n] - broker.capacityFor(r);
            }
            --this._aliveBrokers;
        } else if (!broker.isAlive() && newState != Broker.State.DEAD) {
            for (Resource r : Resource.cachedValues()) {
                int n = r.id();
                this._hostCapacity[n] = this._hostCapacity[n] + broker.capacityFor(r);
            }
            ++this._aliveBrokers;
        }
        broker.setState(newState);
    }

    void addReplica(Replica replica) {
        this._replicas.add(replica);
        this._brokers.get(replica.broker().id()).addReplica(replica);
        this._load.addLoad(replica.load());
    }

    Replica removeReplica(int brokerId, TopicPartition tp) {
        Broker broker = this._brokers.get(brokerId);
        if (broker == null) {
            throw new IllegalStateException(String.format("Cannot remove replica for %s from broker %s because it does not exist in host %s", tp, brokerId, this._name));
        }
        Replica replica = broker.removeReplica(tp);
        this._replicas.remove(replica);
        this._load.subtractLoad(replica.load());
        return replica;
    }

    AggregatedMetricValues makeFollower(int brokerId, TopicPartition tp) {
        Broker broker = this.broker(brokerId);
        if (broker == null) {
            throw new IllegalStateException(String.format("Cannot make replica %s on broker %d as follower because the broker does not exist in host %s", tp, brokerId, this._name));
        }
        AggregatedMetricValues leadershipLoadDelta = broker.makeFollower(tp);
        this._load.subtractLoad(leadershipLoadDelta);
        return leadershipLoadDelta;
    }

    void makeLeader(int brokerId, TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Broker broker = this._brokers.get(brokerId);
        broker.makeLeader(tp, leadershipLoadDelta);
        this._load.addLoad(leadershipLoadDelta);
    }

    void setReplicaLoad(int brokerId, TopicPartition tp, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        Broker broker = this._brokers.get(brokerId);
        broker.setReplicaLoad(tp, aggregatedMetricValues, windows);
        this._load.addMetricValues(aggregatedMetricValues, windows);
    }

    void clearLoad() {
        this._brokers.values().forEach(Broker::clearLoad);
        this._load.clearLoad();
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> hostMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> brokerList = new ArrayList<Map<String, Object>>();
        for (Broker broker : this._brokers.values()) {
            brokerList.add(broker.getJsonStructure());
        }
        hostMap.put("name", this._name);
        hostMap.put("brokers", brokerList);
        return hostMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        String host = String.format("<Host name=\"%s\">%n", this._name);
        out.write(host.getBytes(StandardCharsets.UTF_8));
        for (Broker broker : this._brokers.values()) {
            broker.writeTo(out);
        }
        out.write("</Host>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        StringBuilder host = new StringBuilder().append(String.format("<Host name=\"%s\">%n", this._name));
        for (Broker broker : this._brokers.values()) {
            host.append(broker.toString());
        }
        return host.append("</Host>%n").toString();
    }
}

