/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.Map;

@JsonResponseClass
public class DiskStats {
    private final int _numLeaderReplicas;
    private final int _numReplicas;
    private final Double _utilization;
    private final double _capacity;
    @JsonResponseField
    private static final String DISK_MB = "DiskMB";
    @JsonResponseField
    private static final String DISK_PCT = "DiskPct";
    @JsonResponseField
    private static final String NUM_LEADER_REPLICAS = "NumLeaderReplicas";
    @JsonResponseField
    private static final String NUM_REPLICAS = "NumReplicas";
    private static final String DEAD_STATE = "DEAD";

    DiskStats(int numLeaderReplicas, int numReplicas, double utilization, double capacity) {
        this._numLeaderReplicas = numLeaderReplicas;
        this._numReplicas = numReplicas;
        this._utilization = capacity > 0.0 ? Double.valueOf(utilization) : null;
        this._capacity = capacity;
    }

    public int numLeaderReplicas() {
        return this._numLeaderReplicas;
    }

    public int numReplicas() {
        return this._numReplicas;
    }

    public Double utilization() {
        return this._utilization;
    }

    public double capacity() {
        return this._capacity;
    }

    public Double utilizationPercentage() {
        return this._utilization == null ? null : Double.valueOf(this._utilization * 100.0 / this._capacity);
    }

    public Map<String, Object> getJSONStructure() {
        HashMap<String, Object> entry = new HashMap<String, Object>(4);
        entry.put(DISK_MB, this._utilization == null ? DEAD_STATE : this._utilization);
        entry.put(DISK_PCT, this._utilization == null ? DEAD_STATE : this.utilizationPercentage());
        entry.put(NUM_LEADER_REPLICAS, this._numLeaderReplicas);
        entry.put(NUM_REPLICAS, this._numReplicas);
        return entry;
    }
}

