/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.DiskStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.SortedReplicas;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Disk
implements Comparable<Disk> {
    private static final double DEAD_DISK_CAPACITY = -1.0;
    private final String _logDir;
    private double _capacity;
    private final Set<Replica> _replicas;
    private State _state;
    private final Broker _broker;
    private double _utilization;
    private final Map<String, SortedReplicas> _sortedReplicas;

    Disk(String logDir, Broker broker, double diskCapacity) {
        this._logDir = logDir;
        this._broker = broker;
        this._replicas = new HashSet<Replica>();
        this._utilization = 0.0;
        this._sortedReplicas = new HashMap<String, SortedReplicas>();
        if (diskCapacity < 0.0) {
            this._capacity = -1.0;
            this._state = State.DEAD;
        } else {
            this._capacity = diskCapacity;
            this._state = State.ALIVE;
        }
    }

    public String logDir() {
        return this._logDir;
    }

    public double capacity() {
        return this._capacity;
    }

    public State state() {
        return this._state;
    }

    public boolean isAlive() {
        return this._state == State.ALIVE;
    }

    public Set<Replica> replicas() {
        return Collections.unmodifiableSet(this._replicas);
    }

    public Set<Replica> leaderReplicas() {
        return Collections.unmodifiableSet(this._replicas.stream().filter(Replica::isLeader).collect(Collectors.toSet()));
    }

    public Broker broker() {
        return this._broker;
    }

    public double utilization() {
        return this._utilization;
    }

    public void setState(State newState) {
        this._state = newState;
        if (this._state == State.DEAD) {
            this._capacity = -1.0;
        }
    }

    void addReplica(Replica replica) {
        if (this._replicas.contains(replica)) {
            throw new IllegalStateException(String.format("Disk %s already has replica %s", this._logDir, replica.topicPartition()));
        }
        this._utilization += replica.load().expectedUtilizationFor(Resource.DISK);
        this._replicas.add(replica);
        replica.setDisk(this);
        this._sortedReplicas.values().forEach(sr -> sr.add(replica));
    }

    void addReplicaLoad(Replica replica) {
        this._utilization += replica.load().expectedUtilizationFor(Resource.DISK);
    }

    void removeReplica(Replica replica) {
        if (!this._replicas.contains(replica)) {
            throw new IllegalStateException(String.format("Disk %s does not has replica %s", this._logDir, replica.topicPartition()));
        }
        this._utilization -= replica.load().expectedUtilizationFor(Resource.DISK);
        this._replicas.remove(replica);
        this._sortedReplicas.values().forEach(sr -> sr.remove(replica));
    }

    void trackSortedReplicas(String sortName, Set<Function<Replica, Boolean>> selectionFuncs, List<Function<Replica, Integer>> priorityFuncs, Function<Replica, Double> scoreFunc) {
        this._sortedReplicas.putIfAbsent(sortName, new SortedReplicas(this._broker, this, selectionFuncs, priorityFuncs, scoreFunc, true));
    }

    public void untrackSortedReplicas(String sortName) {
        this._sortedReplicas.remove(sortName);
    }

    public void clearSortedReplicas() {
        this._sortedReplicas.clear();
    }

    public SortedReplicas trackedSortedReplicas(String sortName) {
        SortedReplicas sortedReplicas = this._sortedReplicas.get(sortName);
        if (sortedReplicas == null) {
            throw new IllegalStateException("The sort name " + sortName + "  is not found. Make sure trackSortedReplicas() has been called for the sort name");
        }
        return sortedReplicas;
    }

    @Override
    public int compareTo(Disk d) {
        int result = this._broker.compareTo(d.broker());
        if (result == 0) {
            return this._logDir.compareTo(d.logDir());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Disk)) {
            return false;
        }
        return this.compareTo((Disk)o) == 0;
    }

    public int hashCode() {
        return Objects.hash(this._broker, this._logDir);
    }

    public void writeTo(OutputStream out) throws IOException {
        String disk = String.format("<Disk logdir=\"%s\" state=\"%s\">%n", new Object[]{this._logDir, this._state});
        out.write(disk.getBytes(StandardCharsets.UTF_8));
        for (Replica replica : this._replicas) {
            replica.writeTo(out);
        }
        out.write("</Disk>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return String.format("Disk[logdir=%s,state=%s,capacity=%f,replicaCount=%d]", new Object[]{this._logDir, this._state, this._capacity, this._replicas.size()});
    }

    public DiskStats diskStats() {
        return new DiskStats((int)this._replicas.stream().filter(Replica::isLeader).count(), this._replicas.size(), this._utilization, this._capacity);
    }

    public static enum State {
        ALIVE,
        DEAD,
        DEMOTED;

    }
}

