/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseExternalFields;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonResponseClass
@JsonResponseExternalFields(value=Resource.class)
public class ClusterModelStatsValueHolder {
    @JsonResponseField
    protected static final String POTENTIAL_NW_OUT = "potentialNwOut";
    @JsonResponseField
    protected static final String LEADER_REPLICAS = "leaderReplicas";
    @JsonResponseField
    protected static final String TOPIC_REPLICAS = "topicReplicas";
    @JsonResponseField
    protected static final String REPLICAS = "replicas";
    protected final Map<Resource, Double> _resourceUtilizationStats;
    protected final Double _potentialNwOutUtilizationStats;
    protected final Number _replicaStats;
    protected final Number _leaderReplicaStats;
    protected final Number _topicReplicaStats;

    public ClusterModelStatsValueHolder(Map<Resource, Double> resourceUtilizationStats, Double potentialNwOutUtilizationStats, Number replicaStats, Number leaderReplicaStats, Number topicReplicaStats) {
        this._resourceUtilizationStats = resourceUtilizationStats;
        this._potentialNwOutUtilizationStats = potentialNwOutUtilizationStats;
        this._replicaStats = replicaStats;
        this._leaderReplicaStats = leaderReplicaStats;
        this._topicReplicaStats = topicReplicaStats;
    }

    protected Map<String, Object> getJsonStructure() {
        List<Resource> cachedResources = Resource.cachedValues();
        HashMap<String, Object> resourceMap = new HashMap<String, Object>(cachedResources.size() + 4);
        for (Resource resource : cachedResources) {
            resourceMap.put(resource.resource(), this._resourceUtilizationStats.get((Object)resource));
        }
        resourceMap.put(POTENTIAL_NW_OUT, this._potentialNwOutUtilizationStats);
        resourceMap.put(REPLICAS, this._replicaStats);
        resourceMap.put(LEADER_REPLICAS, this._leaderReplicaStats);
        resourceMap.put(TOPIC_REPLICAS, this._topicReplicaStats);
        return resourceMap;
    }

    public String toString() {
        return String.format("%s:%12.3f %s:%s %s:%s %s:%s}%n", POTENTIAL_NW_OUT, this._potentialNwOutUtilizationStats, REPLICAS, this._replicaStats, LEADER_REPLICAS, this._leaderReplicaStats, TOPIC_REPLICAS, this._topicReplicaStats);
    }
}

