/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStatsValueHolder;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseExternalFields;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonResponseClass
@JsonResponseExternalFields(value=Statistic.class)
public class ClusterModelStatsValue {
    protected final Map<Statistic, Map<Resource, Double>> _resourceUtilizationStats;
    protected final Map<Statistic, Double> _potentialNwOutUtilizationStats;
    protected final Map<Statistic, Number> _replicaStats;
    protected final Map<Statistic, Number> _leaderReplicaStats;
    protected final Map<Statistic, Number> _topicReplicaStats;

    public ClusterModelStatsValue(Map<Statistic, Map<Resource, Double>> resourceUtilizationStats, Map<Statistic, Double> potentialNwOutUtilizationStats, Map<Statistic, Number> replicaStats, Map<Statistic, Number> leaderReplicaStats, Map<Statistic, Number> topicReplicaStats) {
        this._resourceUtilizationStats = resourceUtilizationStats;
        this._potentialNwOutUtilizationStats = potentialNwOutUtilizationStats;
        this._replicaStats = replicaStats;
        this._leaderReplicaStats = leaderReplicaStats;
        this._topicReplicaStats = topicReplicaStats;
    }

    protected Map<String, Object> getJsonStructure() {
        List<Statistic> cachedStatistic = Statistic.cachedValues();
        HashMap<String, Object> allStatMap = new HashMap<String, Object>(cachedStatistic.size());
        for (Statistic stat : cachedStatistic) {
            allStatMap.put(stat.stat(), new ClusterModelStatsValueHolder(this._resourceUtilizationStats.get((Object)stat), this._potentialNwOutUtilizationStats.get((Object)stat), this._replicaStats.get((Object)stat), this._leaderReplicaStats.get((Object)stat), this._topicReplicaStats.get((Object)stat)).getJsonStructure());
        }
        return allStatMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Statistic stat : Statistic.cachedValues()) {
            sb.append(String.format("%s:{", new Object[]{stat}));
            for (Resource resource : Resource.cachedValues()) {
                sb.append(String.format("%s:%12.3f ", new Object[]{resource, this._resourceUtilizationStats.get((Object)stat).get((Object)resource)}));
            }
            sb.append(new ClusterModelStatsValueHolder(this._resourceUtilizationStats.get((Object)stat), this._potentialNwOutUtilizationStats.get((Object)stat), this._replicaStats.get((Object)stat), this._leaderReplicaStats.get((Object)stat), this._topicReplicaStats.get((Object)stat)).toString());
        }
        return sb.substring(0, sb.length() - 2);
    }
}

