/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.google.gson.Gson;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStatsMetaData;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStatsValue;
import com.linkedin.kafka.cruisecontrol.model.Disk;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;

@JsonResponseClass
public class ClusterModelStats {
    @JsonResponseField
    private static final String METADATA = "metadata";
    @JsonResponseField
    private static final String STATISTICS = "statistics";
    private final Map<Statistic, Map<Resource, Double>> _resourceUtilizationStats = new HashMap<Statistic, Map<Resource, Double>>();
    private final Map<Statistic, Double> _potentialNwOutUtilizationStats = new HashMap<Statistic, Double>();
    private final Map<Statistic, Number> _replicaStats = new HashMap<Statistic, Number>();
    private final Map<Statistic, Number> _leaderReplicaStats = new HashMap<Statistic, Number>();
    private final Map<Statistic, Number> _topicReplicaStats = new HashMap<Statistic, Number>();
    private int _numBrokers = 0;
    private int _numAliveBrokers;
    private int _numReplicasInCluster = 0;
    private int _numPartitionsWithOfflineReplicas = 0;
    private int _numTopics = 0;
    private Map<Resource, Integer> _numBalancedBrokersByResource = new HashMap<Resource, Integer>();
    private int _numBrokersUnderPotentialNwOut = 0;
    private BalancingConstraint _balancingConstraint;
    private double[][] _utilizationMatrix;
    private int _numSnapshotWindows;
    private double _monitoredPartitionsRatio;
    private int _numUnbalancedDisks = 0;
    private double _diskUtilizationStDev = 0.0;

    ClusterModelStats() {
    }

    ClusterModelStats populate(ClusterModel clusterModel, BalancingConstraint balancingConstraint) {
        this._numBrokers = clusterModel.brokers().size();
        this._numAliveBrokers = clusterModel.aliveBrokers().size();
        this._numTopics = clusterModel.topics().size();
        this._balancingConstraint = balancingConstraint;
        this.utilizationForResources(clusterModel);
        this.utilizationForPotentialNwOut(clusterModel);
        this.numForReplicas(clusterModel);
        this.numForLeaderReplicas(clusterModel);
        this.numForAvgTopicReplicas(clusterModel);
        this._utilizationMatrix = clusterModel.utilizationMatrix();
        this._numSnapshotWindows = clusterModel.load().numWindows();
        this._monitoredPartitionsRatio = clusterModel.monitoredPartitionsRatio();
        this.populateStatsForDisks(clusterModel, balancingConstraint);
        return this;
    }

    public Map<Statistic, Map<Resource, Double>> resourceUtilizationStats() {
        return this._resourceUtilizationStats;
    }

    public Map<Statistic, Double> potentialNwOutUtilizationStats() {
        return this._potentialNwOutUtilizationStats;
    }

    public Map<Statistic, Number> replicaStats() {
        return this._replicaStats;
    }

    public Map<Statistic, Number> leaderReplicaStats() {
        return this._leaderReplicaStats;
    }

    public Map<Statistic, Number> topicReplicaStats() {
        return this._topicReplicaStats;
    }

    public int numBrokers() {
        return this._numBrokers;
    }

    public int numReplicasInCluster() {
        return this._numReplicasInCluster;
    }

    public int numPartitionsWithOfflineReplicas() {
        return this._numPartitionsWithOfflineReplicas;
    }

    public int numTopics() {
        return this._numTopics;
    }

    public Map<Resource, Integer> numBalancedBrokersByResource() {
        return this._numBalancedBrokersByResource;
    }

    public int numBrokersUnderPotentialNwOut() {
        return this._numBrokersUnderPotentialNwOut;
    }

    public double[][] utilizationMatrix() {
        return this._utilizationMatrix;
    }

    public double monitoredPartitionsPercentage() {
        return this._monitoredPartitionsRatio * 100.0;
    }

    public int numWindows() {
        return this._numSnapshotWindows;
    }

    public int numUnbalancedDisks() {
        return this._numUnbalancedDisks;
    }

    public double diskUtilizationStandardDeviation() {
        return this._diskUtilizationStDev;
    }

    public String getJSONString() {
        Gson gson = new Gson();
        return gson.toJson(this.getJsonStructure());
    }

    public Map<String, Object> getJsonStructure() {
        HashMap<String, Object> statMap = new HashMap<String, Object>(2);
        statMap.put(METADATA, new ClusterModelStatsMetaData(this.numBrokers(), this.numReplicasInCluster(), this.numTopics()).getJsonStructure());
        statMap.put(STATISTICS, new ClusterModelStatsValue(this._resourceUtilizationStats, this._potentialNwOutUtilizationStats, this._replicaStats, this._leaderReplicaStats, this._topicReplicaStats).getJsonStructure());
        return statMap;
    }

    public String toStringCounts() {
        return String.format("%d brokers %d replicas %d topics.", this.numBrokers(), this.numReplicasInCluster(), this.numTopics());
    }

    public String toString() {
        return new ClusterModelStatsValue(this._resourceUtilizationStats, this._potentialNwOutUtilizationStats, this._replicaStats, this._leaderReplicaStats, this._topicReplicaStats).toString();
    }

    private void utilizationForResources(ClusterModel clusterModel) {
        HashMap<Resource, Double> avgUtilizationByResource = new HashMap<Resource, Double>();
        HashMap<Resource, Double> maxUtilizationByResource = new HashMap<Resource, Double>();
        HashMap<Resource, Double> minUtilizationByResource = new HashMap<Resource, Double>();
        HashMap<Resource, Double> stDevUtilizationByResource = new HashMap<Resource, Double>();
        for (Resource resource : Resource.cachedValues()) {
            double avgUtilizationPercentage = clusterModel.load().expectedUtilizationFor(resource) / clusterModel.capacityFor(resource);
            double balanceUpperThreshold = avgUtilizationPercentage * this._balancingConstraint.resourceBalancePercentage(resource);
            double balanceLowerThreshold = avgUtilizationPercentage * Math.max(0.0, 2.0 - this._balancingConstraint.resourceBalancePercentage(resource));
            double hottestBrokerUtilization = 0.0;
            double coldestBrokerUtilization = Double.MAX_VALUE;
            double varianceSum = 0.0;
            int numBalancedBrokers = 0;
            for (Broker broker : clusterModel.aliveBrokers()) {
                double capacity;
                double utilization = resource.isHostResource() ? broker.host().load().expectedUtilizationFor(resource) : broker.load().expectedUtilizationFor(resource);
                double utilizationPercentage = utilization / (capacity = resource.isHostResource() ? broker.host().capacityFor(resource) : broker.capacityFor(resource));
                if (utilizationPercentage >= balanceLowerThreshold && utilizationPercentage <= balanceUpperThreshold) {
                    ++numBalancedBrokers;
                }
                hottestBrokerUtilization = Math.max(hottestBrokerUtilization, utilization);
                coldestBrokerUtilization = Math.min(coldestBrokerUtilization, utilization);
                varianceSum += Math.pow(utilization - avgUtilizationPercentage * capacity, 2.0);
            }
            this._numBalancedBrokersByResource.put(resource, numBalancedBrokers);
            avgUtilizationByResource.put(resource, clusterModel.load().expectedUtilizationFor(resource) / (double)this._numAliveBrokers);
            maxUtilizationByResource.put(resource, hottestBrokerUtilization);
            minUtilizationByResource.put(resource, coldestBrokerUtilization);
            stDevUtilizationByResource.put(resource, Math.sqrt(varianceSum / (double)this._numAliveBrokers));
        }
        this._resourceUtilizationStats.put(Statistic.AVG, avgUtilizationByResource);
        this._resourceUtilizationStats.put(Statistic.MAX, maxUtilizationByResource);
        this._resourceUtilizationStats.put(Statistic.MIN, minUtilizationByResource);
        this._resourceUtilizationStats.put(Statistic.ST_DEV, stDevUtilizationByResource);
    }

    private void utilizationForPotentialNwOut(ClusterModel clusterModel) {
        double maxPotentialNwOut = 0.0;
        double minPotentialNwOut = Double.MAX_VALUE;
        double varianceSum = 0.0;
        double potentialNwOutInCluster = clusterModel.aliveBrokers().stream().mapToDouble(b -> clusterModel.potentialLeadershipLoadFor(b.id()).expectedUtilizationFor(Resource.NW_OUT)).sum();
        double avgPotentialNwOutUtilizationPct = potentialNwOutInCluster / clusterModel.capacityFor(Resource.NW_OUT);
        double capacityThreshold = this._balancingConstraint.capacityThreshold(Resource.NW_OUT);
        for (Broker broker : clusterModel.aliveBrokers()) {
            double brokerCapacity;
            double brokerUtilization = clusterModel.potentialLeadershipLoadFor(broker.id()).expectedUtilizationFor(Resource.NW_OUT);
            if (brokerUtilization / (brokerCapacity = broker.capacityFor(Resource.NW_OUT)) <= capacityThreshold) {
                ++this._numBrokersUnderPotentialNwOut;
            }
            maxPotentialNwOut = Math.max(maxPotentialNwOut, brokerUtilization);
            minPotentialNwOut = Math.min(minPotentialNwOut, brokerUtilization);
            varianceSum += Math.pow(brokerUtilization - avgPotentialNwOutUtilizationPct * brokerCapacity, 2.0);
        }
        this._potentialNwOutUtilizationStats.put(Statistic.AVG, potentialNwOutInCluster / (double)this._numAliveBrokers);
        this._potentialNwOutUtilizationStats.put(Statistic.MAX, maxPotentialNwOut);
        this._potentialNwOutUtilizationStats.put(Statistic.MIN, minPotentialNwOut);
        this._potentialNwOutUtilizationStats.put(Statistic.ST_DEV, Math.sqrt(varianceSum / (double)this._numAliveBrokers));
    }

    private void numForReplicas(ClusterModel clusterModel) {
        this.populateReplicaStats(clusterModel, broker -> broker.replicas().size(), this._replicaStats);
        this._numReplicasInCluster = clusterModel.numReplicas();
        HashSet<TopicPartition> partitionsWithOfflineReplicas = new HashSet<TopicPartition>();
        for (Replica replica : clusterModel.selfHealingEligibleReplicas()) {
            partitionsWithOfflineReplicas.add(replica.topicPartition());
        }
        this._numPartitionsWithOfflineReplicas = partitionsWithOfflineReplicas.size();
    }

    private void numForLeaderReplicas(ClusterModel clusterModel) {
        this.populateReplicaStats(clusterModel, broker -> broker.leaderReplicas().size(), this._leaderReplicaStats);
    }

    private void populateReplicaStats(ClusterModel clusterModel, Function<Broker, Integer> numInterestedReplicasFunc, Map<Statistic, Number> interestedReplicaStats) {
        int maxInterestedReplicasInBroker = 0;
        int minInterestedReplicasInBroker = Integer.MAX_VALUE;
        int numInterestedReplicasInCluster = 0;
        for (Broker broker : clusterModel.brokers()) {
            int numInterestedReplicasInBroker = numInterestedReplicasFunc.apply(broker);
            numInterestedReplicasInCluster += numInterestedReplicasInBroker;
            maxInterestedReplicasInBroker = Math.max(maxInterestedReplicasInBroker, numInterestedReplicasInBroker);
            minInterestedReplicasInBroker = Math.min(minInterestedReplicasInBroker, numInterestedReplicasInBroker);
        }
        double avgInterestedReplicas = (double)numInterestedReplicasInCluster / (double)this._numAliveBrokers;
        double varianceForInterestedReplicas = 0.0;
        for (Broker broker : clusterModel.aliveBrokers()) {
            varianceForInterestedReplicas += Math.pow((double)numInterestedReplicasFunc.apply(broker).intValue() - avgInterestedReplicas, 2.0) / (double)this._numAliveBrokers;
        }
        interestedReplicaStats.put(Statistic.AVG, avgInterestedReplicas);
        interestedReplicaStats.put(Statistic.MAX, maxInterestedReplicasInBroker);
        interestedReplicaStats.put(Statistic.MIN, minInterestedReplicasInBroker);
        interestedReplicaStats.put(Statistic.ST_DEV, Math.sqrt(varianceForInterestedReplicas));
    }

    private void numForAvgTopicReplicas(ClusterModel clusterModel) {
        this._topicReplicaStats.put(Statistic.AVG, 0.0);
        this._topicReplicaStats.put(Statistic.MAX, 0);
        this._topicReplicaStats.put(Statistic.MIN, Integer.MAX_VALUE);
        this._topicReplicaStats.put(Statistic.ST_DEV, 0.0);
        int numAliveBrokers = clusterModel.aliveBrokers().size();
        for (String topic : clusterModel.topics()) {
            int maxTopicReplicasInBroker = 0;
            int minTopicReplicasInBroker = Integer.MAX_VALUE;
            for (Broker broker : clusterModel.brokers()) {
                int numTopicReplicasInBroker = broker.numReplicasOfTopicInBroker(topic);
                maxTopicReplicasInBroker = Math.max(maxTopicReplicasInBroker, numTopicReplicasInBroker);
                minTopicReplicasInBroker = Math.min(minTopicReplicasInBroker, numTopicReplicasInBroker);
            }
            double avgTopicReplicas = (double)clusterModel.numTopicReplicas(topic) / (double)numAliveBrokers;
            double variance = 0.0;
            for (Broker broker : clusterModel.aliveBrokers()) {
                variance += Math.pow((double)broker.numReplicasOfTopicInBroker(topic) - avgTopicReplicas, 2.0) / (double)numAliveBrokers;
            }
            this._topicReplicaStats.put(Statistic.AVG, this._topicReplicaStats.get((Object)Statistic.AVG).doubleValue() + avgTopicReplicas);
            this._topicReplicaStats.put(Statistic.MAX, Math.max(this._topicReplicaStats.get((Object)Statistic.MAX).intValue(), maxTopicReplicasInBroker));
            this._topicReplicaStats.put(Statistic.MIN, Math.min(this._topicReplicaStats.get((Object)Statistic.MIN).intValue(), minTopicReplicasInBroker));
            this._topicReplicaStats.put(Statistic.ST_DEV, (Double)this._topicReplicaStats.get((Object)Statistic.ST_DEV) + Math.sqrt(variance));
        }
        this._topicReplicaStats.put(Statistic.AVG, this._topicReplicaStats.get((Object)Statistic.AVG).doubleValue() / (double)this._numTopics);
        this._topicReplicaStats.put(Statistic.ST_DEV, this._topicReplicaStats.get((Object)Statistic.ST_DEV).doubleValue() / (double)this._numTopics);
    }

    private void populateStatsForDisks(ClusterModel clusterModel, BalancingConstraint balancingConstraint) {
        double totalDiskUtilizationVariance = 0.0;
        int numAliveDisks = 0;
        for (Broker broker : clusterModel.aliveBrokers()) {
            double brokerDiskUtilization = GoalUtils.averageDiskUtilizationPercentage(broker);
            double upperLimit = brokerDiskUtilization * balancingConstraint.resourceBalancePercentage(Resource.DISK);
            double lowerLimit = brokerDiskUtilization * Math.max(0.0, 2.0 - balancingConstraint.resourceBalancePercentage(Resource.DISK));
            for (Disk disk : broker.disks()) {
                if (!disk.isAlive()) continue;
                double diskUtilizationPercentage = GoalUtils.diskUtilizationPercentage(disk);
                if (diskUtilizationPercentage > upperLimit || diskUtilizationPercentage < lowerLimit) {
                    ++this._numUnbalancedDisks;
                }
                totalDiskUtilizationVariance += Math.pow(diskUtilizationPercentage - brokerDiskUtilization, 2.0);
                ++numAliveDisks;
            }
        }
        if (numAliveDisks > 0) {
            this._diskUtilizationStDev = Math.sqrt(totalDiskUtilizationVariance / (double)numAliveDisks);
        }
    }
}

