/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskState;
import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExecutorUtils$ {
    public static ExecutorUtils$ MODULE$;
    private final Logger LOG;

    static {
        new ExecutorUtils$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public void executeReplicaReassignmentTasks(KafkaZkClient kafkaZkClient, List<ExecutionTask> tasksToExecute) {
        block1: {
            if (tasksToExecute == null || tasksToExecute.isEmpty()) break block1;
            Map inProgressReplicaReassignment = kafkaZkClient.getPartitionReassignment();
            scala.collection.mutable.Map newReplicaAssignment = (scala.collection.mutable.Map)Map$.MODULE$.apply(inProgressReplicaReassignment.toSeq());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tasksToExecute).asScala()).foreach(arg_0 -> ExecutorUtils$.$anonfun$executeReplicaReassignmentTasks$1(newReplicaAssignment, kafkaZkClient, arg_0));
            if (newReplicaAssignment.nonEmpty()) {
                kafkaZkClient.setOrCreatePartitionReassignment((Map)newReplicaAssignment, ZkVersion$.MODULE$.MatchAnyVersion());
            }
        }
    }

    public void executePreferredLeaderElection(KafkaZkClient kafkaZkClient, List<ExecutionTask> tasks) {
        scala.collection.immutable.Set partitionsToExecute = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tasks).asScala()).map((Function1 & Serializable & scala.Serializable)task -> new TopicPartition(task.proposal().topic(), task.proposal().partitionId()), Buffer$.MODULE$.canBuildFrom())).toSet();
        PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(kafkaZkClient, (Set)partitionsToExecute);
        preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
    }

    public java.util.Set<TopicPartition> partitionsBeingReassigned(KafkaZkClient kafkaZkClient) {
        return JavaConverters$.MODULE$.setAsJavaSet((Set)kafkaZkClient.getPartitionReassignment().keys().toSet());
    }

    public java.util.Set<TopicPartition> ongoingLeaderElection(KafkaZkClient kafkaZkClient) {
        return JavaConverters$.MODULE$.setAsJavaSet((Set)kafkaZkClient.getPreferredReplicaElection());
    }

    public List<Integer> newAssignmentForPartition(KafkaZkClient kafkaZkClient, TopicPartition tp) {
        Seq inProgressReassignment = (Seq)kafkaZkClient.getPartitionReassignment().getOrElse((Object)new TopicPartition(tp.topic(), tp.partition()), (Function0 & Serializable & scala.Serializable)() -> {
            throw new NoSuchElementException(new StringBuilder(35).append("Partition ").append(tp).append(" is not being reassigned.").toString());
        });
        return JavaConverters$.MODULE$.seqAsJavaList((Seq)inProgressReassignment.map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom()));
    }

    public List<Integer> currentReplicasForPartition(KafkaZkClient kafkaZkClient, TopicPartition tp) {
        return JavaConverters$.MODULE$.seqAsJavaList((Seq)kafkaZkClient.getReplicasForPartition(new TopicPartition(tp.topic(), tp.partition())).map((Function1 & Serializable & scala.Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom()));
    }

    public void changeBrokerConfig(AdminZkClient adminZkClient, int brokerId, Properties config) {
        adminZkClient.changeBrokerConfig((Option)new Some((Object)BoxesRunTime.boxToInteger((int)brokerId)), config);
    }

    public void changeTopicConfig(AdminZkClient adminZkClient, String topic, Properties config) {
        adminZkClient.changeTopicConfig(topic, config);
    }

    public List<Integer> getAllLiveBrokerIdsInCluster(KafkaZkClient kafkaZkClient) {
        return JavaConverters$.MODULE$.seqAsJavaList((Seq)kafkaZkClient.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$3 -> Predef$.MODULE$.int2Integer(x$3.id()), Seq$.MODULE$.canBuildFrom()));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$executeReplicaReassignmentTasks$1(scala.collection.mutable.Map newReplicaAssignment$1, KafkaZkClient kafkaZkClient$1, ExecutionTask task) {
        block12: {
            block13: {
                block9: {
                    block11: {
                        block10: {
                            tp = task.proposal().topicPartition();
                            oldReplicas = (Buffer)JavaConverters$.MODULE$.asScalaBuffer(task.proposal().oldReplicas()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$executeReplicaReassignmentTasks$2$adapted(com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo ), (Lcom/linkedin/kafka/cruisecontrol/model/ReplicaPlacementInfo;)Ljava/lang/Object;)(), Buffer$.MODULE$.canBuildFrom());
                            newReplicas = (Buffer)JavaConverters$.MODULE$.asScalaBuffer(task.proposal().newReplicas()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$executeReplicaReassignmentTasks$3$adapted(com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo ), (Lcom/linkedin/kafka/cruisecontrol/model/ReplicaPlacementInfo;)Ljava/lang/Object;)(), Buffer$.MODULE$.canBuildFrom());
                            inProgressReplicasOpt = newReplicaAssignment$1.get((Object)tp);
                            addTask = true;
                            var10_8 = inProgressReplicasOpt;
                            if (!(var10_8 instanceof Some)) break block9;
                            var11_9 = (Some)var10_8;
                            inProgressReplicas = (Seq)var11_9.value();
                            v0 = task.state();
                            var13_11 = ExecutionTaskState.ABORTING;
                            if (v0 != null ? v0.equals((Object)var13_11) == false : var13_11 != null) break block10;
                            v1 = oldReplicas;
                            break block11;
                        }
                        v2 = task.state();
                        var14_12 = ExecutionTaskState.DEAD;
                        if (!(v2 == null ? var14_12 != null : v2.equals((Object)var14_12) == false)) ** GOTO lbl-1000
                        v3 = task.state();
                        var15_13 = ExecutionTaskState.ABORTED;
                        if (!(v3 == null ? var15_13 != null : v3.equals((Object)var15_13) == false)) ** GOTO lbl-1000
                        v4 = task.state();
                        var16_14 = ExecutionTaskState.COMPLETED;
                        if (!(v4 != null ? v4.equals((Object)var16_14) == false : var16_14 != null)) lbl-1000:
                        // 3 sources

                        {
                            addTask = false;
                            v1 = (Seq)Seq$.MODULE$.empty();
                        } else {
                            v5 = task.state();
                            var17_15 = ExecutionTaskState.IN_PROGRESS;
                            if (!(v5 != null ? v5.equals((Object)var17_15) == false : var17_15 != null)) {
                                if (!newReplicas.equals((Object)inProgressReplicas)) {
                                    throw new RuntimeException(new StringBuilder(82).append("The provided new replica list ").append(newReplicas).append("is different from the in progress replica list ").append(inProgressReplicas).append(" for ").append(tp).toString());
                                }
                                v1 = newReplicas;
                            } else {
                                throw new IllegalStateException(new StringBuilder(35).append("Should never be here, the state is ").append((Object)task.state()).toString());
                            }
                        }
                    }
                    var3_16 = v1;
                    break block12;
                }
                if (!None$.MODULE$.equals(var10_8)) break block13;
                v6 = task.state();
                var18_17 = ExecutionTaskState.ABORTED;
                if (!(v6 == null ? var18_17 != null : v6.equals((Object)var18_17) == false)) ** GOTO lbl-1000
                v7 = task.state();
                var19_18 = ExecutionTaskState.DEAD;
                if (!(v7 == null ? var19_18 != null : v7.equals((Object)var19_18) == false)) ** GOTO lbl-1000
                v8 = task.state();
                var20_19 = ExecutionTaskState.ABORTING;
                if (!(v8 == null ? var20_19 != null : v8.equals((Object)var20_19) == false)) ** GOTO lbl-1000
                v9 = task.state();
                var21_20 = ExecutionTaskState.COMPLETED;
                if (!(v9 != null ? v9.equals((Object)var21_20) == false : var21_20 != null)) lbl-1000:
                // 4 sources

                {
                    ExecutorUtils$.MODULE$.LOG().warn(new StringBuilder(68).append("No need to abort tasks ").append(task).append(" because the partition is not in reassignment").toString());
                    addTask = false;
                    v10 = (Seq)Seq$.MODULE$.empty();
                } else {
                    currentReplicaAssignment = kafkaZkClient$1.getReplicasForPartition(tp);
                    if (currentReplicaAssignment.isEmpty()) {
                        ExecutorUtils$.MODULE$.LOG().warn(new StringBuilder(30).append("The partition ").append(tp).append(" does not exist.").toString());
                        addTask = false;
                        v10 = (Seq)Seq$.MODULE$.empty();
                    } else {
                        v10 = newReplicas;
                    }
                }
                var3_16 = v10;
                break block12;
            }
            throw new MatchError((Object)var10_8);
        }
        replicasToWrite = var3_16;
        return addTask != false ? newReplicaAssignment$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)replicasToWrite)) : BoxedUnit.UNIT;
    }

    private ExecutorUtils$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    }

    public static final /* synthetic */ Object $anonfun$executeReplicaReassignmentTasks$2$adapted(ReplicaPlacementInfo x$1) {
        return BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1.brokerId()));
    }

    public static final /* synthetic */ Object $anonfun$executeReplicaReassignmentTasks$3$adapted(ReplicaPlacementInfo x$2) {
        return BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2.brokerId()));
    }
}

