/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskState;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskTracker;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseClass;
import com.linkedin.kafka.cruisecontrol.servlet.response.JsonResponseField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonResponseClass
public class ExecutorState {
    @JsonResponseField(required=false)
    private static final String TRIGGERED_USER_TASK_ID = "triggeredUserTaskId";
    @JsonResponseField(required=false)
    private static final String TRIGGERED_SELF_HEALING_TASK_ID = "triggeredSelfHealingTaskId";
    @JsonResponseField(required=false)
    private static final String TRIGGERED_TASK_REASON = "triggeredTaskReason";
    @JsonResponseField
    private static final String STATE = "state";
    @JsonResponseField(required=false)
    private static final String RECENTLY_DEMOTED_BROKERS = "recentlyDemotedBrokers";
    @JsonResponseField(required=false)
    private static final String RECENTLY_REMOVED_BROKERS = "recentlyRemovedBrokers";
    @JsonResponseField(required=false)
    private static final String NUM_TOTAL_LEADERSHIP_MOVEMENTS = "numTotalLeadershipMovements";
    @JsonResponseField(required=false)
    private static final String NUM_PENDING_LEADERSHIP_MOVEMENTS = "numPendingLeadershipMovements";
    @JsonResponseField(required=false)
    private static final String NUM_CANCELLED_LEADERSHIP_MOVEMENTS = "numCancelledLeadershipMovements";
    @JsonResponseField(required=false)
    private static final String NUM_FINISHED_LEADERSHIP_MOVEMENTS = "numFinishedLeadershipMovements";
    @JsonResponseField(required=false)
    private static final String PENDING_LEADERSHIP_MOVEMENT = "pendingLeadershipMovement";
    @JsonResponseField(required=false)
    private static final String CANCELLED_LEADERSHIP_MOVEMENT = "cancelledLeadershipMovement";
    @JsonResponseField(required=false)
    private static final String MAXIMUM_CONCURRENT_LEADER_MOVEMENTS = "maximumConcurrentLeaderMovements";
    @JsonResponseField(required=false)
    private static final String NUM_TOTAL_INTER_BROKER_PARTITION_MOVEMENTS = "numTotalPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_PENDING_INTER_BROKER_PARTITION_MOVEMENTS = "numPendingPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_CANCELLED_INTER_BROKER_PARTITION_MOVEMENTS = "numCancelledPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENTS = "numInProgressPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_ABORTING_INTER_BROKER_PARTITION_MOVEMENTS = "abortingPartitions";
    @JsonResponseField(required=false)
    private static final String NUM_FINISHED_INTER_BROKER_PARTITION_MOVEMENTS = "numFinishedPartitionMovements";
    @JsonResponseField(required=false)
    private static final String IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENT = "inProgressPartitionMovement";
    @JsonResponseField(required=false)
    private static final String PENDING_INTER_BROKER_PARTITION_MOVEMENT = "pendingPartitionMovement";
    @JsonResponseField(required=false)
    private static final String CANCELLED_INTER_BROKER_PARTITION_MOVEMENT = "cancelledPartitionMovement";
    @JsonResponseField(required=false)
    private static final String DEAD_INTER_BROKER_PARTITION_MOVEMENT = "deadPartitionMovement";
    @JsonResponseField(required=false)
    private static final String COMPLETED_INTER_BROKER_PARTITION_MOVEMENT = "completedPartitionMovement";
    @JsonResponseField(required=false)
    private static final String ABORTING_INTER_BROKER_PARTITION_MOVEMENT = "abortingPartitionMovement";
    @JsonResponseField(required=false)
    private static final String ABORTED_INTER_BROKER_PARTITION_MOVEMENT = "abortedPartitionMovement";
    @JsonResponseField(required=false)
    private static final String FINISHED_INTER_BROKER_DATA_MOVEMENT = "finishedDataMovement";
    @JsonResponseField(required=false)
    private static final String TOTAL_INTER_BROKER_DATA_TO_MOVE = "totalDataToMove";
    @JsonResponseField(required=false)
    private static final String MAXIMUM_CONCURRENT_INTER_BROKER_PARTITION_MOVEMENTS_PER_BROKER = "maximumConcurrentPartitionMovementsPerBroker";
    @JsonResponseField(required=false)
    private static final String NUM_TOTAL_INTRA_BROKER_PARTITION_MOVEMENTS = "numTotalIntraBrokerPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_FINISHED_INTRA_BROKER_PARTITION_MOVEMENTS = "numFinishedIntraBrokerPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_IN_PROGRESS_INTRA_BROKER_PARTITION_MOVEMENTS = "numInProgressIntraBrokerPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_ABORTING_INTRA_BROKER_PARTITION_MOVEMENTS = "numAbortingIntraBrokerPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_PENDING_INTRA_BROKER_PARTITION_MOVEMENTS = "numPendingIntraBrokerPartitionMovements";
    @JsonResponseField(required=false)
    private static final String NUM_CANCELLED_INTRA_BROKER_PARTITION_MOVEMENTS = "numCancelledIntraBrokerPartitionMovements";
    @JsonResponseField(required=false)
    private static final String IN_PROGRESS_INTRA_BROKER_PARTITION_MOVEMENT = "inProgressIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String PENDING_INTRA_BROKER_PARTITION_MOVEMENT = "pendingIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String CANCELLED_INTRA_BROKER_PARTITION_MOVEMENT = "cancelledIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String DEAD_INTRA_BROKER_PARTITION_MOVEMENT = "deadIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String COMPLETED_INTRA_BROKER_PARTITION_MOVEMENT = "completedIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String ABORTING_INTRA_BROKER_PARTITION_MOVEMENT = "abortingIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String ABORTED_INTRA_BROKER_PARTITION_MOVEMENT = "abortedIntraBrokerPartitionMovement";
    @JsonResponseField(required=false)
    private static final String FINISHED_INTRA_BROKER_DATA_MOVEMENT = "finishedIntraBrokerDataMovement";
    @JsonResponseField(required=false)
    private static final String TOTAL_INTRA_BROKER_DATA_TO_MOVE = "totalIntraBrokerDataToMove";
    @JsonResponseField(required=false)
    private static final String MAXIMUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_PER_BROKER = "maximumConcurrentIntraBrokerPartitionMovementsPerBroker";
    @JsonResponseField(required=false)
    private static final String ERROR = "error";
    public static final Set<State> IN_PROGRESS_STATES;
    private final State _state;
    private final ExecutionTaskTracker.ExecutionTasksSummary _executionTasksSummary;
    private final int _maximumConcurrentInterBrokerPartitionMovementsPerBroker;
    private final int _maximumConcurrentIntraBrokerPartitionMovementsPerBroker;
    private final int _maximumConcurrentLeaderMovements;
    private final String _uuid;
    private final String _reason;
    private final boolean _isTriggeredByUserRequest;
    private final Set<Integer> _recentlyDemotedBrokers;
    private final Set<Integer> _recentlyRemovedBrokers;

    private ExecutorState(State state, ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary, int maximumConcurrentInterBrokerPartitionMovementsPerBroker, int maximumConcurrentIntraBrokerPartitionMovementsPerBroker, int maximumConcurrentLeaderMovements, String uuid, String reason, Set<Integer> recentlyDemotedBrokers, Set<Integer> recentlyRemovedBrokers, boolean isTriggeredByUserRequest) {
        this._state = state;
        this._executionTasksSummary = executionTasksSummary;
        this._maximumConcurrentInterBrokerPartitionMovementsPerBroker = maximumConcurrentInterBrokerPartitionMovementsPerBroker;
        this._maximumConcurrentIntraBrokerPartitionMovementsPerBroker = maximumConcurrentIntraBrokerPartitionMovementsPerBroker;
        this._maximumConcurrentLeaderMovements = maximumConcurrentLeaderMovements;
        this._uuid = uuid;
        this._reason = reason;
        this._recentlyDemotedBrokers = recentlyDemotedBrokers;
        this._recentlyRemovedBrokers = recentlyRemovedBrokers;
        this._isTriggeredByUserRequest = isTriggeredByUserRequest;
    }

    public static ExecutorState noTaskInProgress(Set<Integer> recentlyDemotedBrokers, Set<Integer> recentlyRemovedBrokers) {
        return new ExecutorState(State.NO_TASK_IN_PROGRESS, null, 0, 0, 0, "", "", recentlyDemotedBrokers, recentlyRemovedBrokers, false);
    }

    public static ExecutorState executionStarting(String uuid, String reason, Set<Integer> recentlyDemotedBrokers, Set<Integer> recentlyRemovedBrokers, boolean isTriggeredByUserRequest) {
        return new ExecutorState(State.STARTING_EXECUTION, null, 0, 0, 0, uuid, reason, recentlyDemotedBrokers, recentlyRemovedBrokers, isTriggeredByUserRequest);
    }

    public static ExecutorState initializeProposalExecution(String uuid, String reason, Set<Integer> recentlyDemotedBrokers, Set<Integer> recentlyRemovedBrokers, boolean isTriggeredByUserRequest) {
        return new ExecutorState(State.INITIALIZING_PROPOSAL_EXECUTION, null, 0, 0, 0, uuid, reason, recentlyDemotedBrokers, recentlyRemovedBrokers, isTriggeredByUserRequest);
    }

    public static ExecutorState generatingProposalsForExecution(String uuid, String reason, Set<Integer> recentlyDemotedBrokers, Set<Integer> recentlyRemovedBrokers, boolean isTriggeredByUserRequest) {
        return new ExecutorState(State.GENERATING_PROPOSALS_FOR_EXECUTION, null, 0, 0, 0, uuid, reason, recentlyDemotedBrokers, recentlyRemovedBrokers, isTriggeredByUserRequest);
    }

    public static ExecutorState operationInProgress(State state, ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary, int maximumConcurrentInterBrokerPartitionMovementsPerBroker, int maximumConcurrentIntraBrokerPartitionMovementsPerBroker, int maximumConcurrentLeaderMovements, String uuid, String reason, Set<Integer> recentlyDemotedBrokers, Set<Integer> recentlyRemovedBrokers, boolean isTriggeredByUserRequest) {
        if (!IN_PROGRESS_STATES.contains((Object)state)) {
            throw new IllegalArgumentException(String.format("%s is not an operation-in-progress executor state %s.", new Object[]{state, IN_PROGRESS_STATES}));
        }
        return new ExecutorState(state, executionTasksSummary, maximumConcurrentInterBrokerPartitionMovementsPerBroker, maximumConcurrentIntraBrokerPartitionMovementsPerBroker, maximumConcurrentLeaderMovements, uuid, reason, recentlyDemotedBrokers, recentlyRemovedBrokers, isTriggeredByUserRequest);
    }

    public State state() {
        return this._state;
    }

    public int numTotalMovements(ExecutionTask.TaskType type) {
        return this._executionTasksSummary.taskStat().get((Object)type).values().stream().mapToInt(i -> i).sum();
    }

    public int numFinishedMovements(ExecutionTask.TaskType type) {
        return this._executionTasksSummary.taskStat().get((Object)type).get((Object)ExecutionTaskState.DEAD) + this._executionTasksSummary.taskStat().get((Object)type).get((Object)ExecutionTaskState.COMPLETED) + this._executionTasksSummary.taskStat().get((Object)type).get((Object)ExecutionTaskState.ABORTED);
    }

    public long numTotalInterBrokerDataToMove() {
        return this._executionTasksSummary.inExecutionInterBrokerDataMovementInMB() + this._executionTasksSummary.finishedInterBrokerDataMovementInMB() + this._executionTasksSummary.remainingInterBrokerDataToMoveInMB();
    }

    public long numTotalIntraBrokerDataToMove() {
        return this._executionTasksSummary.inExecutionIntraBrokerDataMovementInMB() + this._executionTasksSummary.finishedIntraBrokerDataMovementInMB() + this._executionTasksSummary.remainingIntraBrokerDataToMoveInMB();
    }

    public String uuid() {
        return this._uuid;
    }

    public Set<Integer> recentlyDemotedBrokers() {
        return this._recentlyDemotedBrokers;
    }

    public Set<Integer> recentlyRemovedBrokers() {
        return this._recentlyRemovedBrokers;
    }

    public ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary() {
        return this._executionTasksSummary;
    }

    private List<Object> getTaskDetails(ExecutionTask.TaskType type, ExecutionTaskState state) {
        ArrayList<Object> taskList = new ArrayList<Object>();
        for (ExecutionTask task : this._executionTasksSummary.filteredTasksByState().get((Object)type).get((Object)state)) {
            taskList.add(task.getJsonStructure());
        }
        return taskList;
    }

    private void populateUuidFieldInJsonStructure(Map<String, Object> execState, String uuid) {
        if (this._isTriggeredByUserRequest) {
            execState.put(TRIGGERED_SELF_HEALING_TASK_ID, "");
            execState.put(TRIGGERED_USER_TASK_ID, uuid);
        } else {
            execState.put(TRIGGERED_SELF_HEALING_TASK_ID, uuid);
            execState.put(TRIGGERED_USER_TASK_ID, "");
        }
    }

    public Map<String, Object> getJsonStructure(boolean verbose) {
        HashMap<String, Object> execState = new HashMap<String, Object>();
        execState.put(STATE, (Object)this._state);
        if (this._recentlyDemotedBrokers != null && !this._recentlyDemotedBrokers.isEmpty()) {
            execState.put(RECENTLY_DEMOTED_BROKERS, this._recentlyDemotedBrokers);
        }
        if (this._recentlyRemovedBrokers != null && !this._recentlyRemovedBrokers.isEmpty()) {
            execState.put(RECENTLY_REMOVED_BROKERS, this._recentlyRemovedBrokers);
        }
        switch (this._state) {
            case NO_TASK_IN_PROGRESS: {
                break;
            }
            case STARTING_EXECUTION: 
            case INITIALIZING_PROPOSAL_EXECUTION: 
            case GENERATING_PROPOSALS_FOR_EXECUTION: {
                this.populateUuidFieldInJsonStructure(execState, this._uuid);
                execState.put(TRIGGERED_TASK_REASON, this._reason);
                break;
            }
            case LEADER_MOVEMENT_TASK_IN_PROGRESS: {
                this.populateUuidFieldInJsonStructure(execState, this._uuid);
                execState.put(TRIGGERED_TASK_REASON, this._reason);
                execState.put(MAXIMUM_CONCURRENT_LEADER_MOVEMENTS, this._maximumConcurrentLeaderMovements);
                execState.put(NUM_PENDING_LEADERSHIP_MOVEMENTS, this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.PENDING));
                execState.put(NUM_FINISHED_LEADERSHIP_MOVEMENTS, this.numFinishedMovements(ExecutionTask.TaskType.LEADER_ACTION));
                execState.put(NUM_TOTAL_LEADERSHIP_MOVEMENTS, this.numTotalMovements(ExecutionTask.TaskType.LEADER_ACTION));
                if (!verbose) break;
                execState.put(PENDING_LEADERSHIP_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.LEADER_ACTION, ExecutionTaskState.PENDING));
                break;
            }
            case INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                Map<ExecutionTaskState, Integer> interBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                this.populateUuidFieldInJsonStructure(execState, this._uuid);
                execState.put(TRIGGERED_TASK_REASON, this._reason);
                execState.put(MAXIMUM_CONCURRENT_INTER_BROKER_PARTITION_MOVEMENTS_PER_BROKER, this._maximumConcurrentInterBrokerPartitionMovementsPerBroker);
                execState.put(NUM_IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS));
                execState.put(NUM_ABORTING_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING));
                execState.put(NUM_PENDING_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING));
                execState.put(NUM_FINISHED_INTER_BROKER_PARTITION_MOVEMENTS, this.numFinishedMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION));
                execState.put(NUM_TOTAL_INTER_BROKER_PARTITION_MOVEMENTS, this.numTotalMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION));
                execState.put(FINISHED_INTER_BROKER_DATA_MOVEMENT, this._executionTasksSummary.finishedInterBrokerDataMovementInMB());
                execState.put(TOTAL_INTER_BROKER_DATA_TO_MOVE, this.numTotalInterBrokerDataToMove());
                if (!verbose) break;
                execState.put(IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.IN_PROGRESS));
                execState.put(PENDING_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.PENDING));
                execState.put(ABORTING_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.ABORTING));
                execState.put(ABORTED_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.ABORTED));
                execState.put(DEAD_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.DEAD));
                execState.put(COMPLETED_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.COMPLETED));
                break;
            }
            case INTRA_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                Map<ExecutionTaskState, Integer> intraBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION);
                this.populateUuidFieldInJsonStructure(execState, this._uuid);
                execState.put(TRIGGERED_TASK_REASON, this._reason);
                execState.put(MAXIMUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_PER_BROKER, this._maximumConcurrentIntraBrokerPartitionMovementsPerBroker);
                execState.put(NUM_IN_PROGRESS_INTRA_BROKER_PARTITION_MOVEMENTS, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS));
                execState.put(NUM_ABORTING_INTRA_BROKER_PARTITION_MOVEMENTS, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING));
                execState.put(NUM_PENDING_INTRA_BROKER_PARTITION_MOVEMENTS, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING));
                execState.put(NUM_FINISHED_INTRA_BROKER_PARTITION_MOVEMENTS, this.numFinishedMovements(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION));
                execState.put(NUM_TOTAL_INTRA_BROKER_PARTITION_MOVEMENTS, this.numTotalMovements(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION));
                execState.put(FINISHED_INTRA_BROKER_DATA_MOVEMENT, this._executionTasksSummary.finishedIntraBrokerDataMovementInMB());
                execState.put(TOTAL_INTRA_BROKER_DATA_TO_MOVE, this.numTotalIntraBrokerDataToMove());
                if (!verbose) break;
                execState.put(IN_PROGRESS_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.IN_PROGRESS));
                execState.put(PENDING_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.PENDING));
                execState.put(ABORTING_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.ABORTING));
                execState.put(ABORTED_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.ABORTED));
                execState.put(DEAD_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.DEAD));
                execState.put(COMPLETED_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.COMPLETED));
                break;
            }
            case STOPPING_EXECUTION: {
                Map<ExecutionTaskState, Integer> interBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                Map<ExecutionTaskState, Integer> intraBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION);
                this.populateUuidFieldInJsonStructure(execState, this._uuid);
                execState.put(TRIGGERED_TASK_REASON, this._reason);
                execState.put(MAXIMUM_CONCURRENT_INTER_BROKER_PARTITION_MOVEMENTS_PER_BROKER, this._maximumConcurrentInterBrokerPartitionMovementsPerBroker);
                execState.put(MAXIMUM_CONCURRENT_INTRA_BROKER_PARTITION_MOVEMENTS_PER_BROKER, this._maximumConcurrentIntraBrokerPartitionMovementsPerBroker);
                execState.put(MAXIMUM_CONCURRENT_LEADER_MOVEMENTS, this._maximumConcurrentLeaderMovements);
                execState.put(NUM_CANCELLED_LEADERSHIP_MOVEMENTS, this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.PENDING));
                execState.put(NUM_IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS));
                execState.put(NUM_ABORTING_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING));
                execState.put(NUM_CANCELLED_INTER_BROKER_PARTITION_MOVEMENTS, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING));
                execState.put(NUM_IN_PROGRESS_INTRA_BROKER_PARTITION_MOVEMENTS, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS));
                execState.put(NUM_ABORTING_INTRA_BROKER_PARTITION_MOVEMENTS, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING));
                execState.put(NUM_CANCELLED_INTRA_BROKER_PARTITION_MOVEMENTS, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING));
                if (!verbose) break;
                execState.put(CANCELLED_LEADERSHIP_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.LEADER_ACTION, ExecutionTaskState.PENDING));
                execState.put(CANCELLED_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.PENDING));
                execState.put(IN_PROGRESS_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.IN_PROGRESS));
                execState.put(ABORTING_INTER_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION, ExecutionTaskState.ABORTING));
                execState.put(CANCELLED_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.PENDING));
                execState.put(IN_PROGRESS_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.IN_PROGRESS));
                execState.put(ABORTING_INTRA_BROKER_PARTITION_MOVEMENT, this.getTaskDetails(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION, ExecutionTaskState.ABORTING));
                break;
            }
            default: {
                execState.clear();
                execState.put(ERROR, "ILLEGAL_STATE_EXCEPTION");
            }
        }
        return execState;
    }

    public String getPlaintext() {
        String recentlyDemotedBrokers = this._recentlyDemotedBrokers != null && !this._recentlyDemotedBrokers.isEmpty() ? String.format(", %s: %s", RECENTLY_DEMOTED_BROKERS, this._recentlyDemotedBrokers) : "";
        String recentlyRemovedBrokers = this._recentlyRemovedBrokers != null && !this._recentlyRemovedBrokers.isEmpty() ? String.format(", %s: %s", RECENTLY_REMOVED_BROKERS, this._recentlyRemovedBrokers) : "";
        switch (this._state) {
            case NO_TASK_IN_PROGRESS: {
                return String.format("{%s: %s%s%s}", new Object[]{STATE, this._state, recentlyDemotedBrokers, recentlyRemovedBrokers});
            }
            case STARTING_EXECUTION: 
            case INITIALIZING_PROPOSAL_EXECUTION: 
            case GENERATING_PROPOSALS_FOR_EXECUTION: {
                return String.format("{%s: %s, %s: %s, %s: %s%s%s}", new Object[]{STATE, this._state, this._isTriggeredByUserRequest ? TRIGGERED_USER_TASK_ID : TRIGGERED_SELF_HEALING_TASK_ID, this._uuid, TRIGGERED_TASK_REASON, this._reason, recentlyDemotedBrokers, recentlyRemovedBrokers});
            }
            case LEADER_MOVEMENT_TASK_IN_PROGRESS: {
                return String.format("{%s: %s, finished/total leadership movements: %d/%d, maximum concurrent leadership movements: %d, %s: %s, %s: %s%s%s}", new Object[]{STATE, this._state, this.numFinishedMovements(ExecutionTask.TaskType.LEADER_ACTION), this.numTotalMovements(ExecutionTask.TaskType.LEADER_ACTION), this._maximumConcurrentLeaderMovements, this._isTriggeredByUserRequest ? TRIGGERED_USER_TASK_ID : TRIGGERED_SELF_HEALING_TASK_ID, this._uuid, TRIGGERED_TASK_REASON, this._reason, recentlyDemotedBrokers, recentlyRemovedBrokers});
            }
            case INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                Map<ExecutionTaskState, Integer> interBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                return String.format("{%s: %s, pending/in-progress/aborting/finished/total inter-broker partition movement %d/%d/%d/%d/%d, completed/total bytes(MB): %d/%d, maximum concurrent inter-broker partition movements per-broker: %d, %s: %s, %s: %s%s%s}", new Object[]{STATE, this._state, interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING), interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS), interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING), this.numFinishedMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), this.numTotalMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), this._executionTasksSummary.finishedInterBrokerDataMovementInMB(), this.numTotalInterBrokerDataToMove(), this._maximumConcurrentInterBrokerPartitionMovementsPerBroker, this._isTriggeredByUserRequest ? TRIGGERED_USER_TASK_ID : TRIGGERED_SELF_HEALING_TASK_ID, this._uuid, TRIGGERED_TASK_REASON, this._reason, recentlyDemotedBrokers, recentlyRemovedBrokers});
            }
            case INTRA_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                Map<ExecutionTaskState, Integer> intraBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION);
                return String.format("{%s: %s, pending/in-progress/aborting/finished/total intra-broker partition movement %d/%d/%d/%d/%d, completed/total bytes(MB): %d/%d, maximum concurrent intra-broker partition movements per-broker: %d, %s: %s, %s: %s%s%s}", new Object[]{STATE, this._state, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING), intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS), intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING), this.numFinishedMovements(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION), this.numTotalMovements(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION), this._executionTasksSummary.finishedIntraBrokerDataMovementInMB(), this.numTotalIntraBrokerDataToMove(), this._maximumConcurrentIntraBrokerPartitionMovementsPerBroker, this._isTriggeredByUserRequest ? TRIGGERED_USER_TASK_ID : TRIGGERED_SELF_HEALING_TASK_ID, this._uuid, TRIGGERED_TASK_REASON, this._reason, recentlyDemotedBrokers, recentlyRemovedBrokers});
            }
            case STOPPING_EXECUTION: {
                Map<ExecutionTaskState, Integer> interBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION);
                Map<ExecutionTaskState, Integer> intraBrokerPartitionMovementStats = this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION);
                return String.format("{%s: %s, cancelled/in-progress/aborting/total intra-broker partition movement %d/%d/%d/%d,cancelled/in-progress/aborting/total inter-broker partition movements movements: %d/%d/%d/%d,cancelled/total leadership movements: %d/%d, maximum concurrent intra-broker partition movements per-broker: %d, maximum concurrent inter-broker partition movements per-broker: %d, maximum concurrent leadership movements: %d, %s: %s, %s: %s%s%s}", new Object[]{STATE, this._state, intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING), intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS), intraBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING), this.numTotalMovements(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION), interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.PENDING), interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.IN_PROGRESS), interBrokerPartitionMovementStats.get((Object)ExecutionTaskState.ABORTING), this.numTotalMovements(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), this._executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.PENDING), this.numTotalMovements(ExecutionTask.TaskType.LEADER_ACTION), this._maximumConcurrentIntraBrokerPartitionMovementsPerBroker, this._maximumConcurrentInterBrokerPartitionMovementsPerBroker, this._maximumConcurrentLeaderMovements, this._isTriggeredByUserRequest ? TRIGGERED_USER_TASK_ID : TRIGGERED_SELF_HEALING_TASK_ID, this._uuid, TRIGGERED_TASK_REASON, this._reason, recentlyDemotedBrokers, recentlyRemovedBrokers});
            }
        }
        throw new IllegalStateException("This should never happen");
    }

    static {
        HashSet<State> inProgressStates = new HashSet<State>(4);
        inProgressStates.addAll(Arrays.asList(State.INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS, State.INTRA_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS, State.LEADER_MOVEMENT_TASK_IN_PROGRESS, State.STOPPING_EXECUTION));
        IN_PROGRESS_STATES = Collections.unmodifiableSet(inProgressStates);
    }

    public static enum State {
        NO_TASK_IN_PROGRESS,
        STARTING_EXECUTION,
        INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS,
        INTRA_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS,
        LEADER_MOVEMENT_TASK_IN_PROGRESS,
        STOPPING_EXECUTION,
        INITIALIZING_PROPOSAL_EXECUTION,
        GENERATING_PROPOSALS_FOR_EXECUTION;

    }
}

