/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskState;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Time;

public class ExecutionTaskTracker {
    private final Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> _tasksByType;
    private long _remainingInterBrokerDataToMoveInMB;
    private long _remainingIntraBrokerDataToMoveInMB;
    private long _inExecutionInterBrokerDataMovementInMB;
    private long _inExecutionIntraBrokerDataMovementInMB;
    private long _finishedInterBrokerDataMovementInMB;
    private long _finishedIntraBrokerDataMovementInMB;
    private boolean _isKafkaAssignerMode;
    private final Time _time;
    private volatile boolean _stopRequested;
    private static final String INTER_BROKER_REPLICA_ACTION = "replica-action";
    private static final String INTRA_BROKER_REPLICA_ACTION = "intra-broker-replica-action";
    private static final String LEADERSHIP_ACTION = "leadership-action";
    private static final String IN_PROGRESS = "in-progress";
    private static final String PENDING = "pending";
    private static final String ABORTING = "aborting";
    private static final String ABORTED = "aborted";
    private static final String DEAD = "dead";
    private static final String COMPLETED = "completed";
    private static final String GAUGE_ONGOING_EXECUTION_IN_KAFKA_ASSIGNER_MODE = "ongoing-execution-kafka_assigner";
    private static final String GAUGE_ONGOING_EXECUTION_IN_NON_KAFKA_ASSIGNER_MODE = "ongoing-execution-non_kafka_assigner";

    ExecutionTaskTracker(MetricRegistry dropwizardMetricRegistry, Time time) {
        List<ExecutionTaskState> states = ExecutionTaskState.cachedValues();
        List<ExecutionTask.TaskType> taskTypes = ExecutionTask.TaskType.cachedValues();
        this._tasksByType = new HashMap<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>>(taskTypes.size());
        for (ExecutionTask.TaskType type : taskTypes) {
            HashMap taskMap = new HashMap(states.size());
            for (ExecutionTaskState state : states) {
                taskMap.put(state, new HashSet());
            }
            this._tasksByType.put(type, taskMap);
        }
        this._remainingInterBrokerDataToMoveInMB = 0L;
        this._remainingIntraBrokerDataToMoveInMB = 0L;
        this._inExecutionInterBrokerDataMovementInMB = 0L;
        this._inExecutionIntraBrokerDataMovementInMB = 0L;
        this._finishedInterBrokerDataMovementInMB = 0L;
        this._finishedIntraBrokerDataMovementInMB = 0L;
        this._isKafkaAssignerMode = false;
        this._time = time;
        this._stopRequested = false;
        this.registerGaugeSensors(dropwizardMetricRegistry);
    }

    private void registerGaugeSensors(MetricRegistry dropwizardMetricRegistry) {
        String metricName = "Executor";
        for (ExecutionTask.TaskType type : ExecutionTask.TaskType.cachedValues()) {
            for (ExecutionTaskState state : ExecutionTaskState.cachedValues()) {
                String typeString;
                String string = type == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION ? INTER_BROKER_REPLICA_ACTION : (typeString = type == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION ? INTRA_BROKER_REPLICA_ACTION : LEADERSHIP_ACTION);
                String stateString = state == ExecutionTaskState.PENDING ? PENDING : (state == ExecutionTaskState.IN_PROGRESS ? IN_PROGRESS : (state == ExecutionTaskState.ABORTING ? ABORTING : (state == ExecutionTaskState.ABORTED ? ABORTED : (state == ExecutionTaskState.COMPLETED ? COMPLETED : DEAD))));
                dropwizardMetricRegistry.register(MetricRegistry.name((String)metricName, (String[])new String[]{typeString + "-" + stateString}), (Metric)((Gauge)() -> state == ExecutionTaskState.PENDING && this._stopRequested ? 0 : this._tasksByType.get((Object)type).get((Object)state).size()));
            }
        }
        dropwizardMetricRegistry.register(MetricRegistry.name((String)metricName, (String[])new String[]{GAUGE_ONGOING_EXECUTION_IN_KAFKA_ASSIGNER_MODE}), (Metric)((Gauge)() -> this._isKafkaAssignerMode && !this.inExecutionTasks(ExecutionTask.TaskType.cachedValues()).isEmpty() ? 1 : 0));
        dropwizardMetricRegistry.register(MetricRegistry.name((String)metricName, (String[])new String[]{GAUGE_ONGOING_EXECUTION_IN_NON_KAFKA_ASSIGNER_MODE}), (Metric)((Gauge)() -> !this._isKafkaAssignerMode && !this.inExecutionTasks(ExecutionTask.TaskType.cachedValues()).isEmpty() ? 1 : 0));
    }

    public void markTaskState(ExecutionTask task, ExecutionTaskState newState) {
        this._tasksByType.get((Object)task.type()).get((Object)task.state()).remove(task);
        switch (newState) {
            case PENDING: {
                break;
            }
            case IN_PROGRESS: {
                task.inProgress(this._time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
            case ABORTING: {
                task.abort();
                break;
            }
            case ABORTED: {
                task.aborted(this._time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
            case COMPLETED: {
                task.completed(this._time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
            case DEAD: {
                task.kill(this._time.milliseconds());
                this.updateDataMovement(task);
                break;
            }
        }
        this._tasksByType.get((Object)task.type()).get((Object)newState).add(task);
    }

    private void updateDataMovement(ExecutionTask task) {
        long dataToMove;
        long l = task.type() == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION ? task.proposal().intraBrokerDataToMoveInMB() : (dataToMove = task.type() == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION ? task.proposal().interBrokerDataToMoveInMB() : 0L);
        if (task.state() == ExecutionTaskState.IN_PROGRESS) {
            if (task.type() == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION) {
                this._remainingIntraBrokerDataToMoveInMB -= dataToMove;
                this._inExecutionIntraBrokerDataMovementInMB += dataToMove;
            } else if (task.type() == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) {
                this._remainingInterBrokerDataToMoveInMB -= dataToMove;
                this._inExecutionInterBrokerDataMovementInMB += dataToMove;
            }
        } else if (task.state() == ExecutionTaskState.ABORTED || task.state() == ExecutionTaskState.DEAD || task.state() == ExecutionTaskState.COMPLETED) {
            if (task.type() == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION) {
                this._inExecutionIntraBrokerDataMovementInMB -= dataToMove;
                this._finishedIntraBrokerDataMovementInMB += dataToMove;
            } else if (task.type() == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) {
                this._inExecutionInterBrokerDataMovementInMB -= dataToMove;
                this._finishedInterBrokerDataMovementInMB += dataToMove;
            }
        }
    }

    public void addTasksToTrace(Collection<ExecutionTask> tasks, ExecutionTask.TaskType taskType) {
        this._tasksByType.get((Object)taskType).get((Object)ExecutionTaskState.PENDING).addAll(tasks);
        if (taskType == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) {
            this._remainingInterBrokerDataToMoveInMB += tasks.stream().mapToLong(t -> t.proposal().interBrokerDataToMoveInMB()).sum();
        } else if (taskType == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION) {
            this._remainingIntraBrokerDataToMoveInMB += tasks.stream().mapToLong(t -> t.proposal().intraBrokerDataToMoveInMB()).sum();
        }
    }

    public void setExecutionMode(boolean isKafkaAssignerMode) {
        this._isKafkaAssignerMode = isKafkaAssignerMode;
    }

    private Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Integer>> taskStat() {
        HashMap<ExecutionTask.TaskType, Map<ExecutionTaskState, Integer>> taskStatMap = new HashMap<ExecutionTask.TaskType, Map<ExecutionTaskState, Integer>>(ExecutionTask.TaskType.cachedValues().size());
        for (ExecutionTask.TaskType type : ExecutionTask.TaskType.cachedValues()) {
            taskStatMap.put(type, new HashMap());
            this._tasksByType.get((Object)type).forEach((k, v) -> ((Map)taskStatMap.get((Object)type)).put(k, v.size()));
        }
        return taskStatMap;
    }

    private Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> filteredTasksByState(Set<ExecutionTask.TaskType> taskTypesToGetFullList) {
        HashMap<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> tasksByState = new HashMap<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>>(taskTypesToGetFullList.size());
        for (ExecutionTask.TaskType type : taskTypesToGetFullList) {
            tasksByState.put(type, new HashMap());
            this._tasksByType.get((Object)type).forEach((k, v) -> ((Map)tasksByState.get((Object)type)).put(k, new HashSet(v)));
        }
        return tasksByState;
    }

    public void clear() {
        this._tasksByType.values().forEach(m -> m.values().forEach(Set::clear));
        this._remainingInterBrokerDataToMoveInMB = 0L;
        this._remainingIntraBrokerDataToMoveInMB = 0L;
        this._inExecutionInterBrokerDataMovementInMB = 0L;
        this._inExecutionIntraBrokerDataMovementInMB = 0L;
        this._finishedInterBrokerDataMovementInMB = 0L;
        this._finishedIntraBrokerDataMovementInMB = 0L;
        this._stopRequested = false;
    }

    public void setStopRequested() {
        this._stopRequested = true;
    }

    public int numRemainingInterBrokerPartitionMovements() {
        return this._tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.PENDING).size();
    }

    public long remainingInterBrokerDataToMoveInMB() {
        return this._remainingInterBrokerDataToMoveInMB;
    }

    public int numFinishedInterBrokerPartitionMovements() {
        return this._tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.COMPLETED).size() + this._tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.DEAD).size() + this._tasksByType.get((Object)ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.ABORTED).size();
    }

    public long finishedInterBrokerDataMovementInMB() {
        return this._finishedInterBrokerDataMovementInMB;
    }

    public Set<ExecutionTask> inExecutionTasks(Collection<ExecutionTask.TaskType> types) {
        HashSet<ExecutionTask> inExecutionTasks = new HashSet<ExecutionTask>();
        for (ExecutionTask.TaskType type : types) {
            inExecutionTasks.addAll((Collection<ExecutionTask>)this._tasksByType.get((Object)type).get((Object)ExecutionTaskState.IN_PROGRESS));
            inExecutionTasks.addAll((Collection<ExecutionTask>)this._tasksByType.get((Object)type).get((Object)ExecutionTaskState.ABORTING));
        }
        return inExecutionTasks;
    }

    public long inExecutionInterBrokerDataMovementInMB() {
        return this._inExecutionInterBrokerDataMovementInMB;
    }

    public int numRemainingLeadershipMovements() {
        return this._tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.PENDING).size();
    }

    public int numFinishedLeadershipMovements() {
        return this._tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.COMPLETED).size() + this._tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.DEAD).size() + this._tasksByType.get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTaskState.ABORTED).size();
    }

    public int numRemainingIntraBrokerPartitionMovements() {
        return this._tasksByType.get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.PENDING).size();
    }

    public long remainingIntraBrokerDataToMoveInMB() {
        return this._remainingIntraBrokerDataToMoveInMB;
    }

    public int numFinishedIntraBrokerPartitionMovements() {
        return this._tasksByType.get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.COMPLETED).size() + this._tasksByType.get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.DEAD).size() + this._tasksByType.get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION).get((Object)ExecutionTaskState.ABORTED).size();
    }

    public long finishedIntraBrokerDataToMoveInMB() {
        return this._finishedIntraBrokerDataMovementInMB;
    }

    public long inExecutionIntraBrokerDataMovementInMB() {
        return this._inExecutionIntraBrokerDataMovementInMB;
    }

    public ExecutionTasksSummary getExecutionTasksSummary(Set<ExecutionTask.TaskType> taskTypesToGetFullList) {
        return new ExecutionTasksSummary(this._finishedInterBrokerDataMovementInMB, this._finishedIntraBrokerDataMovementInMB, this._inExecutionInterBrokerDataMovementInMB, this._inExecutionIntraBrokerDataMovementInMB, this._remainingInterBrokerDataToMoveInMB, this._remainingIntraBrokerDataToMoveInMB, this.taskStat(), this.filteredTasksByState(taskTypesToGetFullList));
    }

    public static class ExecutionTasksSummary {
        private final long _finishedInterBrokerDataMovementInMB;
        private final long _finishedIntraBrokerDataMovementInMB;
        private final long _inExecutionInterBrokerDataMovementInMB;
        private final long _inExecutionIntraBrokerDataMovementInMB;
        private final long _remainingInterBrokerDataToMoveInMB;
        private final long _remainingIntraBrokerDataToMoveInMB;
        private final Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Integer>> _taskStat;
        private final Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> _filteredTasksByState;

        ExecutionTasksSummary(long finishedInterBrokerDataMovementInMB, long finishedIntraBrokerDataMovementInMB, long inExecutionInterBrokerDataMovementInMB, long inExecutionIntraBrokerDataMovementInMB, long remainingInterBrokerDataToMoveInMB, long remainingIntraBrokerDataToMoveInMB, Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Integer>> taskStat, Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> filteredTasksByState) {
            this._finishedInterBrokerDataMovementInMB = finishedInterBrokerDataMovementInMB;
            this._finishedIntraBrokerDataMovementInMB = finishedIntraBrokerDataMovementInMB;
            this._inExecutionInterBrokerDataMovementInMB = inExecutionInterBrokerDataMovementInMB;
            this._inExecutionIntraBrokerDataMovementInMB = inExecutionIntraBrokerDataMovementInMB;
            this._remainingInterBrokerDataToMoveInMB = remainingInterBrokerDataToMoveInMB;
            this._remainingIntraBrokerDataToMoveInMB = remainingIntraBrokerDataToMoveInMB;
            this._taskStat = taskStat;
            this._filteredTasksByState = filteredTasksByState;
        }

        public long finishedInterBrokerDataMovementInMB() {
            return this._finishedInterBrokerDataMovementInMB;
        }

        public long finishedIntraBrokerDataMovementInMB() {
            return this._finishedIntraBrokerDataMovementInMB;
        }

        public long inExecutionInterBrokerDataMovementInMB() {
            return this._inExecutionInterBrokerDataMovementInMB;
        }

        public long inExecutionIntraBrokerDataMovementInMB() {
            return this._inExecutionIntraBrokerDataMovementInMB;
        }

        public long remainingInterBrokerDataToMoveInMB() {
            return this._remainingInterBrokerDataToMoveInMB;
        }

        public long remainingIntraBrokerDataToMoveInMB() {
            return this._remainingIntraBrokerDataToMoveInMB;
        }

        public Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Integer>> taskStat() {
            return this._taskStat;
        }

        public Map<ExecutionTask.TaskType, Map<ExecutionTaskState, Set<ExecutionTask>>> filteredTasksByState() {
            return this._filteredTasksByState;
        }
    }
}

